/*
 * Decompiled with CFR 0.152.
 */
package net.freeutils.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.Arrays;

public abstract class ByteLookupCharset
extends Charset {
    final int[] byteToChar;
    final int[][] charToByte;

    public static int[] createTable() {
        int[] table = new int[256];
        Arrays.fill(table, -1);
        return table;
    }

    public static int[] mutate(int[] src, int[] indices, int[] values) {
        int[] mutated = new int[src.length];
        System.arraycopy(src, 0, mutated, 0, src.length);
        for (int i = 0; i < indices.length; ++i) {
            mutated[indices[i]] = values[i];
        }
        return mutated;
    }

    public static int[][] createInverseLookupTable(int[] chars) {
        int[][] tables = new int[256][];
        for (int i = 0; i < 256; ++i) {
            int c = chars[i];
            if (c <= -1) continue;
            ByteLookupCharset.updateInverseLookupTable((int[][])tables, c, i);
        }
        return tables;
    }

    public static int[][] updateInverseLookupTable(int[][] tables, int c, int b) {
        int high = c >>> 8 & 0xFF;
        int low = c & 0xFF;
        int[] table = tables[high];
        if (table != null) {
            table[low] = b;
        } else if (b > -1) {
            table = ByteLookupCharset.createTable();
            tables[high] = table;
            table[low] = b;
        }
        return tables;
    }

    public static int[][] updateInverseLookupTable(int[][] tables, int[] chars, int[] bytes) {
        for (int i = 0; i < chars.length; ++i) {
            ByteLookupCharset.updateInverseLookupTable(tables, chars[i], bytes[i]);
        }
        return tables;
    }

    protected ByteLookupCharset(String canonicalName, String[] aliases, int[] byteToChar, int[][] charToByte) {
        super(canonicalName, aliases);
        this.byteToChar = byteToChar;
        this.charToByte = charToByte;
    }

    public boolean contains(Charset charset) {
        return this.getClass().isInstance(charset);
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    protected class Decoder
    extends CharsetDecoder {
        protected Decoder(Charset charset) {
            super(charset, 1.0f, 1.0f);
        }

        protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
            int[] lookup = ByteLookupCharset.this.byteToChar;
            int remainingIn = in.remaining();
            int remainingOut = out.remaining();
            while (remainingIn-- > 0) {
                if (remainingOut-- < 1) {
                    return CoderResult.OVERFLOW;
                }
                int c = lookup[in.get() & 0xFF];
                if (c == -1) {
                    in.position(in.position() - 1);
                    return CoderResult.malformedForLength(1);
                }
                out.put((char)c);
            }
            return CoderResult.UNDERFLOW;
        }
    }

    protected class Encoder
    extends CharsetEncoder {
        protected Encoder(Charset charset) {
            super(charset, 1.0f, 1.0f);
        }

        protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
            int[][] lookup = ByteLookupCharset.this.charToByte;
            int remainingIn = in.remaining();
            int remainingOut = out.remaining();
            while (remainingIn-- > 0) {
                int b;
                if (remainingOut-- < 1) {
                    return CoderResult.OVERFLOW;
                }
                char c = in.get();
                int[] table = lookup[c >>> 8];
                int n = b = table == null ? -1 : table[c & 0xFF];
                if (b == -1) {
                    in.position(in.position() - 1);
                    return CoderResult.unmappableForLength(1);
                }
                out.put((byte)(b & 0xFF));
            }
            return CoderResult.UNDERFLOW;
        }
    }
}

