/*
 * Decompiled with CFR 0.152.
 */
package davmail.http;

import java.io.IOException;
import java.util.BitSet;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.http.Consts;

public class URIUtil {
    protected static final BitSet percent;
    protected static final BitSet digit;
    protected static final BitSet alpha;
    protected static final BitSet alphanum;
    protected static final BitSet hex;
    protected static final BitSet escaped;
    protected static final BitSet mark;
    protected static final BitSet unreserved;
    protected static final BitSet reserved;
    protected static final BitSet uric;
    protected static final BitSet pchar;
    protected static final BitSet param;
    protected static final BitSet segment;
    protected static final BitSet path_segments;
    protected static final BitSet abs_path;
    public static final BitSet allowed_abs_path;
    public static final BitSet allowed_query;
    public static final BitSet allowed_within_query;

    public static String decode(String escaped) throws IOException {
        try {
            return URIUtil.getString(URLCodec.decodeUrl(URIUtil.getAsciiBytes(escaped)));
        }
        catch (DecoderException e) {
            throw new IOException(e.getMessage());
        }
    }

    public static String encodePath(String unescaped) {
        return URIUtil.encode(unescaped, allowed_abs_path);
    }

    public static String encode(String unescaped, BitSet allowed) {
        return URIUtil.getAsciiString(URLCodec.encodeUrl(allowed, URIUtil.getBytes(unescaped)));
    }

    public static String encodeWithinQuery(String unescaped) {
        return URIUtil.encode(unescaped, allowed_within_query);
    }

    public static String encodePathQuery(String unescaped) {
        int at = unescaped.indexOf(63);
        if (at < 0) {
            return URIUtil.encode(unescaped, allowed_abs_path);
        }
        return URIUtil.encode(unescaped.substring(0, at), allowed_abs_path) + '?' + URIUtil.encode(unescaped.substring(at + 1), allowed_query);
    }

    public static byte[] getBytes(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        return value.getBytes(Consts.UTF_8);
    }

    public static byte[] getAsciiBytes(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        return value.getBytes(Consts.ASCII);
    }

    public static String getAsciiString(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        return new String(bytes, Consts.ASCII);
    }

    public static String getString(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        return new String(bytes, Consts.UTF_8);
    }

    static {
        int i;
        percent = new BitSet(256);
        percent.set(37);
        digit = new BitSet(256);
        for (i = 48; i <= 57; ++i) {
            digit.set(i);
        }
        alpha = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            alpha.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            alpha.set(i);
        }
        alphanum = new BitSet(256);
        alphanum.or(alpha);
        alphanum.or(digit);
        hex = new BitSet(256);
        hex.or(digit);
        for (i = 97; i <= 102; ++i) {
            hex.set(i);
        }
        for (i = 65; i <= 70; ++i) {
            hex.set(i);
        }
        escaped = new BitSet(256);
        escaped.or(percent);
        escaped.or(hex);
        mark = new BitSet(256);
        mark.set(45);
        mark.set(95);
        mark.set(46);
        mark.set(33);
        mark.set(126);
        mark.set(42);
        mark.set(39);
        mark.set(40);
        mark.set(41);
        unreserved = new BitSet(256);
        unreserved.or(alphanum);
        unreserved.or(mark);
        reserved = new BitSet(256);
        reserved.set(59);
        reserved.set(47);
        reserved.set(63);
        reserved.set(58);
        reserved.set(64);
        reserved.set(38);
        reserved.set(61);
        reserved.set(43);
        reserved.set(36);
        reserved.set(44);
        uric = new BitSet(256);
        uric.or(reserved);
        uric.or(unreserved);
        uric.or(escaped);
        pchar = new BitSet(256);
        pchar.or(unreserved);
        pchar.or(escaped);
        pchar.set(58);
        pchar.set(64);
        pchar.set(38);
        pchar.set(61);
        pchar.set(43);
        pchar.set(36);
        pchar.set(44);
        param = pchar;
        segment = new BitSet(256);
        segment.or(pchar);
        segment.set(59);
        segment.or(param);
        path_segments = new BitSet(256);
        path_segments.set(47);
        path_segments.or(segment);
        abs_path = new BitSet(256);
        abs_path.set(47);
        abs_path.or(path_segments);
        allowed_abs_path = new BitSet(256);
        allowed_abs_path.or(abs_path);
        allowed_abs_path.andNot(percent);
        allowed_abs_path.clear(43);
        allowed_query = new BitSet(256);
        allowed_query.or(uric);
        allowed_query.clear(37);
        allowed_within_query = new BitSet(256);
        allowed_within_query.or(allowed_query);
        allowed_within_query.andNot(reserved);
    }
}

