/*
 * Decompiled with CFR 0.152.
 */
package davmail.http;

import davmail.http.DavGatewayHttpClientFacade;
import davmail.util.IOUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class RestMethod
extends PostMethod {
    protected static final Logger LOGGER = Logger.getLogger(RestMethod.class);
    JSONObject jsonBody;
    JSONObject jsonResponse;

    public RestMethod(String uri) {
        super(uri);
        this.setRequestEntity(new RequestEntity(){
            byte[] content;

            public boolean isRepeatable() {
                return true;
            }

            public void writeRequest(OutputStream outputStream) throws IOException {
                if (this.content == null) {
                    this.content = RestMethod.this.getJsonContent();
                }
                outputStream.write(this.content);
            }

            public long getContentLength() {
                if (this.content == null) {
                    this.content = RestMethod.this.getJsonContent();
                }
                return this.content.length;
            }

            public String getContentType() {
                return "application/json; charset=UTF-8";
            }
        });
    }

    public void setJsonBody(JSONObject jsonBody) {
        this.jsonBody = jsonBody;
    }

    public JSONObject getJsonResponse() {
        return this.jsonResponse;
    }

    protected byte[] getJsonContent() {
        return this.jsonBody.toString().getBytes(StandardCharsets.UTF_8);
    }

    protected void processResponseBody(HttpState httpState, HttpConnection httpConnection) {
        Header contentTypeHeader = this.getResponseHeader("Content-Type");
        if (contentTypeHeader != null && "application/json; charset=utf-8".equals(contentTypeHeader.getValue())) {
            try {
                if (DavGatewayHttpClientFacade.isGzipEncoded((HttpMethod)this)) {
                    this.processResponseStream(new GZIPInputStream(this.getResponseBodyAsStream()));
                } else {
                    this.processResponseStream(this.getResponseBodyAsStream());
                }
            }
            catch (IOException | JSONException e) {
                LOGGER.error((Object)("Error while parsing json response: " + e), e);
            }
        }
    }

    private void processResponseStream(InputStream responseBodyAsStream) throws IOException, JSONException {
        this.jsonResponse = new JSONObject(new String(IOUtil.readFully(responseBodyAsStream), StandardCharsets.UTF_8));
    }
}

