/*
 * Decompiled with CFR 0.152.
 */
package davmail.exchange;

import davmail.exchange.ExchangeSession;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.log4j.Logger;

public final class XMLStreamUtil {
    private static final Logger LOGGER = Logger.getLogger(XMLStreamUtil.class);

    private XMLStreamUtil() {
    }

    public static XMLInputFactory getXmlInputFactory() {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        inputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        inputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.TRUE);
        inputFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        return inputFactory;
    }

    public static Map<String, Map<String, String>> getElementContentsAsMap(InputStream inputStream, String rowName, String idName) throws IOException {
        HashMap<String, Map<String, String>> results = new HashMap<String, Map<String, String>>();
        HashMap<String, String> item = null;
        String currentElement = null;
        XMLStreamReader reader = null;
        try {
            XMLInputFactory inputFactory = XMLStreamUtil.getXmlInputFactory();
            reader = inputFactory.createXMLStreamReader(inputStream);
            while (reader.hasNext()) {
                int event = reader.next();
                if (event == 1 && rowName.equals(reader.getLocalName())) {
                    item = new HashMap<String, String>();
                    continue;
                }
                if (event == 2 && rowName.equals(reader.getLocalName())) {
                    if (item != null && item.containsKey(idName)) {
                        results.put(((String)item.get(idName)).toLowerCase(), item);
                    }
                    item = null;
                    continue;
                }
                if (event == 1 && item != null) {
                    currentElement = reader.getLocalName();
                    continue;
                }
                if (event != 4 || currentElement == null) continue;
                String text = reader.getText();
                if (item != null) {
                    item.put(currentElement, text);
                }
                currentElement = null;
            }
        }
        catch (XMLStreamException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (XMLStreamException e) {
                ExchangeSession.LOGGER.error((Object)e);
            }
        }
        return results;
    }

    public static boolean isStartTag(XMLStreamReader reader, String tagLocalName) {
        return reader.getEventType() == 1 && reader.getLocalName().equals(tagLocalName);
    }

    public static boolean isStartTag(XMLStreamReader reader) {
        return reader.getEventType() == 1;
    }

    public static boolean isEndTag(XMLStreamReader reader, String tagLocalName) {
        return reader.getEventType() == 2 && reader.getLocalName().equals(tagLocalName);
    }

    public static XMLStreamReader createXMLStreamReader(byte[] xmlContent) throws XMLStreamException {
        return XMLStreamUtil.createXMLStreamReader(new ByteArrayInputStream(xmlContent));
    }

    public static XMLStreamReader createXMLStreamReader(String xmlContent) throws XMLStreamException {
        XMLInputFactory xmlInputFactory = XMLStreamUtil.getXmlInputFactory();
        return xmlInputFactory.createXMLStreamReader(new StringReader(xmlContent));
    }

    public static XMLStreamReader createXMLStreamReader(InputStream inputStream) throws XMLStreamException {
        XMLInputFactory xmlInputFactory = XMLStreamUtil.getXmlInputFactory();
        return xmlInputFactory.createXMLStreamReader(inputStream);
    }

    public static String getElementText(XMLStreamReader reader) {
        String value = null;
        try {
            value = reader.getElementText();
        }
        catch (RuntimeException | XMLStreamException e) {
            LOGGER.warn((Object)e.getMessage());
        }
        return value;
    }
}

