/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.autofilter;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.preferences.ColorProperty;
import org.openstreetmap.josm.gui.autofilter.AutoFilter;
import org.openstreetmap.josm.gui.autofilter.AutoFilterManager;

public class AutoFilterButton
extends JButton {
    private static final ColorProperty PROP_COLOR = new ColorProperty("auto.filter.button.color", new Color(0, 160, 160));
    private final AutoFilter filter;

    public AutoFilterButton(final AutoFilter autoFilter) {
        super(new JosmAction(autoFilter.getLabel(), null, autoFilter.getDescription(), null, false){

            @Override
            public synchronized void actionPerformed(ActionEvent actionEvent) {
                AutoFilterManager autoFilterManager = AutoFilterManager.getInstance();
                if (autoFilterManager.getCurrentAutoFilter() == autoFilter) {
                    autoFilterManager.setCurrentAutoFilter(null);
                    Main.map.filterDialog.getFilterModel().executeFilters();
                } else {
                    autoFilterManager.setCurrentAutoFilter(autoFilter);
                }
            }
        });
        this.filter = autoFilter;
        this.setForeground(Color.WHITE);
        this.setContentAreaFilled(false);
        this.setBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7));
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this.getModel().isPressed()) {
            graphics.setColor(PROP_COLOR.get().darker().darker());
        } else if (this.getModel().isRollover() || AutoFilterManager.getInstance().getCurrentAutoFilter() == this.filter) {
            graphics.setColor(PROP_COLOR.get().darker());
        } else {
            graphics.setColor(PROP_COLOR.get());
        }
        if (graphics instanceof Graphics2D) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        graphics.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), 3, 3);
        super.paintComponent(graphics);
    }
}

