/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.utils.threadpool;

import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.jcs.utils.config.PropertySetter;
import org.apache.commons.jcs.utils.threadpool.DaemonThreadFactory;
import org.apache.commons.jcs.utils.threadpool.PoolConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ThreadPoolManager {
    private static final Log log = LogFactory.getLog(ThreadPoolManager.class);
    private PoolConfiguration defaultConfig;
    private static final String PROP_NAME_ROOT = "thread_pool";
    private static final String DEFAULT_PROP_NAME_ROOT = "thread_pool.default";
    private static final String PROP_NAME_SCHEDULER_ROOT = "scheduler_pool";
    private static final String DEFAULT_PROP_NAME_SCHEDULER_ROOT = "scheduler_pool.default";
    private static volatile Properties props = null;
    private static ThreadPoolManager INSTANCE = null;
    private ConcurrentHashMap<String, ExecutorService> pools = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ScheduledExecutorService> schedulerPools = new ConcurrentHashMap();

    private ThreadPoolManager() {
        this.configure();
    }

    public ExecutorService createPool(PoolConfiguration poolConfiguration, String string) {
        return this.createPool(poolConfiguration, string, 5);
    }

    public ExecutorService createPool(PoolConfiguration poolConfiguration, String string, int n) {
        LinkedBlockingQueue<Runnable> linkedBlockingQueue = null;
        if (poolConfiguration.isUseBoundary()) {
            if (log.isDebugEnabled()) {
                log.debug("Creating a Bounded Buffer to use for the pool");
            }
            linkedBlockingQueue = new LinkedBlockingQueue(poolConfiguration.getBoundarySize());
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Creating a non bounded Linked Queue to use for the pool");
            }
            linkedBlockingQueue = new LinkedBlockingQueue<Runnable>();
        }
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(poolConfiguration.getStartUpSize(), poolConfiguration.getMaximumPoolSize(), (long)poolConfiguration.getKeepAliveTime(), TimeUnit.MILLISECONDS, linkedBlockingQueue, new DaemonThreadFactory(string, n));
        switch (poolConfiguration.getWhenBlockedPolicy()) {
            case ABORT: {
                threadPoolExecutor.setRejectedExecutionHandler(new ThreadPoolExecutor.AbortPolicy());
                break;
            }
            case RUN: {
                threadPoolExecutor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
                break;
            }
            case WAIT: {
                throw new RuntimeException("POLICY_WAIT no longer supported");
            }
            case DISCARDOLDEST: {
                threadPoolExecutor.setRejectedExecutionHandler(new ThreadPoolExecutor.DiscardOldestPolicy());
                break;
            }
        }
        threadPoolExecutor.prestartAllCoreThreads();
        return threadPoolExecutor;
    }

    public ScheduledExecutorService createSchedulerPool(PoolConfiguration poolConfiguration, String string, int n) {
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(poolConfiguration.getMaximumPoolSize(), new DaemonThreadFactory(string, n));
        return scheduledExecutorService;
    }

    public static synchronized ThreadPoolManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ThreadPoolManager();
        }
        return INSTANCE;
    }

    public static synchronized void dispose() {
        if (INSTANCE != null) {
            for (ExecutorService executorService : ThreadPoolManager.INSTANCE.pools.values()) {
                try {
                    executorService.shutdownNow();
                }
                catch (Throwable throwable) {
                    log.warn("Failed to close pool " + executorService, throwable);
                }
            }
            for (ScheduledExecutorService scheduledExecutorService : ThreadPoolManager.INSTANCE.schedulerPools.values()) {
                try {
                    scheduledExecutorService.shutdownNow();
                }
                catch (Throwable throwable) {
                    log.warn("Failed to close pool " + scheduledExecutorService, throwable);
                }
            }
            INSTANCE = null;
        }
    }

    public ExecutorService getExecutorService(String string) {
        ExecutorService executorService = this.pools.get(string);
        if (executorService == null) {
            PoolConfiguration poolConfiguration;
            ExecutorService executorService2;
            if (log.isDebugEnabled()) {
                log.debug("Creating pool for name [" + string + "]");
            }
            if ((executorService = this.pools.putIfAbsent(string, executorService2 = this.createPool(poolConfiguration = this.loadConfig("thread_pool." + string), "JCS-ThreadPoolManager-" + string + "-"))) == null) {
                executorService = executorService2;
            } else {
                executorService2.shutdownNow();
            }
            if (log.isDebugEnabled()) {
                log.debug("PoolName = " + this.getPoolNames());
            }
        }
        return executorService;
    }

    @Deprecated
    public ThreadPoolExecutor getPool(String string) {
        return (ThreadPoolExecutor)this.getExecutorService(string);
    }

    public ScheduledExecutorService getSchedulerPool(String string) {
        ScheduledExecutorService scheduledExecutorService = this.schedulerPools.get(string);
        if (scheduledExecutorService == null) {
            if (log.isDebugEnabled()) {
                log.debug("Creating scheduler pool for name [" + string + "]");
            }
            PoolConfiguration poolConfiguration = this.loadConfig(DEFAULT_PROP_NAME_SCHEDULER_ROOT);
            PoolConfiguration poolConfiguration2 = this.loadConfig("scheduler_pool." + string, poolConfiguration);
            ScheduledExecutorService scheduledExecutorService2 = this.createSchedulerPool(poolConfiguration2, "JCS-ThreadPoolManager-" + string + "-", 5);
            scheduledExecutorService = this.schedulerPools.putIfAbsent(string, scheduledExecutorService2);
            if (scheduledExecutorService == null) {
                scheduledExecutorService = scheduledExecutorService2;
            } else {
                scheduledExecutorService2.shutdownNow();
            }
        }
        return scheduledExecutorService;
    }

    public ArrayList<String> getPoolNames() {
        return new ArrayList<String>(this.pools.keySet());
    }

    public static void setProps(Properties properties) {
        props = properties;
    }

    private void configure() {
        if (log.isDebugEnabled()) {
            log.debug("Initializing ThreadPoolManager");
        }
        if (props == null) {
            log.warn("No configuration settings found.  Using hardcoded default values for all pools.");
            props = new Properties();
        }
        this.defaultConfig = new PoolConfiguration();
        this.defaultConfig = this.loadConfig(DEFAULT_PROP_NAME_ROOT);
    }

    private PoolConfiguration loadConfig(String string) {
        return this.loadConfig(string, this.defaultConfig);
    }

    private PoolConfiguration loadConfig(String string, PoolConfiguration poolConfiguration) {
        PoolConfiguration poolConfiguration2 = poolConfiguration.clone();
        PropertySetter.setProperties(poolConfiguration2, props, string + ".");
        if (log.isDebugEnabled()) {
            log.debug(string + " PoolConfiguration = " + poolConfiguration2);
        }
        return poolConfiguration2;
    }
}

