/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.dataimport.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.io.File;
import java.text.NumberFormat;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.OkClosePanel;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DialogWidget;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class ImportFileDialog
extends DialogWidget {
    private static final StringManager stringMgr = StringManagerFactory.getStringManager(ImportFileDialog.class);
    JTable tblPreview;
    JTable tblMapping;
    JCheckBox chkHeadersIncluded;
    JToggleButton btnSuggestColumns;
    JToggleButton btnOneToOneMapping;
    JCheckBox chkEmptyTableBeforeImport;
    JLabel lblEmptyTableWarning;
    JCheckBox chkTrimValues;
    JCheckBox chkSafeMode;
    OkClosePanel btnsPnl = new OkClosePanel();
    JCheckBox chkSingleTransaction;
    JFormattedTextField txtCommitAfterInserts;
    JLabel lblCommitAfterInsertBegin;
    JLabel lblCommitAfterInsertEnd;

    public ImportFileDialog(File importFile, String importFileTypeDescription, ITableInfo table) {
        super(stringMgr.getString("ImportFileDialog.title", new Object[]{importFileTypeDescription, table.getSimpleName()}), true, Main.getApplication());
        this.setDefaultCloseOperation(2);
        this.makeToolWindow(true);
        JPanel content = new JPanel(new BorderLayout());
        content.add(this.createMainPanel(importFile), "Center");
        this.setContentPane(content);
        this.btnsPnl.makeOKButtonDefault();
        this.btnsPnl.getRootPane().setDefaultButton(this.btnsPnl.getOKButton());
    }

    private Component createMainPanel(File importFile) {
        this.tblPreview = new JTable();
        this.tblPreview.setAutoResizeMode(0);
        JScrollPane scrollPane = new JScrollPane(this.tblPreview);
        this.tblMapping = new JTable();
        JScrollPane scrollPane2 = new JScrollPane(this.tblMapping);
        this.chkHeadersIncluded = new JCheckBox(stringMgr.getString("ImportFileDialog.headersIncluded"));
        this.chkHeadersIncluded.setToolTipText(stringMgr.getString("ImportFileDialog.headersIncluded.tooltip"));
        this.chkHeadersIncluded.setSelected(true);
        this.chkTrimValues = new JCheckBox(stringMgr.getString("ImportFileDialog.trim.values"));
        this.chkTrimValues.setToolTipText(stringMgr.getString("ImportFileDialog.trim.values.tooltip"));
        this.chkTrimValues.setSelected(true);
        this.chkSafeMode = new JCheckBox(stringMgr.getString("ImportFileDialog.safetySwitch"));
        this.chkSafeMode.setSelected(true);
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 10, 10), 0, 0);
        ret.add((Component)new JLabel(stringMgr.getString("ImportFileDialog.dataPreview", new Object[]{importFile.getAbsolutePath()})), gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 10, 10, 10), 0, 0);
        ret.add((Component)this.chkHeadersIncluded, gbc);
        gbc = new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 10, 10, 10), 0, 0);
        ret.add((Component)scrollPane, gbc);
        gbc = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 10, 10, 10), 0, 0);
        ret.add((Component)this.createToggleButtonsPanel(), gbc);
        gbc = new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 10, 10, 10), 0, 0);
        ret.add((Component)this.createEmptyTablePanel(), gbc);
        gbc = new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 10, 10, 10), 0, 0);
        ret.add((Component)this.chkTrimValues, gbc);
        gbc = new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 10, 10, 10), 0, 0);
        ret.add((Component)this.createTransactionPanel(), gbc);
        gbc = new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 10, 10, 10), 0, 0);
        ret.add((Component)this.chkSafeMode, gbc);
        gbc = new GridBagConstraints(0, 8, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 10, 10, 10), 0, 0);
        ret.add((Component)scrollPane2, gbc);
        gbc = new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 10, 10, 10), 0, 0);
        ret.add((Component)this.btnsPnl, gbc);
        return ret;
    }

    private JPanel createToggleButtonsPanel() {
        JPanel ret = new JPanel(new GridLayout(1, 2, 10, 10));
        this.btnSuggestColumns = new JToggleButton(stringMgr.getString("ImportFileDialog.suggestColumns"));
        this.btnSuggestColumns.setToolTipText(stringMgr.getString("ImportFileDialog.suggestColumns.tooltip"));
        this.btnSuggestColumns.setSelected(false);
        ret.add(this.btnSuggestColumns);
        this.btnOneToOneMapping = new JToggleButton(stringMgr.getString("ImportFileDialog.oneToOneMapping"));
        this.btnOneToOneMapping.setToolTipText(stringMgr.getString("ImportFileDialog.oneToOneMapping.tooltip"));
        this.btnOneToOneMapping.setSelected(false);
        ret.add(this.btnOneToOneMapping);
        return ret;
    }

    private JPanel createEmptyTablePanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        this.chkEmptyTableBeforeImport = new JCheckBox(stringMgr.getString("ImportFileDialog.empty.table"));
        ret.add((Component)this.chkEmptyTableBeforeImport, gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0);
        this.lblEmptyTableWarning = new JLabel();
        this.lblEmptyTableWarning.setFont(this.lblEmptyTableWarning.getFont().deriveFont(1));
        this.lblEmptyTableWarning.setForeground(Color.red);
        ret.add((Component)this.lblEmptyTableWarning, gbc);
        return ret;
    }

    private JPanel createTransactionPanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        this.chkSingleTransaction = new JCheckBox(stringMgr.getString("ImportFileDialog.singleTransaction"));
        ret.add((Component)this.chkSingleTransaction, gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0);
        this.lblCommitAfterInsertBegin = new JLabel(stringMgr.getString("ImportFileDialog.commitAfterInsert.begin"));
        ret.add((Component)this.lblCommitAfterInsertBegin, gbc);
        gbc = new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0);
        this.txtCommitAfterInserts = new JFormattedTextField(NumberFormat.getInstance());
        this.txtCommitAfterInserts.setColumns(7);
        ret.add((Component)this.txtCommitAfterInserts, gbc);
        gbc = new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0);
        this.lblCommitAfterInsertEnd = new JLabel(stringMgr.getString("ImportFileDialog.commitAfterInsert.end"));
        ret.add((Component)this.lblCommitAfterInsertEnd, gbc);
        gbc = new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        ret.add((Component)new JPanel(), gbc);
        this.chkSingleTransaction.setSelected(true);
        return ret;
    }
}

