/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.sqlbookmark;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sourceforge.squirrel_sql.client.session.ISQLEntryPanel;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.gui.PropertyPanel;
import net.sourceforge.squirrel_sql.fw.util.ICommand;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.sqlbookmark.Bookmark;
import net.sourceforge.squirrel_sql.plugins.sqlbookmark.SQLBookmarkPlugin;

public class RunBookmarkCommand
implements ICommand {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(RunBookmarkCommand.class);
    private final Frame frame;
    private final ISession session;
    private SQLBookmarkPlugin plugin;
    private Bookmark bookmark;
    private ISQLEntryPanel _sqlEntryPanel;

    public RunBookmarkCommand(Frame frame, ISession session, Bookmark bookmark, SQLBookmarkPlugin plugin, ISQLEntryPanel sqlEntryPanel) throws IllegalArgumentException {
        this._sqlEntryPanel = sqlEntryPanel;
        if (session == null) {
            throw new IllegalArgumentException("Null ISession passed");
        }
        if (plugin == null) {
            throw new IllegalArgumentException("Null IPlugin passed");
        }
        this.frame = frame;
        this.session = session;
        this.plugin = plugin;
        this.bookmark = bookmark;
    }

    public void execute() {
        String sql;
        if (this.session != null && null != (sql = this.parseAndLoadSql(this.bookmark.getSql()))) {
            int caretPosition = this._sqlEntryPanel.getCaretPosition();
            this._sqlEntryPanel.replaceSelection(sql);
            this._sqlEntryPanel.setCaretPosition(caretPosition + sql.length());
        }
    }

    protected String parseAndLoadSql(String sql) {
        Parameter parameter;
        int ridx;
        ArrayList<Object> itemsInSql = new ArrayList<Object>();
        HashMap<String, Parameter> paramsById = new HashMap<String, Parameter>();
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        HashMap<String, Parameter> lookup = new HashMap<String, Parameter>();
        int start = 0;
        int idx = 0;
        while ((idx = sql.indexOf("${", start)) >= 0 && (ridx = sql.indexOf("}", idx)) >= 0) {
            String arg = sql.substring(idx + 2, ridx);
            itemsInSql.add(sql.substring(start, idx));
            start = ridx + 1;
            StringTokenizer st = new StringTokenizer(arg, ",");
            parameter = new Parameter();
            if (arg.startsWith("ref=")) {
                String ref = st.nextToken();
                parameter.reference = ref.substring(4);
            } else if (arg.startsWith("id=")) {
                String id = st.nextToken();
                String prompt = st.nextToken();
                parameter.id = id.substring(3);
                parameter.prompt = prompt;
                if (st.countTokens() > 0) {
                    String tip;
                    parameter.tip = tip = st.nextToken();
                }
            } else {
                String prompt;
                parameter.prompt = prompt = st.nextToken();
                if (st.countTokens() > 0) {
                    String tip;
                    parameter.tip = tip = st.nextToken();
                }
            }
            if (parameter.reference == null) {
                if (lookup.containsKey(parameter.prompt)) {
                    parameter = (Parameter)lookup.get(parameter.prompt);
                } else {
                    lookup.put(parameter.prompt, parameter);
                    parameters.add(parameter);
                }
            }
            if (parameter.id != null) {
                paramsById.put(parameter.id, parameter);
            }
            itemsInSql.add(parameter);
        }
        itemsInSql.add(sql.substring(start));
        DoneAction doneAction = null;
        if (parameters.size() > 0) {
            JDialog dialog = new JDialog(this.frame, s_stringMgr.getString("sqlbookmark.qureyParams"), true);
            Container contentPane = dialog.getContentPane();
            contentPane.setLayout(new BorderLayout());
            PropertyPanel propPane = new PropertyPanel();
            contentPane.add((Component)propPane, "Center");
            for (idx = 0; idx < parameters.size(); ++idx) {
                StringTokenizer st;
                Parameter parameter2 = (Parameter)parameters.get(idx);
                String placeholder = "";
                int pos = 0;
                pos = parameter2.prompt.indexOf("(");
                if (pos >= 0) {
                    int rpos = parameter2.prompt.indexOf(")", pos);
                    if (rpos < 0) break;
                    placeholder = parameter2.prompt.substring(pos + 1, rpos);
                    parameter2.prompt = parameter2.prompt.substring(0, pos);
                } else if (null != parameter2.tip && (pos = parameter2.tip.indexOf("(")) >= 0) {
                    int rpos = parameter2.tip.indexOf(")", pos);
                    if (rpos < 0) break;
                    placeholder = parameter2.tip.substring(pos + 1, rpos);
                    parameter2.tip = parameter2.tip.substring(0, pos);
                }
                JLabel label = new JLabel(parameter2.prompt + ":", 4);
                if (parameter2.tip != null) {
                    label.setToolTipText(parameter2.tip);
                }
                JComponent value = new JTextField(20);
                value.setText(placeholder);
                if (placeholder.length() > 0 && (st = new StringTokenizer(placeholder, "|")).countTokens() > 1) {
                    Vector<String> choices = new Vector<String>();
                    while (st.hasMoreElements()) {
                        choices.add(st.nextToken());
                    }
                    value = new JComboBox(choices);
                }
                propPane.add(label, (Component)value);
                parameter2.value = value;
            }
            JPanel actionPane = new JPanel();
            contentPane.add((Component)actionPane, "South");
            JButton done = new JButton(s_stringMgr.getString("sqlbookmark.btnOk"));
            actionPane.add(done);
            doneAction = new DoneAction(dialog);
            done.addActionListener(doneAction);
            dialog.getRootPane().setDefaultButton(done);
            dialog.setLocationRelativeTo(this.frame);
            dialog.pack();
            dialog.setVisible(true);
        }
        if (null == doneAction || doneAction.actionExecuted()) {
            StringBuffer sqlbuf = new StringBuffer();
            for (idx = 0; idx < itemsInSql.size(); ++idx) {
                Object item = itemsInSql.get(idx);
                if (item instanceof String) {
                    sqlbuf.append((String)item);
                }
                if (!(item instanceof Parameter)) continue;
                parameter = (Parameter)item;
                if (parameter.reference != null) {
                    parameter = (Parameter)paramsById.get(parameter.reference);
                }
                if (parameter.value instanceof JTextField) {
                    sqlbuf.append(((JTextField)parameter.value).getText());
                    continue;
                }
                sqlbuf.append((String)((JComboBox)parameter.value).getSelectedItem());
            }
            return sqlbuf.toString();
        }
        return null;
    }

    static class DoneAction
    implements ActionListener {
        JDialog dialog = null;
        private boolean _actionExecuted;

        public DoneAction(JDialog dialog) {
            this.dialog = dialog;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this._actionExecuted = true;
            this.dialog.dispose();
        }

        public boolean actionExecuted() {
            return this._actionExecuted;
        }
    }

    static class Parameter {
        String reference;
        String id;
        String prompt;
        String tip;
        JComponent value;

        Parameter() {
        }
    }
}

