/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.codetemplates;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lsp.Completion;
import org.netbeans.editor.Abbrev;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.codetemplates.CodeTemplateApiPackageAccessor;
import org.netbeans.lib.editor.codetemplates.CodeTemplateCompletionItem;
import org.netbeans.lib.editor.codetemplates.CodeTemplateManagerOperation;
import org.netbeans.lib.editor.codetemplates.ParametrizedTextParser;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplate;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateFilter;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.netbeans.spi.lsp.CompletionCollector;

public final class CodeTemplateCompletionProvider
implements CompletionProvider {
    public CompletionTask createTask(int type, JTextComponent component) {
        return (type & 1) == 0 || CodeTemplateCompletionProvider.isAbbrevDisabled(component) ? null : new AsyncCompletionTask((AsyncCompletionQuery)new Query(), component);
    }

    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        return 0;
    }

    private static boolean isAbbrevDisabled(JTextComponent component) {
        return Abbrev.isAbbrevDisabled((JTextComponent)component);
    }

    private static final class Query
    extends AsyncCompletionQuery
    implements ChangeListener {
        private JTextComponent component;
        private int queryCaretOffset;
        private int queryAnchorOffset;
        private List<CodeTemplateCompletionItem> queryResult;
        private String filterPrefix;

        private Query() {
        }

        protected void prepareQuery(JTextComponent component) {
            this.component = component;
        }

        protected boolean canFilter(JTextComponent component) {
            if (component.getCaret() == null) {
                return false;
            }
            int caretOffset = component.getSelectionStart();
            Document doc = component.getDocument();
            this.filterPrefix = null;
            if (caretOffset >= this.queryCaretOffset && this.queryAnchorOffset < this.queryCaretOffset) {
                try {
                    this.filterPrefix = doc.getText(this.queryAnchorOffset, caretOffset - this.queryAnchorOffset);
                    if (!this.isJavaIdentifierPart(this.filterPrefix)) {
                        this.filterPrefix = null;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            return this.filterPrefix != null;
        }

        protected void filter(CompletionResultSet resultSet) {
            if (this.filterPrefix != null && this.queryResult != null) {
                resultSet.addAllItems(this.getFilteredData(this.queryResult, this.filterPrefix));
            }
            resultSet.finish();
        }

        private boolean isJavaIdentifierPart(CharSequence text) {
            for (int i = 0; i < text.length(); ++i) {
                if (Character.isJavaIdentifierPart(text.charAt(i))) continue;
                return false;
            }
            return true;
        }

        private Collection<? extends CompletionItem> getFilteredData(Collection<? extends CompletionItem> data, String prefix) {
            ArrayList<CompletionItem> ret = new ArrayList<CompletionItem>();
            for (CompletionItem completionItem : data) {
                if (!completionItem.getInsertPrefix().toString().startsWith(prefix)) continue;
                ret.add(completionItem);
            }
            return ret;
        }

        protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
            this.query(doc, caretOffset, (ct, abbrevBased) -> {
                if (this.queryResult != null) {
                    this.queryResult.add(new CodeTemplateCompletionItem((CodeTemplate)ct, (boolean)abbrevBased));
                }
            });
            if (this.queryResult != null) {
                resultSet.addAllItems(this.queryResult);
            }
            resultSet.setAnchorOffset(this.queryAnchorOffset);
            resultSet.finish();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void query(Document doc, int caretOffset, BiConsumer<CodeTemplate, Boolean> consumer) {
            String langPath = null;
            String identifierBeforeCursor = null;
            if (doc instanceof AbstractDocument) {
                AbstractDocument adoc = (AbstractDocument)doc;
                adoc.readLock();
                try {
                    try {
                        if (adoc instanceof BaseDocument) {
                            identifierBeforeCursor = Utilities.getIdentifierBefore((BaseDocument)((BaseDocument)adoc), (int)caretOffset);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                    List list = TokenHierarchy.get((Document)doc).embeddedTokenSequences(caretOffset, true);
                    if (list.size() > 1) {
                        langPath = ((TokenSequence)list.get(list.size() - 1)).languagePath().mimePath();
                    }
                }
                finally {
                    adoc.readUnlock();
                }
            }
            if (identifierBeforeCursor == null) {
                identifierBeforeCursor = "";
            }
            if (langPath == null) {
                langPath = NbEditorUtilities.getMimeType((Document)doc);
            }
            this.queryCaretOffset = caretOffset;
            this.queryAnchorOffset = caretOffset - identifierBeforeCursor.length();
            if (langPath != null) {
                String mimeType = DocumentUtilities.getMimeType((Document)doc);
                MimePath mimePath = mimeType == null ? MimePath.EMPTY : MimePath.get((String)mimeType);
                Preferences prefs = (Preferences)MimeLookup.getLookup((MimePath)mimePath).lookup(Preferences.class);
                boolean ignoreCase = prefs.getBoolean("completion-case-sensitive", false);
                CodeTemplateManagerOperation op = CodeTemplateManagerOperation.get(MimePath.parse((String)langPath));
                op.waitLoaded();
                Collection<? extends CodeTemplate> ctsPT = op.findByParametrizedText(identifierBeforeCursor, ignoreCase);
                Collection<? extends CodeTemplate> ctsAb = op.findByAbbreviationPrefix(identifierBeforeCursor, ignoreCase);
                Collection<? extends CodeTemplateFilter> filters = CodeTemplateManagerOperation.getTemplateFilters(doc, this.queryAnchorOffset, this.queryAnchorOffset);
                this.queryResult = new ArrayList<CodeTemplateCompletionItem>(ctsPT.size() + ctsAb.size());
                HashSet<String> abbrevs = new HashSet<String>(ctsPT.size() + ctsAb.size());
                for (CodeTemplate codeTemplate : ctsPT) {
                    if (codeTemplate.getContexts() == null || codeTemplate.getContexts().size() <= 0 || !Query.accept(codeTemplate, filters) || !abbrevs.add(codeTemplate.getAbbreviation())) continue;
                    consumer.accept(codeTemplate, false);
                }
                for (CodeTemplate codeTemplate : ctsAb) {
                    if (codeTemplate.getContexts() == null || codeTemplate.getContexts().size() <= 0 || !Query.accept(codeTemplate, filters) || !abbrevs.add(codeTemplate.getAbbreviation())) continue;
                    consumer.accept(codeTemplate, true);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stateChanged(ChangeEvent evt) {
            Query query = this;
            synchronized (query) {
                this.notify();
            }
        }

        private static boolean accept(CodeTemplate template, Collection filters) {
            for (CodeTemplateFilter filter : filters) {
                if (filter.accept(template)) continue;
                return false;
            }
            return true;
        }
    }

    public static class Collector
    implements CompletionCollector {
        private static final String SELECTED_TEXT_VAR = "${0:$TM_SELECTED_TEXT}";
        private static final Pattern SNIPPET_VAR_PATTERN = Pattern.compile("\\$\\{\\s*([-\\w]++)((?:\\s*[-\\w]++(?:\\s*=\\s*(?:\\\"[^\\\"]*\\\"|[-\\w]++))?)*\\s*)?}");
        private static final Pattern SNIPPET_HINT_PATTERN = Pattern.compile("([-\\w]++)(?:\\s*=\\s*(\\\"([^\\\"]*)\\\"|[-\\w]++))?");
        private static final String UNCAUGHT_EXCEPTION_CATCH_STATEMENTS = "uncaughtExceptionCatchStatements";

        public boolean collectCompletions(Document doc, int offset, Completion.Context context, Consumer<Completion> consumer) {
            new Query().query(doc, offset, (ct, abbrevBased) -> {
                String description = ct.getDescription();
                if (description == null) {
                    description = CodeTemplateApiPackageAccessor.get().getSingleLineText((CodeTemplate)ct);
                }
                String label = Collector.html2text(description.trim());
                String sortText = String.format("%04d%s", 1650, "fore".equals(ct.getAbbreviation()) ? label.substring(0, 3) : label);
                consumer.accept(CompletionCollector.newBuilder((String)label).sortText(sortText).documentation(() -> {
                    StringBuffer sb = new StringBuffer("<html><pre>");
                    ParametrizedTextParser.parseToHtml(sb, ct.getParametrizedText());
                    sb.append("</pre>");
                    return sb.toString();
                }).insertText(Collector.convert(ct.getParametrizedText())).insertTextFormat(Completion.TextFormat.Snippet).build());
            });
            return true;
        }

        private static String convert(String s) {
            StringBuilder sb = new StringBuilder();
            Matcher matcher = SNIPPET_VAR_PATTERN.matcher(s);
            int idx = 0;
            HashMap<String, Integer> placeholders = new HashMap<String, Integer>();
            HashMap<String, String> values = new HashMap<String, String>();
            HashSet<String> nonEditables = new HashSet<String>();
            AtomicInteger last = new AtomicInteger();
            while (matcher.find(idx)) {
                String name;
                int start = matcher.start();
                sb.append(s.substring(idx, start));
                switch (name = matcher.group(1)) {
                    case "cursor": 
                    case "no-format": 
                    case "no-indent": {
                        break;
                    }
                    case "selection": {
                        sb.append(SELECTED_TEXT_VAR);
                        break;
                    }
                    default: {
                        String params;
                        String string = params = matcher.groupCount() > 1 ? matcher.group(2) : null;
                        if (params == null || params.isEmpty()) {
                            if (nonEditables.contains(name)) {
                                sb.append(values.getOrDefault(name, ""));
                                break;
                            }
                            sb.append('$').append(placeholders.computeIfAbsent(name, n -> last.incrementAndGet()));
                            break;
                        }
                        Map<String, String> hints = Collector.getHints(params);
                        String defaultValue = hints.get("default");
                        if (defaultValue != null) {
                            values.put(name, defaultValue);
                        }
                        if (hints.containsKey(UNCAUGHT_EXCEPTION_CATCH_STATEMENTS)) {
                            sb.append("catch (${").append(last.incrementAndGet()).append(":Exception} ${").append(last.incrementAndGet()).append(":e}) {\n}");
                            break;
                        }
                        if ("false".equalsIgnoreCase(hints.get("editable"))) {
                            nonEditables.add(name);
                            sb.append(values.getOrDefault(name, ""));
                            break;
                        }
                        if (defaultValue != null) {
                            sb.append("${").append(placeholders.computeIfAbsent(name, n -> last.incrementAndGet())).append(':').append(defaultValue).append('}');
                            break;
                        }
                        sb.append('$').append(placeholders.computeIfAbsent(name, n -> last.incrementAndGet()));
                    }
                }
                idx = matcher.end();
            }
            String tail = s.substring(idx);
            return sb.append(tail.endsWith("\n") ? tail.substring(0, tail.length() - 1) : tail).toString();
        }

        private static Map<String, String> getHints(String text) {
            HashMap<String, String> hint2Values = new HashMap<String, String>();
            Matcher matcher = SNIPPET_HINT_PATTERN.matcher(text);
            int idx = 0;
            while (matcher.find(idx)) {
                String insideString = matcher.groupCount() > 2 ? matcher.group(3) : null;
                String value = matcher.groupCount() > 1 ? matcher.group(2) : null;
                hint2Values.put(matcher.group(1), insideString != null ? insideString : value);
                idx = matcher.end();
            }
            return hint2Values;
        }

        private static String html2text(String html) {
            try {
                final StringBuilder sb = new StringBuilder();
                new ParserDelegator().parse(new StringReader(html), new HTMLEditorKit.ParserCallback(){

                    @Override
                    public void handleText(char[] text, int pos) {
                        sb.append(text);
                    }
                }, Boolean.TRUE);
                return sb.toString();
            }
            catch (IOException ex) {
                return html;
            }
        }
    }
}

