/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.processtreekiller;

import java.util.Map;
import org.jvnet.winp.WinProcess;
import org.jvnet.winp.WinpException;
import org.netbeans.processtreekiller.ProcessTreeKiller;

final class Windows
extends ProcessTreeKiller {
    Windows() {
    }

    @Override
    public void kill(Process proc, Map<String, String> modelEnvVars) {
        if (proc != null) {
            new WinProcess(proc).killRecursively();
        }
        if (modelEnvVars != null) {
            for (WinProcess p : WinProcess.all()) {
                boolean matched;
                if (p.getPid() < 10) continue;
                try {
                    matched = this.hasMatchingEnvVars(p.getEnvironmentVariables(), modelEnvVars);
                }
                catch (WinpException e) {
                    continue;
                }
                if (!matched) continue;
                p.killRecursively();
            }
        }
    }

    static {
        if (System.getProperty("winp.folder.preferred") == null) {
            String userhome = System.getProperty("netbeans.user");
            System.setProperty("winp.folder.preferred", userhome);
        }
        WinProcess.enableDebugPrivilege();
    }
}

