/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.processtreekiller;

import com.sun.jna.IntegerType;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.ByReference;

public interface DarwinCLibrary
extends Library {
    public static final DarwinCLibrary LIBC = (DarwinCLibrary)Native.load((String)"c", DarwinCLibrary.class);
    public static final int sizeOf_kinfo_proc = 648;
    public static final int CTL_KERN = 1;
    public static final int KERN_PROC = 14;
    public static final int KERN_PROC_ALL = 0;
    public static final int KERN_ARGMAX = 8;
    public static final int KERN_PROCARGS2 = 49;

    public String strerror(int var1);

    public int sysctl(int[] var1, int var2, Pointer var3, SizeTByReference var4, Pointer var5, SizeT var6);

    public static class SizeT
    extends IntegerType {
        public SizeT() {
            this(0L);
        }

        public SizeT(long value) {
            super(Native.SIZE_T_SIZE, value, true);
        }
    }

    public static class SizeTByReference
    extends ByReference {
        public SizeTByReference() {
            super(Native.SIZE_T_SIZE);
        }

        public long getValue() {
            if (this.getPointer() == null) {
                return 0L;
            }
            switch (Native.SIZE_T_SIZE) {
                case 1: {
                    return Byte.toUnsignedLong(this.getPointer().getByte(0L));
                }
                case 2: {
                    return Short.toUnsignedLong(this.getPointer().getShort(0L));
                }
                case 4: {
                    return Integer.toUnsignedLong(this.getPointer().getInt(0L));
                }
                case 8: {
                    return this.getPointer().getLong(0L);
                }
            }
            throw new IllegalStateException("Unsupported SIZE_T size: " + Native.SIZE_T_SIZE);
        }

        public void setValue(long value) {
            switch (Native.SIZE_T_SIZE) {
                case 1: {
                    this.getPointer().setByte(0L, (byte)value);
                    return;
                }
                case 2: {
                    this.getPointer().setShort(0L, (short)value);
                    return;
                }
                case 4: {
                    this.getPointer().setInt(0L, (int)value);
                    return;
                }
                case 8: {
                    this.getPointer().setLong(0L, value);
                    return;
                }
            }
            throw new IllegalStateException("Unsupported SIZE_T size: " + Native.SIZE_T_SIZE);
        }
    }
}

