/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cordova.platforms.android;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.SelectionKey;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.netbeans.modules.cordova.platforms.android.AndroidPlatform;
import org.netbeans.modules.cordova.platforms.android.Bundle;
import org.netbeans.modules.cordova.platforms.api.ProcessUtilities;
import org.netbeans.modules.cordova.platforms.api.WebKitDebuggingSupport;
import org.netbeans.modules.cordova.platforms.spi.MobileDebugTransport;
import org.netbeans.modules.netserver.api.ProtocolDraft;
import org.netbeans.modules.netserver.api.WebSocketClient;
import org.netbeans.modules.netserver.api.WebSocketReadHandler;
import org.netbeans.modules.web.webkit.debugging.spi.Command;
import org.netbeans.modules.web.webkit.debugging.spi.Response;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;

public class AndroidDebugTransport
extends MobileDebugTransport
implements WebSocketReadHandler {
    private WebSocketClient webSocket;
    private static final Logger LOGGER = Logger.getLogger(AndroidDebugTransport.class.getName());
    private boolean flush;

    public boolean detach() {
        if (this.webSocket != null) {
            this.webSocket.stop();
        }
        return true;
    }

    public void sendCommandImpl(Command command) {
        String toString = this.translate(command.toString());
        this.webSocket.sendMessage(toString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accepted(SelectionKey key) {
        WebSocketClient webSocketClient = this.webSocket;
        synchronized (webSocketClient) {
            this.webSocket.notifyAll();
        }
    }

    public void read(SelectionKey key, byte[] message, Integer dataType) {
        String string = new String(message, Charset.forName("UTF-8")).trim();
        try {
            Object parse = JSONValue.parseWithException((String)string);
            if (this.callBack == null) {
                LOGGER.info("callBack is null. Ignoring response: " + string);
            } else {
                this.callBack.handleResponse(new Response((JSONObject)parse));
            }
        }
        catch (ParseException ex) {
            Exceptions.attachMessage((Throwable)ex, (String)string);
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void closed(SelectionKey key) {
        WebKitDebuggingSupport.getDefault().stopDebugging(false);
    }

    public String getConnectionName() {
        return "Android";
    }

    public WebSocketClient createWebSocket(WebSocketReadHandler handler) throws IOException {
        URI uri = this.getURI();
        if (uri != null) {
            return new WebSocketClient(uri, ProtocolDraft.getRFC(), handler);
        }
        return null;
    }

    public boolean attach() {
        try {
            String string = ProcessUtilities.callProcess((String)AndroidPlatform.getDefault().getAdbCommand(), (boolean)true, (int)AndroidPlatform.DEFAULT_TIMEOUT, (String[])new String[]{"forward", "tcp:9222", this.getRedirectString()});
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        try {
            this.webSocket = this.createWebSocket(this);
            if (this.webSocket != null) {
                this.webSocket.start();
                return true;
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return false;
    }

    private String getRedirectString() {
        String appName = this.getBundleIdentifier();
        if (appName == null) {
            return "localabstract:chrome_devtools_remote";
        }
        return "localabstract:webview_devtools_remote_" + AndroidPlatform.getDefault().getProcessIdByName(appName);
    }

    public String getVersion() {
        return "1.0";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private URI getURI() {
        JSONArray array = null;
        long stop = System.nanoTime() + TimeUnit.MINUTES.toNanos(2L);
        while (stop > System.nanoTime() && !this.flush) {
            try {
                JSONParser parser = new JSONParser();
                URL chromeJson = new URL("http://localhost:9222/json");
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(chromeJson.openConnection(Proxy.NO_PROXY).getInputStream()));){
                    Object obj = parser.parse((Reader)reader);
                    array = (JSONArray)obj;
                    if (array.size() == 0) {
                        try (BufferedReader r = new BufferedReader(new InputStreamReader(chromeJson.openConnection(Proxy.NO_PROXY).getInputStream()));){
                            String line;
                            while ((line = r.readLine()) != null) {
                                LOGGER.info(line);
                            }
                        }
                    }
                    for (int i = 0; i < array.size(); ++i) {
                        URL conURL;
                        JSONObject object = (JSONObject)array.get(i);
                        String urlFromBrowser = object.get((Object)"url").toString();
                        int hash = urlFromBrowser.indexOf("#");
                        if (hash != -1) {
                            urlFromBrowser = urlFromBrowser.substring(0, hash);
                        }
                        if (urlFromBrowser.endsWith("/")) {
                            urlFromBrowser = urlFromBrowser.substring(0, urlFromBrowser.length() - 1);
                        }
                        if ((conURL = this.getConnectionURL()) == null) {
                            this.setBaseUrl(urlFromBrowser);
                            if (!object.containsKey((Object)"webSocketDebuggerUrl")) continue;
                            URI uRI = new URI(object.get((Object)"webSocketDebuggerUrl").toString());
                            return uRI;
                        }
                        String connectionUrl = conURL.toExternalForm();
                        String shortenedUrl = connectionUrl.replace(":80/", "/");
                        if (!connectionUrl.equals(urlFromBrowser) && !shortenedUrl.equals(urlFromBrowser) || !object.containsKey((Object)"webSocketDebuggerUrl")) continue;
                        URI uRI = new URI(object.get((Object)"webSocketDebuggerUrl").toString());
                        return uRI;
                    }
                }
            }
            catch (IOException | URISyntaxException | ParseException ex) {
                LOGGER.log(Level.FINE, "Cannot get websocket address, trying again...", ex);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ex1) {
                    Exceptions.printStackTrace((Throwable)ex1);
                }
            }
        }
        if (array != null) {
            LOGGER.info(array.toJSONString());
        }
        NotifyDescriptor not = new NotifyDescriptor((Object)Bundle.ERR_CouldNotConnect(), Bundle.LBL_UriTitle(), -1, 2, new Object[]{NotifyDescriptor.OK_OPTION}, null);
        DialogDisplayer.getDefault().notify(not);
        LOGGER.info("Cannot get websocket address.");
        return null;
    }

    public void flush() {
        this.flush = true;
    }
}

