/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.classpath;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.classpath.BasePathSupport;
import org.netbeans.modules.php.project.classpath.BaseProjectPathSupport;
import org.netbeans.modules.php.project.classpath.Bundle;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.util.PhpProjectUtils;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.filesystems.FileObject;

public class IncludePathSupport
extends BaseProjectPathSupport {
    private static final Set<String> WELL_KNOWN_PATHS = new HashSet<String>(Arrays.asList("${php.global.include.path}"));

    public IncludePathSupport(PropertyEvaluator evaluator, ReferenceHelper referenceHelper, AntProjectHelper antProjectHelper) {
        super(evaluator, referenceHelper, antProjectHelper);
    }

    @Override
    protected boolean isWellKnownPath(String p) {
        return WELL_KNOWN_PATHS.contains(p);
    }

    public static final class Validator {
        public static final String ANOTHER_PROJECT_MESSAGE_TYPE = "ANOTHER_PROJECT_MESSAGE_TYPE";
        private final ValidationResult result = new ValidationResult();

        public ValidationResult getResult() {
            return new ValidationResult(this.result);
        }

        public Validator validateBroken(List<BasePathSupport.Item> items) {
            for (BasePathSupport.Item item : items) {
                if (!item.isBroken()) continue;
                this.result.addError(new ValidationResult.Message((Object)item, Bundle.IncludePathSupport_Validator_error_notFound(item.getFilePath())));
            }
            return this;
        }

        public Validator validatePaths(PhpProject project, List<BasePathSupport.Item> items) {
            for (BasePathSupport.Item item : items) {
                if (item.getType() != BasePathSupport.Item.Type.FOLDER || item.isBroken()) continue;
                FileObject fileObject = item.getFileObject(project.getProjectDirectory());
                if (fileObject == null) {
                    this.result.addError(new ValidationResult.Message((Object)item, Bundle.IncludePathSupport_Validator_error_notFound(item.getFilePath())));
                    continue;
                }
                if (CommandUtils.isUnderAnySourceGroup(project, fileObject, false)) {
                    this.result.addError(new ValidationResult.Message((Object)item, Bundle.IncludePathSupport_Validator_error_projectFile(item.getAbsoluteFilePath(project.getProjectDirectory()))));
                    continue;
                }
                if (!Validator.isPartOfAnotherPhpProject(project, fileObject) || Validator.isSourcesDirectory(fileObject)) continue;
                PhpProject phpProject = PhpProjectUtils.getPhpProject(fileObject);
                assert (phpProject != null);
                this.result.addError(new ValidationResult.Message((Object)item, Bundle.IncludePathSupport_Validator_error_anotherProjectSubFile(item.getAbsoluteFilePath(project.getProjectDirectory()), phpProject.getName()), ANOTHER_PROJECT_MESSAGE_TYPE));
            }
            return this;
        }

        private static boolean isPartOfAnotherPhpProject(Project currentProject, FileObject file) {
            PhpProject phpProject = PhpProjectUtils.getPhpProject(file);
            if (phpProject == null) {
                return false;
            }
            return !currentProject.equals(phpProject);
        }

        private static boolean isSourcesDirectory(FileObject file) {
            PhpProject phpProject = PhpProjectUtils.getPhpProject(file);
            if (phpProject == null) {
                return false;
            }
            FileObject sourcesDirectory = ProjectPropertiesSupport.getSourcesDirectory(phpProject);
            if (sourcesDirectory == null) {
                return false;
            }
            return sourcesDirectory.equals(file);
        }
    }
}

