/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.spi.phpmodule.ImportantFilesImplementation;
import org.netbeans.modules.web.common.spi.ImportantFilesImplementation;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public final class ImportantFilesImpl
implements org.netbeans.modules.web.common.spi.ImportantFilesImplementation,
LookupListener,
ChangeListener {
    private final PhpProject phpProject;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    @NullAllowed
    private Lookup.Result<ImportantFilesImplementation> lookupResult;
    @NullAllowed
    private List<ImportantFilesImplementation> allInstances;

    public ImportantFilesImpl(PhpProject phpProject) {
        assert (phpProject != null);
        this.phpProject = phpProject;
    }

    public Collection<ImportantFilesImplementation.FileInfo> getFiles() {
        List<ImportantFilesImplementation> allFiles = this.getAllInstances();
        if (allFiles.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ImportantFilesImplementation.FileInfo> files = new ArrayList<ImportantFilesImplementation.FileInfo>();
        for (ImportantFilesImplementation instance : allFiles) {
            files.addAll(this.map(instance.getFiles()));
        }
        return files;
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public void resultChanged(LookupEvent ev) {
        this.removeImportantFilesListener();
        this.resetAllInstances();
        this.getAllInstances();
        this.fireChange();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.fireChange();
    }

    private void fireChange() {
        this.changeSupport.fireChange();
    }

    private synchronized Lookup.Result<ImportantFilesImplementation> getLookupResult() {
        if (this.lookupResult == null) {
            this.lookupResult = this.phpProject.getLookup().lookupResult(ImportantFilesImplementation.class);
            this.lookupResult.addLookupListener((LookupListener)this);
        }
        return this.lookupResult;
    }

    private synchronized List<ImportantFilesImplementation> getAllInstances() {
        if (this.allInstances == null) {
            this.allInstances = new ArrayList<ImportantFilesImplementation>(this.getLookupResult().allInstances());
            this.addImportantFilesListener();
        }
        return this.allInstances;
    }

    private synchronized void resetAllInstances() {
        this.allInstances = null;
    }

    private synchronized void addImportantFilesListener() {
        if (this.allInstances == null) {
            return;
        }
        for (ImportantFilesImplementation files : this.allInstances) {
            files.addChangeListener((ChangeListener)this);
        }
    }

    private synchronized void removeImportantFilesListener() {
        if (this.allInstances == null) {
            return;
        }
        for (ImportantFilesImplementation files : this.allInstances) {
            files.removeChangeListener((ChangeListener)this);
        }
    }

    private Collection<? extends ImportantFilesImplementation.FileInfo> map(Collection<ImportantFilesImplementation.FileInfo> originals) {
        ArrayList<ImportantFilesImplementation.FileInfo> converted = new ArrayList<ImportantFilesImplementation.FileInfo>(originals.size());
        for (ImportantFilesImplementation.FileInfo original : originals) {
            converted.add(new ImportantFilesImplementation.FileInfo(original.getFile(), original.getDisplayName(), original.getDescription()));
        }
        return converted;
    }
}

