/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser;

import com.oracle.js.parser.TokenKind;
import com.oracle.js.parser.TokenType;

public final class TokenLookup {
    private static final TokenType[] table = new TokenType[95];
    private static final int tableBase = 32;
    private static final int tableLimit = 126;
    private static final int tableLength = 95;

    private TokenLookup() {
    }

    public static TokenType lookupKeyword(String string, int n, int n2) {
        char c = string.charAt(n);
        if ('a' <= c && c <= 'z') {
            int n3 = c - 32;
            for (TokenType tokenType = table[n3]; tokenType != null; tokenType = tokenType.getNext()) {
                int n4 = tokenType.getLength();
                if (n4 == n2) {
                    int n5;
                    String string2 = tokenType.getName();
                    for (n5 = 0; n5 < n2 && string.charAt(n + n5) == string2.charAt(n5); ++n5) {
                    }
                    if (n5 != n2) continue;
                    return tokenType;
                }
                if (n4 < n2) break;
            }
        }
        return TokenType.IDENT;
    }

    public static TokenType lookupOperator(char c, char c2, char c3, char c4) {
        if (' ' < c && c <= '~' && ('a' > c || c > 'z')) {
            int n = c - 32;
            block6: for (TokenType tokenType = table[n]; tokenType != null; tokenType = tokenType.getNext()) {
                String string = tokenType.getName();
                switch (string.length()) {
                    case 1: {
                        return tokenType;
                    }
                    case 2: {
                        if (string.charAt(1) != c2) continue block6;
                        return tokenType;
                    }
                    case 3: {
                        if (string.charAt(1) != c2 || string.charAt(2) != c3) continue block6;
                        return tokenType;
                    }
                    case 4: {
                        if (string.charAt(1) != c2 || string.charAt(2) != c3 || string.charAt(3) != c4) continue block6;
                        return tokenType;
                    }
                }
            }
        }
        return null;
    }

    static {
        for (TokenType tokenType : TokenType.getValues()) {
            TokenType tokenType2;
            String string = tokenType.getName();
            if (string == null || tokenType.getKind() == TokenKind.JSX || tokenType.getKind() == TokenKind.SPECIAL) continue;
            char c = string.charAt(0);
            int n = c - 32;
            assert (n < 95) : "Token name does not fit lookup table";
            int n2 = tokenType.getLength();
            TokenType tokenType3 = null;
            for (tokenType2 = table[n]; tokenType2 != null && tokenType2.getLength() > n2; tokenType2 = tokenType2.getNext()) {
                tokenType3 = tokenType2;
            }
            tokenType.setNext(tokenType2);
            if (tokenType3 == null) {
                TokenLookup.table[n] = tokenType;
                continue;
            }
            tokenType3.setNext(tokenType);
        }
    }
}

