/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Inet4Address;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.netbeans.api.sendopts.CommandException;
import org.netbeans.modules.java.lsp.server.Bundle;
import org.netbeans.modules.java.lsp.server.LspSession;
import org.openide.util.Exceptions;
import org.openide.util.Pair;

final class ConnectionSpec
implements Closeable {
    private final Boolean listen;
    private final int port;
    private final List<Closeable> close = new ArrayList<Closeable>();

    private ConnectionSpec(Boolean listen, int port) {
        this.listen = listen;
        this.port = port;
    }

    public static ConnectionSpec parse(String spec) throws CommandException {
        if (spec == null || spec.isEmpty() || spec.equals("stdio")) {
            return new ConnectionSpec(null, -1);
        }
        String listenPrefix = "listen:";
        if (spec.startsWith("listen:")) {
            int port = ConnectionSpec.parsePort(spec.substring("listen:".length()), spec);
            return new ConnectionSpec(true, port);
        }
        String connectPrefix = "connect:";
        if (spec.startsWith("connect:")) {
            int port = ConnectionSpec.parsePort(spec.substring("connect:".length()), spec);
            return new ConnectionSpec(false, port);
        }
        throw new CommandException(555, Bundle.MSG_ConnectionSpecError(spec));
    }

    private static Integer parsePort(String port, String spec) throws CommandException {
        try {
            return Integer.parseInt(port);
        }
        catch (NumberFormatException ex) {
            throw new CommandException(556, Bundle.MSG_PortParseError(port, spec));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <ServerType extends LspSession.ScheduledServer> void prepare(final String prefix, InputStream in, OutputStream out, final LspSession session, final BiConsumer<LspSession, ServerType> serverSetter, final BiFunction<Pair<InputStream, OutputStream>, LspSession, ServerType> launcher) throws IOException {
        if (this.listen == null) {
            LspSession.ScheduledServer connectionObject = (LspSession.ScheduledServer)launcher.apply((Pair<InputStream, OutputStream>)Pair.of((Object)in, (Object)out), session);
            serverSetter.accept(session, connectionObject);
            try {
                connectionObject.getRunningFuture().get();
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (ExecutionException ex) {
                Throwable cause = ex.getCause();
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                serverSetter.accept(session, null);
            }
        } else if (this.listen.booleanValue()) {
            final ServerSocket server = new ServerSocket(this.port, 1, Inet4Address.getLoopbackAddress());
            this.close.add(server);
            int localPort = server.getLocalPort();
            Thread listeningThread = new Thread(prefix + " listening at port " + localPort){

                @Override
                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                Socket socket = server.accept();
                                ConnectionSpec.this.close.add(socket);
                                ConnectionSpec.this.connectToSocket(socket, prefix, session, serverSetter, launcher);
                            }
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                            continue;
                        }
                        break;
                    }
                }
            };
            listeningThread.start();
            out.write((prefix + " listening at port " + localPort).getBytes());
            out.flush();
        } else {
            Socket socket = new Socket(Inet4Address.getLoopbackAddress(), this.port);
            this.connectToSocket(socket, prefix, session, serverSetter, launcher);
        }
    }

    private <ServerType extends LspSession.ScheduledServer> void connectToSocket(final Socket socket, String prefix, final LspSession session, final BiConsumer<LspSession, ServerType> serverSetter, final BiFunction<Pair<InputStream, OutputStream>, LspSession, ServerType> launcher) {
        int connectTo = socket.getPort();
        Thread connectedThread = new Thread(prefix + " connected to " + connectTo){

            @Override
            public void run() {
                try {
                    LspSession.ScheduledServer connectionObject = (LspSession.ScheduledServer)launcher.apply(Pair.of((Object)socket.getInputStream(), (Object)socket.getOutputStream()), session);
                    serverSetter.accept(session, connectionObject);
                    connectionObject.getRunningFuture().get();
                }
                catch (IOException | InterruptedException | ExecutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                finally {
                    serverSetter.accept(session, null);
                }
            }
        };
        connectedThread.start();
    }

    @Override
    public void close() throws IOException {
        for (Closeable c : this.close) {
            c.close();
        }
    }
}

