/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.database.model.UpdateDatabaseDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateDatabaseRequest
extends BmcRequest<UpdateDatabaseDetails> {
    private String databaseId;
    private UpdateDatabaseDetails updateDatabaseDetails;
    private String ifMatch;

    @InternalSdk
    public UpdateDatabaseDetails getBody$() {
        return this.updateDatabaseDetails;
    }

    @ConstructorProperties(value={"databaseId", "updateDatabaseDetails", "ifMatch"})
    UpdateDatabaseRequest(String databaseId, UpdateDatabaseDetails updateDatabaseDetails, String ifMatch) {
        this.databaseId = databaseId;
        this.updateDatabaseDetails = updateDatabaseDetails;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().databaseId(this.databaseId).updateDatabaseDetails(this.updateDatabaseDetails).ifMatch(this.ifMatch);
    }

    public String toString() {
        return "UpdateDatabaseRequest(super=" + super.toString() + ", databaseId=" + this.getDatabaseId() + ", updateDatabaseDetails=" + this.getUpdateDatabaseDetails() + ", ifMatch=" + this.getIfMatch() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateDatabaseRequest)) {
            return false;
        }
        UpdateDatabaseRequest other = (UpdateDatabaseRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$databaseId = this.getDatabaseId();
        String other$databaseId = other.getDatabaseId();
        if (this$databaseId == null ? other$databaseId != null : !this$databaseId.equals(other$databaseId)) {
            return false;
        }
        UpdateDatabaseDetails this$updateDatabaseDetails = this.getUpdateDatabaseDetails();
        UpdateDatabaseDetails other$updateDatabaseDetails = other.getUpdateDatabaseDetails();
        if (this$updateDatabaseDetails == null ? other$updateDatabaseDetails != null : !((Object)this$updateDatabaseDetails).equals(other$updateDatabaseDetails)) {
            return false;
        }
        String this$ifMatch = this.getIfMatch();
        String other$ifMatch = other.getIfMatch();
        return !(this$ifMatch == null ? other$ifMatch != null : !this$ifMatch.equals(other$ifMatch));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UpdateDatabaseRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $databaseId = this.getDatabaseId();
        result = result * 59 + ($databaseId == null ? 43 : $databaseId.hashCode());
        UpdateDatabaseDetails $updateDatabaseDetails = this.getUpdateDatabaseDetails();
        result = result * 59 + ($updateDatabaseDetails == null ? 43 : ((Object)$updateDatabaseDetails).hashCode());
        String $ifMatch = this.getIfMatch();
        result = result * 59 + ($ifMatch == null ? 43 : $ifMatch.hashCode());
        return result;
    }

    public String getDatabaseId() {
        return this.databaseId;
    }

    public UpdateDatabaseDetails getUpdateDatabaseDetails() {
        return this.updateDatabaseDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateDatabaseRequest, UpdateDatabaseDetails> {
        private String databaseId;
        private UpdateDatabaseDetails updateDatabaseDetails;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateDatabaseRequest o) {
            this.databaseId(o.getDatabaseId());
            this.updateDatabaseDetails(o.getUpdateDatabaseDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateDatabaseRequest build() {
            UpdateDatabaseRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateDatabaseDetails body) {
            this.updateDatabaseDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder updateDatabaseDetails(UpdateDatabaseDetails updateDatabaseDetails) {
            this.updateDatabaseDetails = updateDatabaseDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public UpdateDatabaseRequest buildWithoutInvocationCallback() {
            return new UpdateDatabaseRequest(this.databaseId, this.updateDatabaseDetails, this.ifMatch);
        }

        public String toString() {
            return "UpdateDatabaseRequest.Builder(databaseId=" + this.databaseId + ", updateDatabaseDetails=" + this.updateDatabaseDetails + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

