/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.api.PhpVersion;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayElement;
import org.netbeans.modules.php.editor.parser.astnodes.BodyDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.CatchClause;
import org.netbeans.modules.php.editor.parser.astnodes.ConstantDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.ListVariable;
import org.netbeans.modules.php.editor.parser.astnodes.NullableType;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.netbeans.modules.php.editor.verification.UnhandledErrorRule;
import org.netbeans.modules.php.editor.verification.VerificationError;
import org.openide.filesystems.FileObject;

public class PHP71UnhandledError
extends UnhandledErrorRule {
    public String getDisplayName() {
        return Bundle.PHP71UnhandledError_displayName();
    }

    @Override
    public void invoke(PHPRuleContext context, List<Error> errors) {
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        FileObject fileObject = phpParseResult.getSnapshot().getSource().getFileObject();
        if (fileObject != null && PHP71UnhandledError.appliesTo(fileObject)) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            CheckVisitor checkVisitor = new CheckVisitor(fileObject);
            phpParseResult.getProgram().accept(checkVisitor);
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            errors.addAll(checkVisitor.getErrors());
        }
    }

    private static boolean appliesTo(FileObject fileObject) {
        return CodeUtils.isPhpVersionLessThan(fileObject, PhpVersion.PHP_71);
    }

    private static final class PHP71VersionError
    extends VerificationError {
        private static final String KEY = "Php.Version.71";

        private PHP71VersionError(FileObject fileObject, int startOffset, int endOffset) {
            super(fileObject, startOffset, endOffset);
        }

        public String getDisplayName() {
            return Bundle.PHP71VersionError_displayName();
        }

        public String getDescription() {
            return Bundle.PHP71VersionError_description();
        }

        public String getKey() {
            return KEY;
        }
    }

    private static final class CheckVisitor
    extends DefaultVisitor {
        private final List<VerificationError> errors = new ArrayList<VerificationError>();
        private final FileObject fileObject;

        public CheckVisitor(FileObject fileObject) {
            this.fileObject = fileObject;
        }

        public Collection<VerificationError> getErrors() {
            return Collections.unmodifiableCollection(this.errors);
        }

        @Override
        public void visit(NullableType nullable) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.checkNullableType(nullable);
            super.visit(nullable);
        }

        @Override
        public void visit(CatchClause catchClause) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.checkMultiCatch(catchClause);
            super.visit(catchClause);
        }

        @Override
        public void visit(ConstantDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (!node.isGlobal()) {
                this.checkConstantVisibility(node);
            }
            super.visit(node);
        }

        @Override
        public void visit(ListVariable node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.checkNewSyntax(node);
            this.checkKeyedList(node.getElements());
            super.visit(node);
        }

        private void checkNullableType(NullableType nullableType) {
            if (nullableType != null) {
                this.createError(nullableType);
            }
        }

        private void checkMultiCatch(CatchClause catchClause) {
            List<Expression> classNames = catchClause.getClassNames();
            if (classNames.size() > 1) {
                this.createError(catchClause);
            }
        }

        private void checkConstantVisibility(ConstantDeclaration node) {
            if (!BodyDeclaration.Modifier.isImplicitPublic(node.getModifier())) {
                this.createError(node);
            }
        }

        private void checkKeyedList(List<ArrayElement> elements) {
            for (ArrayElement element : elements) {
                if (element.getKey() == null) continue;
                this.createError(element);
                break;
            }
        }

        private void checkNewSyntax(ListVariable node) {
            if (node.getSyntaxType() == ListVariable.SyntaxType.NEW) {
                this.createError(node);
            }
        }

        private void createError(int startOffset, int endOffset) {
            this.errors.add(new PHP71VersionError(this.fileObject, startOffset, endOffset));
        }

        private void createError(ASTNode node) {
            this.createError(node.getStartOffset(), node.getEndOffset());
        }
    }
}

