/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.actions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.netbeans.modules.php.editor.actions.Bundle;
import org.netbeans.modules.php.editor.actions.ImportData;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class FixDuplicateImportStmts
extends JPanel {
    private JComboBox[] combos;
    private JCheckBox checkUnusedImports;
    private ImportData.ItemVariant[] defaultVariants;
    private ImportData.ItemVariant[] dontUseVariants;
    private JPanel bottomPanel;
    private JPanel contentPanel;
    private JScrollPane jScrollPane1;
    private JLabel lblHeader;
    private JLabel lblTitle;

    public FixDuplicateImportStmts() {
        this.initComponents();
    }

    public void initPanel(ImportData importData, boolean removeUnusedImports) {
        this.initComponentsMore(importData, removeUnusedImports);
        this.initButtons(importData);
        this.setAccessible();
    }

    private void initComponentsMore(ImportData importData, boolean removeUnusedImports) {
        this.contentPanel.setLayout(new GridBagLayout());
        this.contentPanel.setBackground(UIManager.getColor("Table.background"));
        this.jScrollPane1.setBorder(UIManager.getBorder("ScrollPane.border"));
        this.jScrollPane1.getVerticalScrollBar().setUnitIncrement(new JLabel((String)"X").getPreferredSize().height);
        this.jScrollPane1.getVerticalScrollBar().setBlockIncrement(new JLabel((String)"X").getPreferredSize().height * 10);
        int numberOfItems = importData.getItems().size();
        if (numberOfItems > 0) {
            int row = 0;
            this.combos = new JComboBox[numberOfItems];
            Font monoSpaced = new Font("Monospaced", 0, new JLabel().getFont().getSize());
            FocusListener focusListener = new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    Component c = e.getComponent();
                    Rectangle r = c.getBounds();
                    FixDuplicateImportStmts.this.contentPanel.scrollRectToVisible(r);
                }

                @Override
                public void focusLost(FocusEvent arg0) {
                }
            };
            for (int i = 0; i < numberOfItems; ++i) {
                ImportData.DataItem dataItem = importData.getItems().get(i);
                this.combos[i] = this.createComboBox(dataItem, monoSpaced, focusListener);
                JLabel lblSimpleName = new JLabel(dataItem.getTypeName());
                lblSimpleName.setOpaque(false);
                lblSimpleName.setFont(monoSpaced);
                lblSimpleName.setLabelFor(this.combos[i]);
                this.contentPanel.add((Component)lblSimpleName, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 2, 5), 0, 0));
                this.contentPanel.add((Component)this.combos[i], new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 5, 2, 5), 0, 0));
            }
            this.contentPanel.add((Component)new JLabel(), new GridBagConstraints(2, row, 2, 1, 0.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            Dimension d = this.contentPanel.getPreferredSize();
            d.height = this.getRowHeight() * Math.min(this.combos.length, 6);
            this.jScrollPane1.getViewport().setPreferredSize(d);
        } else {
            this.contentPanel.add((Component)new JLabel(FixDuplicateImportStmts.getBundleString("FixDupImportStmts_NothingToFix")), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(20, 20, 20, 20), 0, 0));
        }
        this.lblTitle.setText(FixDuplicateImportStmts.getBundleString("FixDupImportStmts_IntroLbl"));
        this.lblHeader.setText(FixDuplicateImportStmts.getBundleString("FixDupImportStmts_Header"));
        this.checkUnusedImports = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.checkUnusedImports, (String)FixDuplicateImportStmts.getBundleString("FixDupImportStmts_UnusedImports"));
        this.bottomPanel.add((Component)this.checkUnusedImports, "West");
        this.checkUnusedImports.setEnabled(true);
        this.checkUnusedImports.setSelected(removeUnusedImports);
    }

    private JComboBox createComboBox(ImportData.DataItem item, Font font, FocusListener listener) {
        List<ImportData.ItemVariant> variants = item.getVariants();
        JComboBox<Object> combo = new JComboBox<Object>(variants.toArray());
        combo.setSelectedItem(item.getDefaultVariant());
        combo.getAccessibleContext().setAccessibleDescription(FixDuplicateImportStmts.getBundleString("FixDupImportStmts_Combo_ACSD"));
        combo.getAccessibleContext().setAccessibleName(FixDuplicateImportStmts.getBundleString("FixDupImportStmts_Combo_Name_ACSD"));
        combo.setOpaque(false);
        combo.setFont(font);
        combo.addFocusListener(listener);
        combo.setEnabled(variants.size() > 1);
        combo.setRenderer(new DelegatingRenderer(combo.getRenderer(), variants, item.getVariantIcons()));
        InputMap inputMap = combo.getInputMap(0);
        inputMap.put(KeyStroke.getKeyStroke(32, 0), "showPopup");
        combo.getActionMap().put("showPopup", new TogglePopupAction());
        return combo;
    }

    private int getRowHeight() {
        return this.combos.length == 0 ? 0 : this.combos[0].getPreferredSize().height + 6;
    }

    private static String getBundleString(String s) {
        return NbBundle.getMessage(FixDuplicateImportStmts.class, (String)s);
    }

    private void initButtons(ImportData importData) {
        int numberOfItems = importData.getItems().size();
        this.defaultVariants = new ImportData.ItemVariant[numberOfItems];
        this.dontUseVariants = new ImportData.ItemVariant[numberOfItems];
        for (int i = 0; i < numberOfItems; ++i) {
            ImportData.DataItem dataItem = importData.getItems().get(i);
            this.defaultVariants[i] = dataItem.getDefaultVariant();
            this.dontUseVariants[i] = dataItem.getDefaultVariant();
            for (ImportData.ItemVariant variant : dataItem.getVariants()) {
                if (variant.canBeUsed()) continue;
                this.dontUseVariants[i] = variant;
            }
        }
        this.bottomPanel.add(Box.createHorizontalStrut(150));
        JPanel buttonsPanel = new JPanel(new BorderLayout(5, 3));
        this.bottomPanel.add((Component)buttonsPanel, "After");
        JButton changeNothingButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)changeNothingButton, (String)Bundle.ClearSuggestionsButton());
        changeNothingButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FixDuplicateImportStmts.this.deselectAllButtonActionPerformed(evt);
            }
        });
        buttonsPanel.add((Component)changeNothingButton, "Before");
        JButton restoreDefaultsButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)restoreDefaultsButton, (String)Bundle.RestoreDefaultsButton());
        restoreDefaultsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FixDuplicateImportStmts.this.restoreDefaultsButtonActionPerformed(evt);
            }
        });
        buttonsPanel.add((Component)restoreDefaultsButton, "After");
    }

    private void deselectAllButtonActionPerformed(ActionEvent evt) {
        for (int i = 0; i < this.combos.length; ++i) {
            this.combos[i].setSelectedItem(this.dontUseVariants[i]);
        }
    }

    private void restoreDefaultsButtonActionPerformed(ActionEvent evt) {
        for (int i = 0; i < this.combos.length; ++i) {
            this.combos[i].setSelectedItem(this.defaultVariants[i]);
        }
    }

    private void setAccessible() {
        this.getAccessibleContext().setAccessibleDescription(FixDuplicateImportStmts.getBundleString("FixDupImportStmts_IntroLbl"));
        this.checkUnusedImports.getAccessibleContext().setAccessibleDescription(FixDuplicateImportStmts.getBundleString("FixDupImportStmts_checkUnusedImports_a11y"));
    }

    public List<ImportData.ItemVariant> getSelections() {
        ArrayList<ImportData.ItemVariant> result = new ArrayList<ImportData.ItemVariant>();
        int numberOfCombos = this.combos == null ? 0 : this.combos.length;
        for (int i = 0; i < numberOfCombos; ++i) {
            Object selectedItem = this.combos[i].getSelectedItem();
            assert (selectedItem instanceof ImportData.ItemVariant);
            result.add((ImportData.ItemVariant)selectedItem);
        }
        return result;
    }

    public boolean getRemoveUnusedImports() {
        return this.checkUnusedImports.isSelected();
    }

    private void initComponents() {
        this.lblTitle = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.contentPanel = new JPanel();
        this.bottomPanel = new JPanel();
        this.lblHeader = new JLabel();
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.setPreferredSize(null);
        this.setLayout(new GridBagLayout());
        this.lblTitle.setText("~Select the fully qualified name to use in the import statement.");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.lblTitle, gridBagConstraints);
        this.jScrollPane1.setBorder(null);
        this.contentPanel.setLayout(new GridBagLayout());
        this.jScrollPane1.setViewportView(this.contentPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.bottomPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.bottomPanel, gridBagConstraints);
        this.lblHeader.setText("~Import Statements:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.add((Component)this.lblHeader, gridBagConstraints);
    }

    private static class TogglePopupAction
    extends AbstractAction {
        private TogglePopupAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof JComboBox) {
                JComboBox combo;
                combo.setPopupVisible(!(combo = (JComboBox)e.getSource()).isPopupVisible());
            }
        }
    }

    private static class DelegatingRenderer
    implements ListCellRenderer {
        private ListCellRenderer orig;
        private Icon[] icons;
        private List<ImportData.ItemVariant> values;

        public DelegatingRenderer(ListCellRenderer orig, List<ImportData.ItemVariant> values, Icon[] icons) {
            this.orig = orig;
            this.icons = icons;
            this.values = values;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component res = this.orig.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (res instanceof JLabel && null != this.icons) {
                for (int i = 0; i < this.values.size(); ++i) {
                    if (!this.values.get(i).equals(value)) continue;
                    ((JLabel)res).setIcon(this.icons[i]);
                    break;
                }
            }
            return res;
        }
    }
}

