/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.gradle.api.artifacts.ClientModule;
import org.gradle.api.artifacts.Dependency;
import org.gradle.internal.component.local.model.DslOriginDependencyMetadata;
import org.gradle.internal.component.model.ComponentOverrideMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.IvyArtifactName;

public class DefaultComponentOverrideMetadata
implements ComponentOverrideMetadata {
    private final boolean changing;
    private final List<IvyArtifactName> artifacts;
    private final ClientModule clientModule;

    public static ComponentOverrideMetadata forDependency(DependencyMetadata dependencyMetadata) {
        return new DefaultComponentOverrideMetadata(dependencyMetadata.isChanging(), dependencyMetadata.getArtifacts(), DefaultComponentOverrideMetadata.extractClientModule(dependencyMetadata));
    }

    public DefaultComponentOverrideMetadata() {
        this(false, Collections.emptyList(), null);
    }

    private DefaultComponentOverrideMetadata(boolean changing, List<IvyArtifactName> artifacts, ClientModule clientModule) {
        this.changing = changing;
        this.artifacts = ImmutableList.copyOf(artifacts);
        this.clientModule = clientModule;
    }

    private static ClientModule extractClientModule(DependencyMetadata dependencyMetadata) {
        Dependency source;
        if (dependencyMetadata instanceof DslOriginDependencyMetadata && (source = ((DslOriginDependencyMetadata)dependencyMetadata).getSource()) instanceof ClientModule) {
            return (ClientModule)source;
        }
        return null;
    }

    @Override
    public ComponentOverrideMetadata withChanging() {
        return new DefaultComponentOverrideMetadata(true, this.artifacts, this.clientModule);
    }

    @Override
    public List<IvyArtifactName> getArtifacts() {
        return this.artifacts;
    }

    @Override
    public boolean isChanging() {
        return this.changing;
    }

    @Override
    public ClientModule getClientModule() {
        return this.clientModule;
    }
}

