/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;

public class JvmClassName {
    private final String internalName;
    private FqName fqName;

    @NotNull
    public static JvmClassName byInternalName(@NotNull String internalName) {
        if (internalName == null) {
            JvmClassName.$$$reportNull$$$0(0);
        }
        JvmClassName jvmClassName = new JvmClassName(internalName);
        if (jvmClassName == null) {
            JvmClassName.$$$reportNull$$$0(1);
        }
        return jvmClassName;
    }

    @NotNull
    public static JvmClassName byClassId(@NotNull ClassId classId) {
        if (classId == null) {
            JvmClassName.$$$reportNull$$$0(2);
        }
        FqName packageFqName = classId.getPackageFqName();
        String relativeClassName = classId.getRelativeClassName().asString().replace('.', '$');
        JvmClassName jvmClassName = packageFqName.isRoot() ? new JvmClassName(relativeClassName) : new JvmClassName(packageFqName.asString().replace('.', '/') + "/" + relativeClassName);
        if (jvmClassName == null) {
            JvmClassName.$$$reportNull$$$0(3);
        }
        return jvmClassName;
    }

    @NotNull
    public static JvmClassName byFqNameWithoutInnerClasses(@NotNull FqName fqName2) {
        if (fqName2 == null) {
            JvmClassName.$$$reportNull$$$0(4);
        }
        JvmClassName r = new JvmClassName(fqName2.asString().replace('.', '/'));
        r.fqName = fqName2;
        JvmClassName jvmClassName = r;
        if (jvmClassName == null) {
            JvmClassName.$$$reportNull$$$0(5);
        }
        return jvmClassName;
    }

    @NotNull
    public static JvmClassName byFqNameWithoutInnerClasses(@NotNull String fqName2) {
        if (fqName2 == null) {
            JvmClassName.$$$reportNull$$$0(6);
        }
        JvmClassName jvmClassName = JvmClassName.byFqNameWithoutInnerClasses(new FqName(fqName2));
        if (jvmClassName == null) {
            JvmClassName.$$$reportNull$$$0(7);
        }
        return jvmClassName;
    }

    private JvmClassName(@NotNull String internalName) {
        if (internalName == null) {
            JvmClassName.$$$reportNull$$$0(8);
        }
        this.internalName = internalName;
    }

    @NotNull
    public FqName getFqNameForClassNameWithoutDollars() {
        if (this.fqName == null) {
            this.fqName = new FqName(this.internalName.replace('$', '.').replace('/', '.'));
        }
        FqName fqName2 = this.fqName;
        if (fqName2 == null) {
            JvmClassName.$$$reportNull$$$0(9);
        }
        return fqName2;
    }

    @NotNull
    public FqName getFqNameForTopLevelClassMaybeWithDollars() {
        FqName fqName2 = new FqName(this.internalName.replace('/', '.'));
        if (fqName2 == null) {
            JvmClassName.$$$reportNull$$$0(10);
        }
        return fqName2;
    }

    @NotNull
    public FqName getPackageFqName() {
        int lastSlash = this.internalName.lastIndexOf("/");
        if (lastSlash == -1) {
            FqName fqName2 = FqName.ROOT;
            if (fqName2 == null) {
                JvmClassName.$$$reportNull$$$0(11);
            }
            return fqName2;
        }
        FqName fqName3 = new FqName(this.internalName.substring(0, lastSlash).replace('/', '.'));
        if (fqName3 == null) {
            JvmClassName.$$$reportNull$$$0(12);
        }
        return fqName3;
    }

    @NotNull
    public String getInternalName() {
        String string = this.internalName;
        if (string == null) {
            JvmClassName.$$$reportNull$$$0(13);
        }
        return string;
    }

    public String toString() {
        return this.internalName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.internalName.equals(((JvmClassName)o).internalName);
    }

    public int hashCode() {
        return this.internalName.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "internalName";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/resolve/jvm/JvmClassName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classId";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/resolve/jvm/JvmClassName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "byInternalName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "byClassId";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "byFqNameWithoutInnerClasses";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFqNameForClassNameWithoutDollars";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFqNameForTopLevelClassMaybeWithDollars";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageFqName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getInternalName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "byInternalName";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "byClassId";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "byFqNameWithoutInnerClasses";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

