/*
 * Decompiled with CFR 0.152.
 */
package ghidra.test.processors.support;

import ghidra.program.model.address.Address;
import ghidra.program.model.data.Structure;
import ghidra.program.model.listing.Program;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.test.processors.support.PCodeTestAbstractControlBlock;
import ghidra.test.processors.support.PCodeTestControlBlock;

public class PCodeTestGroupControlBlock
extends PCodeTestAbstractControlBlock {
    static String TEST_GROUP_NAME_SUFFIX = "_main";
    static String TEST_GROUP_FUNCTION_SUFFIX = "_Main";
    static final String GROUP_CONTROL_BLOCK_MAGIC = "aBcDefGh";
    public final PCodeTestControlBlock mainTestControlBlock;
    private String testGroupName;
    private Address testGroupMainAddr;

    PCodeTestGroupControlBlock(Program program, Address groupInfoStructAddr, Structure groupInfoStruct, boolean applyStruct, PCodeTestControlBlock mainTestControlBlock) throws PCodeTestAbstractControlBlock.InvalidControlBlockException, CodeUnitInsertionException {
        super(program, groupInfoStructAddr, groupInfoStruct);
        this.mainTestControlBlock = mainTestControlBlock;
        this.readControlBlock(applyStruct);
        if (this.getNumberFunctions() < 1) {
            throw new PCodeTestAbstractControlBlock.InvalidControlBlockException("GroupInfo @ " + this.infoStructAddr.toString(true) + " does not define any functions: " + this.infoStructAddr);
        }
        this.testGroupName = this.getFunctionInfo((int)0).functionName;
        if (!this.testGroupName.endsWith(TEST_GROUP_NAME_SUFFIX)) {
            throw new PCodeTestAbstractControlBlock.InvalidControlBlockException("GroupInfo @ " + this.infoStructAddr.toString(true) + " does not define <group>_main function as first function");
        }
        this.testGroupName = this.testGroupName.substring(0, this.testGroupName.length() - TEST_GROUP_NAME_SUFFIX.length());
        this.testGroupMainAddr = this.getFunctionInfo((int)0).functionAddr;
    }

    public String getTestGroupName() {
        return this.testGroupName;
    }

    public Address getTestGroupMainAddress() {
        return this.testGroupMainAddr;
    }
}

