/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import docking.ActionContext;
import docking.action.DockingActionIf;
import ghidra.framework.main.DataTreeDialog;
import ghidra.framework.main.datatree.VersionHistoryPanel;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFileFilter;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.preferences.Preferences;
import ghidra.util.Msg;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.border.Border;

public class OpenVersionedFileDialog
extends DataTreeDialog {
    private static final String SHOW_HISTORY_PREFERENCES_KEY = "OPEN_PROGRAM_DIALOG.SHOW_HISTORY";
    private static final String HEIGHT_PREFERENCES_KEY = "OPEN_PROGRAM_DIALOG.HEIGHT";
    private static final String WIDTH_NO_HISTORY_PREFERENCES_KEY = "OPEN_PROGRAM_DIALOG.WIDTH_NO_HISTORY";
    private static final String WIDTH_WITH_HISTORY_PREFERENCES_KEY = "OPEN_PROGRAM_DIALOG.WIDTH_WITH_HISTORY";
    private static final int DEFAULT_WIDTH_NO_HISTORY = 350;
    private static final int DEFAULT_WIDTH_WITH_HISTORY = 800;
    private static final int DIVIDER_SIZE = 2;
    private JSplitPane splitPane;
    private JButton historyButton;
    private JPanel mainPanel;
    private boolean historyIsShowing;
    private PluginTool tool;
    private VersionHistoryPanel historyPanel;
    private List<DockingActionIf> popupActions = Collections.emptyList();

    public OpenVersionedFileDialog(PluginTool tool, String title, DomainFileFilter filter) {
        super(tool.getToolFrame(), title, 0, filter);
        this.tool = tool;
        this.init();
    }

    public DomainObject getVersionedDomainObject(Object consumer, boolean readOnly) {
        if (this.historyPanel != null) {
            return this.historyPanel.getSelectedVersion(consumer, readOnly);
        }
        return null;
    }

    public int getVersion() {
        if (this.historyPanel != null) {
            return this.historyPanel.getSelectedVersionNumber();
        }
        return -1;
    }

    @Override
    protected JPanel buildMainPanel() {
        this.mainPanel = super.buildMainPanel();
        this.mainPanel.setMinimumSize(new Dimension(200, 500));
        this.splitPane = new JSplitPane(1);
        this.splitPane.setLeftComponent(this.mainPanel);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerSize(0);
        this.splitPane.setDividerLocation(1.0);
        this.splitPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        JPanel outerPanel = new JPanel(new BorderLayout());
        outerPanel.add(this.splitPane);
        String showHistory = Preferences.getProperty((String)SHOW_HISTORY_PREFERENCES_KEY, (String)Boolean.FALSE.toString(), (boolean)true);
        if (Boolean.parseBoolean(showHistory)) {
            this.showHistoryPanel(true);
        }
        return outerPanel;
    }

    private void advancedButtonCallback() {
        this.showHistoryPanel(!this.historyIsShowing);
    }

    private void showHistoryPanel(boolean showHistory) {
        this.historyIsShowing = showHistory;
        if (showHistory) {
            this.createHistoryPanel();
            this.historyButton.setText("No History");
            DomainFile df = this.treePanel.getSelectedDomainFile();
            this.historyPanel.setDomainFile(df);
            this.splitPane.setDividerSize(2);
            this.splitPane.setDividerLocation(346);
        } else {
            this.historyButton.setText("History>>");
            this.splitPane.setDividerSize(0);
            this.splitPane.setRightComponent(null);
            this.historyPanel = null;
        }
        Dimension size = this.getPreferredSizeForHistoryState();
        this.rootPanel.setPreferredSize(size);
        this.repack();
    }

    private Dimension getPreferredSizeForHistoryState() {
        int height = Integer.parseInt(Preferences.getProperty((String)HEIGHT_PREFERENCES_KEY, (String)Integer.toString(500)));
        String key = this.historyIsShowing ? WIDTH_WITH_HISTORY_PREFERENCES_KEY : WIDTH_NO_HISTORY_PREFERENCES_KEY;
        int defaultWidth = this.historyIsShowing ? 800 : 350;
        int width = Integer.parseInt(Preferences.getProperty((String)key, (String)Integer.toString(defaultWidth)));
        return new Dimension(width, height);
    }

    private void savePreferences() {
        Dimension size = this.rootPanel.getSize();
        String propertyName = this.historyIsShowing ? WIDTH_WITH_HISTORY_PREFERENCES_KEY : WIDTH_NO_HISTORY_PREFERENCES_KEY;
        Preferences.setProperty((String)propertyName, (String)Integer.toString(size.width));
        Preferences.setProperty((String)HEIGHT_PREFERENCES_KEY, (String)Integer.toString(size.height));
        Preferences.setProperty((String)SHOW_HISTORY_PREFERENCES_KEY, (String)Boolean.toString(this.historyIsShowing));
        Preferences.store();
    }

    @Override
    public void close() {
        this.savePreferences();
        this.historyPanel = null;
        super.close();
    }

    @Override
    protected void dialogShown() {
        super.dialogShown();
        for (DockingActionIf action : this.popupActions) {
            this.addAction(action);
        }
    }

    protected void dialogClosed() {
        super.dialogClosed();
        for (DockingActionIf action : this.popupActions) {
            this.removeAction(action);
        }
    }

    private boolean createHistoryPanel() {
        try {
            this.historyPanel = new VersionHistoryPanel(this.tool, null);
            this.popupActions = this.historyPanel.createPopupActions();
        }
        catch (IOException ioe) {
            Msg.debug(this.getClass(), (Object)("Error creating history panel for versioned file: " + ioe.getMessage()), (Throwable)ioe);
            return false;
        }
        this.historyPanel.setBorder((Border)BorderFactory.createTitledBorder("Version History"));
        this.splitPane.setRightComponent((Component)this.historyPanel);
        this.historyPanel.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.okButton.setToolTipText("Open the selected file");
            int versionNumber = this.historyPanel.getSelectedVersionNumber();
            if (versionNumber >= 0) {
                DomainFile df = OpenVersionedFileDialog.super.getDomainFile();
                this.okButton.setToolTipText("Open version " + versionNumber + " for " + df.getName());
            }
        });
        return true;
    }

    private void init() {
        this.historyButton = new JButton("History>>");
        this.historyButton.addActionListener(e -> this.advancedButtonCallback());
        this.addButton(this.historyButton);
        this.okButton.setToolTipText("Open the selected file");
        this.rootPanel.setPreferredSize(this.getPreferredSizeForHistoryState());
    }

    @Override
    protected void addTreeListeners() {
        super.addTreeListeners();
        this.treePanel.addTreeSelectionListener(e -> {
            if (this.historyPanel != null) {
                DomainFile df = this.treePanel.getSelectedDomainFile();
                this.historyPanel.setDomainFile(df);
            }
        });
    }

    @Override
    public ActionContext getActionContext(MouseEvent event) {
        ActionContext context = super.getActionContext(event);
        if (context != null) {
            return context;
        }
        ActionContext actionContext = new ActionContext(null, (Object)this, event.getComponent());
        actionContext.setMouseEvent(event);
        return actionContext;
    }
}

