/*
 * Decompiled with CFR 0.152.
 */
package ghidra.formats.gfilesystem.crypto;

import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.crypto.CachedPasswordProvider;
import ghidra.formats.gfilesystem.crypto.CmdLinePasswordProvider;
import ghidra.formats.gfilesystem.crypto.CryptoProvider;
import ghidra.formats.gfilesystem.crypto.CryptoSession;
import ghidra.formats.gfilesystem.crypto.PasswordProvider;
import ghidra.formats.gfilesystem.crypto.PasswordValue;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class CryptoProviders {
    private static final CryptoProviders singletonInstance = new CryptoProviders();
    private CachedPasswordProvider cachedCryptoProvider;
    private List<CryptoProvider> cryptoProviders = new CopyOnWriteArrayList<CryptoProvider>();

    public static CryptoProviders getInstance() {
        return singletonInstance;
    }

    CryptoProviders() {
        this.initPasswordCryptoProviders();
    }

    private void initPasswordCryptoProviders() {
        this.cachedCryptoProvider = new CachedPasswordProvider();
        CmdLinePasswordProvider runtimePasswords = new CmdLinePasswordProvider();
        this.registerCryptoProvider(runtimePasswords);
        this.registerCryptoProvider(this.cachedCryptoProvider);
    }

    public void registerCryptoProvider(CryptoProvider provider) {
        this.cryptoProviders.add(provider);
    }

    public void unregisterCryptoProvider(CryptoProvider provider) {
        this.cryptoProviders.remove(provider);
    }

    public CachedPasswordProvider getCachedCryptoProvider() {
        return this.cachedCryptoProvider;
    }

    public <T extends CryptoProvider> T getCryptoProviderInstance(Class<T> providerClass) {
        return (T)((CryptoProvider)this.cryptoProviders.stream().filter(providerClass::isInstance).map(providerClass::cast).findFirst().orElse(null));
    }

    public CryptoSession newSession() {
        return new CryptoProviderSessionImpl(this.cryptoProviders);
    }

    private class CryptoProviderSessionImpl
    implements CryptoProvider.Session,
    CryptoSession {
        private List<CryptoProvider> providers;
        private Map<CryptoProvider, Object> sessionStateValues = new IdentityHashMap<CryptoProvider, Object>();
        private boolean closed;

        public CryptoProviderSessionImpl(List<CryptoProvider> providers) {
            this.providers = new ArrayList<CryptoProvider>(providers);
        }

        @Override
        public void addSuccessfulPassword(FSRL fsrl, PasswordValue password) {
            CryptoProviders.this.cachedCryptoProvider.addPassword(fsrl, password);
        }

        @Override
        public void close() {
            this.closed = true;
        }

        @Override
        public boolean isClosed() {
            return this.closed;
        }

        @Override
        public void setStateValue(CryptoProvider cryptoProvider, Object value) {
            this.sessionStateValues.put(cryptoProvider, value);
        }

        @Override
        public <T> T getStateValue(CryptoProvider cryptoProvider, Supplier<T> stateFactory) {
            Object val = this.sessionStateValues.get(cryptoProvider);
            if (val == null) {
                T newVal = stateFactory.get();
                this.sessionStateValues.put(cryptoProvider, newVal);
                return newVal;
            }
            return (T)val;
        }

        @Override
        public CryptoProviders getCryptoProviders() {
            return CryptoProviders.this;
        }

        @Override
        public Iterator<PasswordValue> getPasswordsFor(FSRL fsrl, String prompt) {
            return new PasswordIterator(this.providers, fsrl, prompt);
        }

        class PasswordIterator
        implements Iterator<PasswordValue> {
            private List<PasswordProvider> providers;
            private Iterator<PasswordValue> currentIt;
            private String prompt;
            private FSRL fsrl;

            PasswordIterator(List<CryptoProvider> providers, FSRL fsrl, String prompt) {
                this.providers = providers.stream().filter(PasswordProvider.class::isInstance).map(PasswordProvider.class::cast).collect(Collectors.toList());
                this.fsrl = fsrl;
                this.prompt = prompt;
            }

            @Override
            public boolean hasNext() {
                while (this.currentIt == null || !this.currentIt.hasNext()) {
                    if (this.providers.isEmpty()) {
                        return false;
                    }
                    PasswordProvider provider = this.providers.remove(0);
                    this.currentIt = provider.getPasswordsFor(this.fsrl, this.prompt, CryptoProviderSessionImpl.this);
                }
                return true;
            }

            @Override
            public PasswordValue next() {
                return this.currentIt.next();
            }
        }
    }
}

