/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class TableOfContents
implements StructConverter {
    private int symbol_index;
    private int module_index;

    static TableOfContents createTableOfContents(FactoryBundledWithBinaryReader reader) throws IOException {
        TableOfContents tableOfContents = (TableOfContents)reader.getFactory().create(TableOfContents.class, new Object[0]);
        tableOfContents.initTableOfContents(reader);
        return tableOfContents;
    }

    private void initTableOfContents(FactoryBundledWithBinaryReader reader) throws IOException {
        this.symbol_index = reader.readNextInt();
        this.module_index = reader.readNextInt();
    }

    public int getSymbolIndex() {
        return this.symbol_index;
    }

    public int getModuleIndex() {
        return this.module_index;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("dylib_table_of_contents", 0);
        struct.add(DWORD, "symbol_index", null);
        struct.add(DWORD, "module_index", null);
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }
}

