/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.commands.LoadCommand;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.flatapi.FlatProgramAPI;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.ProgramModule;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class EncryptedInformationCommand
extends LoadCommand {
    private int cryptoff;
    private int cryptsize;
    private int cryptid;
    private boolean is32bit;

    static EncryptedInformationCommand createEncryptedInformationCommand(FactoryBundledWithBinaryReader reader, boolean is32bit) throws IOException {
        EncryptedInformationCommand command = (EncryptedInformationCommand)reader.getFactory().create(EncryptedInformationCommand.class, new Object[0]);
        command.initEncryptedInformationCommand(reader, is32bit);
        return command;
    }

    private void initEncryptedInformationCommand(FactoryBundledWithBinaryReader reader, boolean is32bit) throws IOException {
        this.initLoadCommand(reader);
        this.is32bit = is32bit;
        this.cryptoff = reader.readNextInt();
        this.cryptsize = reader.readNextInt();
        this.cryptid = reader.readNextInt();
    }

    public int getCryptID() {
        return this.cryptid;
    }

    public int getCryptOffset() {
        return this.cryptoff;
    }

    public int getCryptSize() {
        return this.cryptsize;
    }

    @Override
    public String getCommandName() {
        return "encryption_info_command";
    }

    @Override
    public void markup(MachHeader header, FlatProgramAPI api, Address baseAddress, boolean isBinary, ProgramModule parentModule, TaskMonitor monitor, MessageLog log) {
        this.updateMonitor(monitor);
        try {
            if (isBinary) {
                this.createFragment(api, baseAddress, parentModule);
                Address address = baseAddress.getNewAddress(this.getStartIndex());
                api.createData(address, this.toDataType());
            }
        }
        catch (Exception e) {
            log.appendMsg("Unable to create " + this.getCommandName());
        }
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(this.getCommandName(), 0);
        struct.add(DWORD, "cmd", null);
        struct.add(DWORD, "cmdsize", null);
        struct.add(DWORD, "cryptoff", null);
        struct.add(DWORD, "cryptsize", null);
        struct.add(DWORD, "cryptid", null);
        if (!this.is32bit) {
            struct.add(DWORD, "pad", null);
        }
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }
}

