/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin;

import ghidra.app.util.bin.ByteProvider;
import ghidra.util.BigEndianDataConverter;
import ghidra.util.DataConverter;
import ghidra.util.LittleEndianDataConverter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class BinaryReader {
    public static final int SIZEOF_BYTE = 1;
    public static final int SIZEOF_SHORT = 2;
    public static final int SIZEOF_INT = 4;
    public static final int SIZEOF_LONG = 8;
    private final ByteProvider provider;
    private DataConverter converter;
    private long currentIndex;

    public BinaryReader(ByteProvider provider, boolean isLittleEndian) {
        this(provider, DataConverter.getInstance((!isLittleEndian ? 1 : 0) != 0), 0L);
    }

    public BinaryReader(ByteProvider provider, DataConverter converter, long initialIndex) {
        this.provider = provider;
        this.converter = converter;
        this.currentIndex = initialIndex;
    }

    public BinaryReader clone(long newIndex) {
        return new BinaryReader(this.provider, this.converter, newIndex);
    }

    public BinaryReader clone() {
        return this.clone(this.currentIndex);
    }

    public BinaryReader asBigEndian() {
        return new BinaryReader(this.provider, (DataConverter)BigEndianDataConverter.INSTANCE, this.currentIndex);
    }

    public BinaryReader asLittleEndian() {
        return new BinaryReader(this.provider, (DataConverter)LittleEndianDataConverter.INSTANCE, this.currentIndex);
    }

    public boolean isLittleEndian() {
        return this.converter instanceof LittleEndianDataConverter;
    }

    public boolean isBigEndian() {
        return this.converter instanceof BigEndianDataConverter;
    }

    public void setLittleEndian(boolean isLittleEndian) {
        this.converter = DataConverter.getInstance((!isLittleEndian ? 1 : 0) != 0);
    }

    public long length() throws IOException {
        return this.provider.length();
    }

    public boolean isValidIndex(int index) throws IOException {
        return this.provider.isValidIndex((long)index & 0xFFFFFFFFL);
    }

    public boolean isValidIndex(long index) throws IOException {
        return this.provider.isValidIndex(index);
    }

    public int align(int alignValue) {
        long align = this.currentIndex % (long)alignValue;
        if (align == 0L) {
            return 0;
        }
        this.currentIndex += (long)alignValue - align;
        return (int)((long)alignValue - align);
    }

    public void setPointerIndex(int index) {
        this.currentIndex = Integer.toUnsignedLong(index);
    }

    public void setPointerIndex(long index) {
        this.currentIndex = index;
    }

    public long getPointerIndex() {
        return this.currentIndex;
    }

    public byte peekNextByte() throws IOException {
        return this.readByte(this.currentIndex);
    }

    public short peekNextShort() throws IOException {
        return this.readShort(this.currentIndex);
    }

    public int peekNextInt() throws IOException {
        return this.readInt(this.currentIndex);
    }

    public long peekNextLong() throws IOException {
        return this.readLong(this.currentIndex);
    }

    public byte readNextByte() throws IOException {
        byte b = this.readByte(this.currentIndex);
        ++this.currentIndex;
        return b;
    }

    public int readNextUnsignedByte() throws IOException {
        return this.readNextByte() & 0xFF;
    }

    public short readNextShort() throws IOException {
        short s = this.readShort(this.currentIndex);
        this.currentIndex += 2L;
        return s;
    }

    public int readNextUnsignedShort() throws IOException {
        return this.readNextShort() & 0xFFFF;
    }

    public int readNextInt() throws IOException {
        int i = this.readInt(this.currentIndex);
        this.currentIndex += 4L;
        return i;
    }

    public long readNextUnsignedInt() throws IOException {
        return (long)this.readNextInt() & 0xFFFFFFFFL;
    }

    public long readNextLong() throws IOException {
        long l = this.readLong(this.currentIndex);
        this.currentIndex += 8L;
        return l;
    }

    public String readNextAsciiString() throws IOException {
        String s = this.readAsciiString(this.currentIndex);
        this.currentIndex += (long)(s.length() + 1);
        return s;
    }

    public String readNextNullTerminatedAsciiString() throws IOException {
        byte b;
        StringBuilder buffer = new StringBuilder();
        while (this.currentIndex < this.provider.length() && (b = this.provider.readByte(this.currentIndex++)) != 0) {
            buffer.append((char)b);
        }
        return buffer.toString();
    }

    public String readNextAsciiString(int length) throws IOException {
        String s = this.readAsciiString(this.currentIndex, length);
        this.currentIndex += (long)length;
        return s;
    }

    public String readNextUnicodeString() throws IOException {
        String s = this.readUnicodeString(this.currentIndex);
        this.currentIndex += (long)((s.length() + 1) * 2);
        return s;
    }

    public String readNextUnicodeString(int length) throws IOException {
        String s = this.readUnicodeString(this.currentIndex, length);
        this.currentIndex += (long)(length * 2);
        return s;
    }

    public byte[] readNextByteArray(int nElements) throws IOException {
        byte[] b = this.readByteArray(this.currentIndex, nElements);
        this.currentIndex += (long)(1 * nElements);
        return b;
    }

    public short[] readNextShortArray(int nElements) throws IOException {
        short[] s = this.readShortArray(this.currentIndex, nElements);
        this.currentIndex += (long)(2 * nElements);
        return s;
    }

    public int[] readNextIntArray(int nElements) throws IOException {
        int[] i = this.readIntArray(this.currentIndex, nElements);
        this.currentIndex += (long)(4 * nElements);
        return i;
    }

    public long[] readNextLongArray(int nElements) throws IOException {
        long[] l = this.readLongArray(this.currentIndex, nElements);
        this.currentIndex += (long)(8 * nElements);
        return l;
    }

    public String readAsciiString(long index) throws IOException {
        byte b;
        StringBuilder buffer = new StringBuilder();
        long len = this.provider.length();
        while (index != len && (b = this.provider.readByte(index++)) >= 32 && b <= 126) {
            buffer.append((char)b);
        }
        return buffer.toString().trim();
    }

    public String readAsciiString(long index, int length) throws IOException {
        byte[] readBytes = this.provider.readBytes(index, length);
        String str = new String(readBytes, StandardCharsets.US_ASCII);
        return str.trim();
    }

    public String readTerminatedString(long index, char termChar) throws IOException {
        char c;
        StringBuilder buffer = new StringBuilder();
        long len = this.provider.length();
        while (index < len && (c = (char)this.provider.readByte(index++)) != termChar) {
            buffer.append(c);
        }
        return buffer.toString();
    }

    public String readTerminatedString(long index, String termChars) throws IOException {
        char c;
        StringBuilder buffer = new StringBuilder();
        long len = this.provider.length();
        while (index < len && termChars.indexOf(c = (char)this.provider.readByte(index++)) == -1) {
            buffer.append(c);
        }
        return buffer.toString();
    }

    public String readFixedLenAsciiString(long index, int len) throws IOException {
        byte[] bytes = this.readByteArray(index, len);
        return new String(bytes, StandardCharsets.US_ASCII);
    }

    public String readUnicodeString(long index) throws IOException {
        int ch;
        StringBuilder buffer = new StringBuilder();
        while (index < this.length() && (ch = this.readUnsignedShort(index)) != 0) {
            buffer.append((char)ch);
            index += 2L;
        }
        return buffer.toString().trim();
    }

    public String readUnicodeString(long index, int length) throws IOException {
        StringBuilder buffer = new StringBuilder(length);
        long endOffset = index + (long)(length * 2);
        while (index < endOffset) {
            int ch = this.readUnsignedShort(index);
            buffer.append((char)ch);
            index += 2L;
        }
        return buffer.toString().trim();
    }

    public byte readByte(long index) throws IOException {
        return this.provider.readByte(index);
    }

    public int readUnsignedByte(long index) throws IOException {
        return this.readByte(index) & 0xFF;
    }

    public short readShort(long index) throws IOException {
        byte[] bytes = this.provider.readBytes(index, 2L);
        return this.converter.getShort(bytes);
    }

    public int readUnsignedShort(long index) throws IOException {
        return this.readShort(index) & 0xFFFF;
    }

    public int readInt(long index) throws IOException {
        byte[] bytes = this.provider.readBytes(index, 4L);
        return this.converter.getInt(bytes);
    }

    public long readUnsignedInt(long index) throws IOException {
        return (long)this.readInt(index) & 0xFFFFFFFFL;
    }

    public long readLong(long index) throws IOException {
        byte[] bytes = this.provider.readBytes(index, 8L);
        return this.converter.getLong(bytes);
    }

    public long readValue(long index, int len) throws IOException {
        byte[] bytes = this.provider.readBytes(index, len);
        return this.converter.getSignedValue(bytes, len);
    }

    public long readUnsignedValue(long index, int len) throws IOException {
        byte[] bytes = this.provider.readBytes(index, len);
        return this.converter.getValue(bytes, len);
    }

    public byte[] readByteArray(long index, int nElements) throws IOException {
        if (nElements < 0) {
            throw new IOException("Invalid number of elements specified: " + nElements);
        }
        return this.provider.readBytes(index, nElements);
    }

    public short[] readShortArray(long index, int nElements) throws IOException {
        if (nElements < 0) {
            throw new IOException("Invalid number of elements specified: " + nElements);
        }
        short[] arr = new short[nElements];
        for (int i = 0; i < nElements; ++i) {
            arr[i] = this.readShort(index);
            index += 2L;
        }
        return arr;
    }

    public int[] readIntArray(long index, int nElements) throws IOException {
        if (nElements < 0) {
            throw new IOException("Invalid number of elements specified: " + nElements);
        }
        int[] arr = new int[nElements];
        for (int i = 0; i < nElements; ++i) {
            arr[i] = this.readInt(index);
            index += 4L;
        }
        return arr;
    }

    public long[] readLongArray(long index, int nElements) throws IOException {
        if (nElements < 0) {
            throw new IOException("Invalid number of elements specified: " + nElements);
        }
        long[] arr = new long[nElements];
        for (int i = 0; i < nElements; ++i) {
            arr[i] = this.readLong(index);
            index += 8L;
        }
        return arr;
    }

    public String[] readAsciiStringArray(long index, int nElements) throws IOException {
        if (nElements < 0) {
            throw new IOException("Invalid number of elements specified: " + nElements);
        }
        String[] arr = new String[nElements];
        for (int i = 0; i < nElements; ++i) {
            String tmp;
            arr[i] = tmp = this.readAsciiString(index);
            index += (long)(tmp == null ? 1 : tmp.length());
        }
        return arr;
    }

    public ByteProvider getByteProvider() {
        return this.provider;
    }
}

