/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util;

import ghidra.app.util.html.ArrayDataTypeHTMLRepresentation;
import ghidra.app.util.html.BitFieldDataTypeHTMLRepresentation;
import ghidra.app.util.html.CompositeDataTypeHTMLRepresentation;
import ghidra.app.util.html.DefaultDataTypeHTMLRepresentation;
import ghidra.app.util.html.EnumDataTypeHTMLRepresentation;
import ghidra.app.util.html.FunctionDataTypeHTMLRepresentation;
import ghidra.app.util.html.HTMLDataTypeRepresentation;
import ghidra.app.util.html.NullDataTypeHTMLRepresentation;
import ghidra.app.util.html.PointerDataTypeHTMLRepresentation;
import ghidra.app.util.html.TypeDefDataTypeHTMLRepresentation;
import ghidra.app.util.viewer.options.OptionsGui;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.HTMLUtilities;
import ghidra.util.StringUtilities;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ToolTipUtils {
    private static final Color PARAM_NAME_COLOR = new Color(155, 50, 155);
    private static final Color PARAM_CUSTOM_STORAGE_COLOR = OptionsGui.PARAMETER_CUSTOM.getDefaultColor();
    private static final Color PARAM_DYNAMIC_STORAGE_COLOR = OptionsGui.PARAMETER_DYNAMIC.getDefaultColor();
    private static final String ELLIPSES = "...";
    public static final int LINE_LENGTH = 80;
    private static final int PARAM_LENGTH_WRAP_THRESHOLD = 80;
    private static final int PARAM_MAX_CHAR_LENGTH = 60;
    private static final int PARAM_COUNT_THRESHOLD = 13;

    private ToolTipUtils() {
    }

    public static String getToolTipText(DataType dataType) {
        return ToolTipUtils.getHTMLRepresentation(dataType).getHTMLString();
    }

    public static String getFullToolTipText(DataType dataType) {
        return ToolTipUtils.getHTMLRepresentation(dataType).getFullHTMLString();
    }

    public static HTMLDataTypeRepresentation getHTMLRepresentation(DataType dataType) {
        if (dataType != null) {
            if (dataType instanceof TypeDef) {
                return new TypeDefDataTypeHTMLRepresentation((TypeDef)dataType);
            }
            if (dataType instanceof Composite) {
                return new CompositeDataTypeHTMLRepresentation((Composite)dataType);
            }
            if (dataType instanceof Enum) {
                return new EnumDataTypeHTMLRepresentation((Enum)dataType);
            }
            if (dataType instanceof FunctionDefinition) {
                return new FunctionDataTypeHTMLRepresentation((FunctionDefinition)dataType);
            }
            if (dataType instanceof Pointer) {
                return new PointerDataTypeHTMLRepresentation((Pointer)dataType);
            }
            if (dataType instanceof Array) {
                return new ArrayDataTypeHTMLRepresentation((Array)dataType);
            }
            if (dataType instanceof BitFieldDataType) {
                return new BitFieldDataTypeHTMLRepresentation((BitFieldDataType)dataType);
            }
            return new DefaultDataTypeHTMLRepresentation(dataType);
        }
        return new NullDataTypeHTMLRepresentation();
    }

    public static String getToolTipText(ExternalLocation extLoc, boolean includeSymbolDetails) {
        DataType dt;
        if (extLoc.isFunction()) {
            return ToolTipUtils.getToolTipText(extLoc.getFunction(), includeSymbolDetails);
        }
        Symbol s = extLoc.getSymbol();
        StringBuilder buf = new StringBuilder("<HTML>");
        buf.append("External").append(HTMLUtilities.HTML_SPACE);
        if (includeSymbolDetails) {
            buf.append("Data");
            buf.append(HTMLUtilities.HTML_SPACE).append("-").append(HTMLUtilities.HTML_SPACE);
            buf.append(HTMLUtilities.friendlyEncodeHTML((String)s.getName(true)));
            Address addr = extLoc.getAddress();
            if (addr != null) {
                buf.append(HTMLUtilities.HTML_SPACE).append("@").append(HTMLUtilities.HTML_SPACE);
                buf.append(addr.toString(true));
            }
            buf.append("<BR>");
        }
        if ((dt = extLoc.getDataType()) == null) {
            dt = DataType.DEFAULT;
        }
        buf.append(HTMLUtilities.colorString((Color)Color.BLACK, (String)HTMLUtilities.friendlyEncodeHTML((String)dt.getName())));
        buf.append(HTMLUtilities.HTML_SPACE);
        buf.append(HTMLUtilities.friendlyEncodeHTML((String)s.getName()));
        return buf.toString();
    }

    public static String getToolTipText(Function function, boolean includeSymbolDetails) {
        String originalImportedName;
        StringBuilder buf = new StringBuilder("<HTML>");
        ExternalLocation extLoc = function.getExternalLocation();
        if (extLoc != null) {
            buf.append("External").append(HTMLUtilities.HTML_SPACE);
        } else if (function.isThunk()) {
            buf.append("Thunk").append(HTMLUtilities.HTML_SPACE);
        }
        if (includeSymbolDetails) {
            Address addr;
            buf.append("Function");
            buf.append(HTMLUtilities.HTML_SPACE).append("-").append(HTMLUtilities.HTML_SPACE);
            Parameter[] functionName = function.getSymbol().getName(true);
            functionName = StringUtilities.trimMiddle((String)functionName, (int)80);
            buf.append(HTMLUtilities.friendlyEncodeHTML((String)functionName));
            if (extLoc != null && (addr = extLoc.getAddress()) != null) {
                buf.append(HTMLUtilities.HTML_SPACE).append("@").append(HTMLUtilities.HTML_SPACE);
                buf.append(addr.toString(true));
            }
            buf.append("<BR>");
        }
        buf.append(ToolTipUtils.getFunctionSignaturePreview(function));
        buf.append("<BR>");
        buf.append("<table cellspacing=0 callpadding=0 border=0>");
        buf.append(ToolTipUtils.generateParameterDetailRow(function.getReturn()));
        for (Parameter p : function.getParameters()) {
            buf.append(ToolTipUtils.generateParameterDetailRow(p));
        }
        if (extLoc != null && (originalImportedName = extLoc.getOriginalImportedName()) != null) {
            buf.append("Imported").append(HTMLUtilities.HTML_SPACE).append("Name:").append(HTMLUtilities.HTML_SPACE).append(HTMLUtilities.friendlyEncodeHTML((String)originalImportedName));
        }
        buf.append("</table></html>");
        return buf.toString();
    }

    private static String generateParameterDetailRow(Parameter param) {
        Object type = param.getDataType().getName();
        Object name = param.getName();
        int length = ((String)type).length() + 1 + ((String)name).length();
        if (length > 60) {
            int half;
            int available = half = 30;
            if (((String)type).length() > half) {
                type = ((String)type).substring(0, half - 3) + ELLIPSES;
            } else {
                available = 60 - ((String)type).length();
            }
            if (((String)name).length() > available) {
                name = ((String)name).substring(0, available - 3) + ELLIPSES;
            }
        }
        StringBuilder buf = new StringBuilder();
        buf.append("<tr><td width=10>&nbsp;</td>");
        buf.append("<td width=\"1%\">");
        buf.append(HTMLUtilities.colorString((Color)Color.BLACK, (String)HTMLUtilities.friendlyEncodeHTML((String)type)));
        buf.append("</td><td width=\"1%\">");
        boolean usesCustomStorage = false;
        Function function = param.getFunction();
        if (function != null) {
            usesCustomStorage = function.hasCustomVariableStorage();
        }
        Color paramColor = usesCustomStorage ? PARAM_CUSTOM_STORAGE_COLOR : PARAM_DYNAMIC_STORAGE_COLOR;
        buf.append(HTMLUtilities.colorString((Color)paramColor, (String)HTMLUtilities.friendlyEncodeHTML((String)param.getVariableStorage().toString())));
        buf.append("</td><td width=\"1%\">");
        buf.append(HTMLUtilities.colorString((Color)PARAM_NAME_COLOR, (String)HTMLUtilities.friendlyEncodeHTML((String)name)));
        buf.append("</td><td width=\"100%\">&nbsp;</td></tr>");
        return buf.toString();
    }

    private static String getFunctionSignaturePreview(Function function) {
        StringBuilder buffy = new StringBuilder();
        if (function.hasNoReturn()) {
            buffy.append("noreturn").append(HTMLUtilities.HTML_SPACE);
        }
        buffy.append(HTMLUtilities.friendlyEncodeHTML((String)function.getReturnType().getName()));
        buffy.append(HTMLUtilities.HTML_SPACE);
        PrototypeModel callingConvention = function.getCallingConvention();
        if (ToolTipUtils.isNonDefaultCallingConvention(callingConvention)) {
            buffy.append(HTMLUtilities.friendlyEncodeHTML((String)callingConvention.getName()));
            buffy.append(HTMLUtilities.HTML_SPACE);
        }
        String functionName = StringUtilities.trimMiddle((String)function.getName(), (int)80);
        buffy.append(HTMLUtilities.colorString((Color)Color.BLUE, (String)HTMLUtilities.friendlyEncodeHTML((String)functionName)));
        buffy.append(HTMLUtilities.HTML_SPACE).append("(");
        ToolTipUtils.buildParameterPreview(function, buffy);
        return buffy.toString();
    }

    private static boolean isNonDefaultCallingConvention(PrototypeModel callingConvention) {
        if (callingConvention == null) {
            return false;
        }
        return !"default".equals(callingConvention.getName());
    }

    private static void buildParameterPreview(Function function, StringBuilder buffy) {
        String s;
        int rawTextLength = 0;
        Parameter[] parameters = function.getParameters();
        ArrayList<String> params = new ArrayList<String>();
        for (Parameter param : parameters) {
            rawTextLength += ToolTipUtils.generateParameterHtml(param, params);
        }
        if (function.hasVarArgs()) {
            s = ELLIPSES;
            params.add(s);
            rawTextLength += s.length();
        } else if (parameters.length == 0) {
            s = "void";
            params.add(s);
            rawTextLength += s.length();
        }
        if (rawTextLength > 80) {
            ToolTipUtils.generateParameterTable(buffy, params);
        } else {
            buffy.append(StringUtils.join(params, (String)("," + HTMLUtilities.HTML_SPACE)));
            buffy.append(')');
        }
    }

    private static void generateParameterTable(StringBuilder buffy, List<String> params) {
        StringBuilder psb = new StringBuilder("<table cellspacing=0 callpadding=0 border=0>");
        for (int i = 0; i < params.size(); ++i) {
            String param = params.get(i);
            if (i == 0) {
                buffy.append(param).append(",");
                continue;
            }
            psb.append("<tr><td width=75px></td><td>");
            if (i == 13) {
                psb.append(ELLIPSES).append(')');
                i = params.size();
            } else {
                psb.append(param).append(i < params.size() - 1 ? (char)',' : ')');
            }
            psb.append("</td></tr>");
        }
        buffy.append(psb.toString());
        buffy.append("</table>");
    }

    private static int generateParameterHtml(Parameter param, List<String> params) {
        int length;
        Object type = param.getDataType().getName();
        Object name = param.getName();
        int rawTextLength = length = ((String)type).length() + 1 + ((String)name).length();
        if (length > 60) {
            int half;
            int available = half = 30;
            if (((String)type).length() > half) {
                type = ((String)type).substring(0, half - 3) + ELLIPSES;
            } else {
                available = 60 - ((String)type).length();
            }
            if (((String)name).length() > available) {
                name = ((String)name).substring(0, available - 3) + ELLIPSES;
            }
        }
        StringBuilder pb = new StringBuilder();
        pb.append(HTMLUtilities.colorString((Color)Color.BLACK, (String)HTMLUtilities.friendlyEncodeHTML((String)type)));
        pb.append(HTMLUtilities.HTML_SPACE);
        pb.append(HTMLUtilities.colorString((Color)PARAM_NAME_COLOR, (String)HTMLUtilities.friendlyEncodeHTML((String)name)));
        params.add(pb.toString());
        return rawTextLength;
    }
}

