/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symboltree.nodes;

import ghidra.app.plugin.core.symboltree.nodes.SymbolNode;
import ghidra.app.plugin.core.symboltree.nodes.SymbolTreeDataFlavor;
import ghidra.app.util.ToolTipUtils;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.Symbol;
import java.awt.datatransfer.DataFlavor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.ResourceManager;

public class CodeSymbolNode
extends SymbolNode {
    static final DataFlavor LOCAL_DATA_FLAVOR = new SymbolTreeDataFlavor("Symbol Tree Data Flavor - Local Labels");
    static final DataFlavor GLOBAL_DATA_FLAVOR = new SymbolTreeDataFlavor("Symbol Tree Data Flavor - Global Labels");
    static final DataFlavor EXTERNAL_DATA_FLAVOR = new SymbolTreeDataFlavor("Symbol Tree Data Flavor - External Data");
    private static final Icon CODE_ICON = ResourceManager.loadImage((String)"images/label.png");
    private static final Icon PINNED_ICON = ResourceManager.loadImage((String)"images/pin.png");
    private static final Icon EXTERNAL_ICON = ResourceManager.loadImage((String)"images/ExternalData.gif");
    private static final Icon DISABLED_CODE_ICON = ResourceManager.getDisabledIcon((ImageIcon)((ImageIcon)CODE_ICON));
    private static final Icon DISABLED_EXTERNAL_ICON = ResourceManager.getDisabledIcon((ImageIcon)((ImageIcon)EXTERNAL_ICON));
    private String tooltip;
    private boolean isExternal;

    public CodeSymbolNode(Program program, Symbol symbol) {
        super(program, symbol);
    }

    @Override
    public Icon getIcon(boolean expanded) {
        if (this.isCut()) {
            return this.isExternal ? DISABLED_EXTERNAL_ICON : DISABLED_CODE_ICON;
        }
        if (this.isExternal) {
            return EXTERNAL_ICON;
        }
        return this.symbol.isPinned() ? PINNED_ICON : CODE_ICON;
    }

    @Override
    public String getToolTip() {
        if (this.tooltip == null) {
            this.createTooltip();
        }
        return this.tooltip;
    }

    private void createTooltip() {
        if (this.symbol.isExternal()) {
            this.isExternal = true;
            this.tooltip = "External Symbol - " + this.symbol.getName(true);
            Object object = this.symbol.getObject();
            if (object instanceof ExternalLocation) {
                this.tooltip = ToolTipUtils.getToolTipText((ExternalLocation)object, true);
            }
        } else {
            this.tooltip = this.symbol.isGlobal() ? "Global Symbol - " + this.symbol.getName(true) : "Local Symbol - " + this.symbol.getName(true);
        }
    }

    @Override
    public DataFlavor getNodeDataFlavor() {
        if (this.isExternal) {
            return EXTERNAL_DATA_FLAVOR;
        }
        return this.symbol.isGlobal() ? GLOBAL_DATA_FLAVOR : LOCAL_DATA_FLAVOR;
    }

    @Override
    public boolean canCut() {
        return !this.symbol.isExternal();
    }

    @Override
    public boolean isLeaf() {
        return true;
    }
}

