/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.references;

import docking.widgets.combobox.GhidraComboBox;
import docking.widgets.label.GLabel;
import ghidra.app.plugin.core.references.EditReferencePanel;
import ghidra.app.plugin.core.references.ReferencesPlugin;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.RefTypeFactory;
import ghidra.program.model.symbol.Reference;
import ghidra.util.layout.PairLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.border.EmptyBorder;

class EditRegisterReferencePanel
extends EditReferencePanel {
    private static final RefType[] REGISTER_REF_TYPES = RefTypeFactory.getDataRefTypes();
    private ReferencesPlugin plugin;
    private CodeUnit fromCodeUnit;
    private GhidraComboBox<Register> regList;
    private GhidraComboBox<RefType> refTypes;
    private int opIndex;
    private Reference editRef;
    private boolean isValidState;

    EditRegisterReferencePanel(ReferencesPlugin plugin) {
        super("REG");
        this.plugin = plugin;
        this.buildPanel();
    }

    private void buildPanel() {
        this.setLayout((LayoutManager)new PairLayout(10, 10, 160));
        this.setBorder(new EmptyBorder(0, 5, 5, 5));
        this.regList = new GhidraComboBox();
        this.refTypes = new GhidraComboBox((Object[])REGISTER_REF_TYPES);
        this.add((Component)new GLabel("Register:", 4));
        this.add((Component)this.regList);
        this.add((Component)new GLabel("Ref-Type:", 4));
        this.add((Component)this.refTypes);
    }

    private void populateRefTypes(RefType adhocType) {
        this.refTypes.clearModel();
        for (int i = 0; i < REGISTER_REF_TYPES.length; ++i) {
            if (adhocType == REGISTER_REF_TYPES[i]) {
                adhocType = null;
            }
            this.refTypes.addItem((Object)REGISTER_REF_TYPES[i]);
        }
        if (adhocType != null) {
            this.refTypes.addItem((Object)adhocType);
        }
    }

    private void populateRegisterList(Collection<Register> registers, Register selectedRegister) {
        this.regList.clearModel();
        for (Register reg : registers) {
            this.regList.addItem((Object)reg);
        }
        if (selectedRegister != null) {
            this.regList.setSelectedItem((Object)selectedRegister);
        }
    }

    private TreeSet<Register> getAllowedRegisters(Instruction instr, Register requiredReg) {
        Program program = instr.getProgram();
        Register stackPointer = program.getCompilerSpec().getStackPointer();
        TreeSet<Register> regSet = new TreeSet<Register>();
        for (Object obj : instr.getResultObjects()) {
            Register reg = null;
            if (obj instanceof Register) {
                reg = (Register)obj;
            } else if (obj instanceof Address) {
                reg = program.getRegister((Address)obj);
            }
            if (reg == null || (reg = reg.getBaseRegister()).isHidden() || reg.isProcessorContext() || reg.isProgramCounter() || stackPointer != null && stackPointer.equals((Object)reg)) continue;
            regSet.add(reg);
            this.addChildRegisters(reg, regSet);
        }
        if (requiredReg != null && !regSet.contains(requiredReg)) {
            regSet.add(requiredReg);
        }
        return regSet;
    }

    private void addChildRegisters(Register reg, Set<Register> regSet) {
        for (Register child : reg.getChildRegisters()) {
            regSet.add(child);
            this.addChildRegisters(child, regSet);
        }
    }

    @Override
    public void initialize(CodeUnit fromCu, Reference editReference) {
        this.isValidState = false;
        if (!(fromCu instanceof Instruction)) {
            throw new IllegalArgumentException("Valid instruction required");
        }
        Register toReg = fromCu.getProgram().getRegister(editReference.getToAddress());
        if (toReg == null) {
            throw new IllegalArgumentException("Valid register reference required");
        }
        this.fromCodeUnit = fromCu;
        this.editRef = editReference;
        this.populateRegisterList(this.getAllowedRegisters((Instruction)fromCu, toReg), toReg);
        RefType rt = this.editRef.getReferenceType();
        this.populateRefTypes(rt);
        this.refTypes.setSelectedItem((Object)rt);
        this.isValidState = true;
    }

    @Override
    public boolean initialize(CodeUnit fromCu, int fromOpIndex, int fromSubIndex) {
        this.isValidState = false;
        this.editRef = null;
        this.fromCodeUnit = fromCu;
        return this.setOpIndex(fromOpIndex);
    }

    private static Register findOperandRegister(Instruction instr, int opIndex) {
        Object[] objs = instr.getOpObjects(opIndex);
        if (objs.length == 1) {
            if (objs[0] instanceof Register) {
                return (Register)objs[0];
            }
            if (objs[0] instanceof Address) {
                return instr.getProgram().getRegister((Address)objs[0]);
            }
        }
        return null;
    }

    @Override
    public boolean setOpIndex(int fromOpIndex) {
        if (this.editRef != null) {
            throw new IllegalStateException("setOpIndex only permitted for ADD case");
        }
        this.isValidState = false;
        this.opIndex = fromOpIndex;
        if (!(this.fromCodeUnit instanceof Instruction)) {
            return false;
        }
        Function f = this.fromCodeUnit.getProgram().getFunctionManager().getFunctionContaining(this.fromCodeUnit.getMinAddress());
        if (f == null) {
            return false;
        }
        Instruction instr = (Instruction)this.fromCodeUnit;
        TreeSet<Register> allowedRegisters = this.getAllowedRegisters(instr, null);
        if (allowedRegisters.isEmpty()) {
            return false;
        }
        Register preferredReg = EditRegisterReferencePanel.findOperandRegister(instr, fromOpIndex);
        this.populateRegisterList(allowedRegisters, preferredReg);
        this.populateRefTypes(null);
        this.refTypes.setSelectedItem((Object)RefType.WRITE);
        this.isValidState = true;
        return true;
    }

    @Override
    public boolean applyReference() {
        if (!this.isValidState) {
            throw new IllegalStateException();
        }
        Function f = this.fromCodeUnit.getProgram().getFunctionManager().getFunctionContaining(this.fromCodeUnit.getMinAddress());
        if (f == null) {
            this.showInputErr("Register reference not permitted!\nAddress " + this.fromCodeUnit.getMinAddress() + " is no longer contained within a function.");
            return false;
        }
        RefType refType = (RefType)this.refTypes.getSelectedItem();
        if (refType == null) {
            this.showInputErr("A 'Ref-Type' must be selected.");
            return false;
        }
        Register toReg = (Register)this.regList.getSelectedItem();
        if (toReg == null) {
            this.showInputErr("A 'Register' must be selected.");
            return false;
        }
        if (this.editRef != null) {
            return this.plugin.updateReference(this.editRef, this.fromCodeUnit, toReg, refType);
        }
        return this.plugin.addReference(this.fromCodeUnit, this.opIndex, toReg, refType);
    }

    @Override
    public void cleanup() {
        this.isValidState = false;
        this.fromCodeUnit = null;
        this.editRef = null;
    }

    @Override
    public boolean isValidContext() {
        return this.isValidState;
    }
}

