/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.function;

import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;

public class CreateExternalFunctionCmd
implements Command {
    private Symbol extSymbol;
    private String libraryName;
    private Namespace parentNamespace;
    private String name;
    private Address address;
    private SourceType source;
    private String status;

    public CreateExternalFunctionCmd(Symbol extSymbol) {
        if (extSymbol == null) {
            throw new IllegalArgumentException("External symbol may not be null");
        }
        this.extSymbol = extSymbol;
        this.source = extSymbol.getSource();
    }

    public CreateExternalFunctionCmd(String libraryName, String name, Address address, SourceType source) {
        String string = this.libraryName = libraryName != null ? libraryName : "<EXTERNAL>";
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("External function name must be specified");
        }
        this.name = name;
        this.address = address;
        if (source == null) {
            throw new IllegalArgumentException("Source cannot be null");
        }
        this.source = source;
    }

    public CreateExternalFunctionCmd(Namespace externalParentNamespace, String name, Address address, SourceType source) {
        if (externalParentNamespace == null || name.length() == 0) {
            throw new IllegalArgumentException("A parent namespace must be specified.");
        }
        if (!externalParentNamespace.isExternal()) {
            throw new IllegalArgumentException("The parent namespace must be an external namespace.");
        }
        this.parentNamespace = externalParentNamespace;
        this.name = name;
        this.address = address;
        if (source == null) {
            throw new IllegalArgumentException("Source cannot be null");
        }
        this.source = source;
    }

    public boolean applyTo(DomainObject obj) {
        Program program = (Program)obj;
        if (this.extSymbol == null) {
            return this.createExternalFunction(program);
        }
        if (!this.extSymbol.isExternal() || this.extSymbol.getSymbolType() != SymbolType.LABEL) {
            return false;
        }
        ExternalLocation extLoc = (ExternalLocation)this.extSymbol.getObject();
        Function function = extLoc.createFunction();
        this.extSymbol = function.getSymbol();
        if (this.extSymbol.getSource() != this.source) {
            this.extSymbol.setSource(this.source);
        }
        return true;
    }

    private boolean createExternalFunction(Program program) {
        try {
            ExternalManager extMgr = program.getExternalManager();
            ExternalLocation extLoc = this.parentNamespace == null ? extMgr.addExtFunction(this.libraryName, this.name, this.address, this.source) : extMgr.addExtFunction(this.parentNamespace, this.name, this.address, this.source);
            this.extSymbol = extLoc.getSymbol();
            return true;
        }
        catch (DuplicateNameException e) {
            this.status = e.getMessage();
        }
        catch (InvalidInputException e) {
            this.status = e.getMessage();
        }
        return false;
    }

    public String getStatusMsg() {
        return this.status;
    }

    public String getName() {
        return "Create External Function";
    }

    public Symbol getExtSymbol() {
        return this.extSymbol;
    }
}

