/*
 * Decompiled with CFR 0.152.
 */
package pdb.symbolserver.ui;

import docking.DockingWindowManager;
import docking.options.editor.ButtonPanelFactory;
import docking.widgets.OptionDialog;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import docking.widgets.label.GHtmlLabel;
import docking.widgets.label.GLabel;
import docking.widgets.table.GTable;
import docking.widgets.textfield.HintTextField;
import ghidra.framework.preferences.Preferences;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import ghidra.util.MessageType;
import ghidra.util.Msg;
import ghidra.util.layout.PairLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import pdb.PdbPlugin;
import pdb.symbolserver.HttpSymbolServer;
import pdb.symbolserver.LocalSymbolStore;
import pdb.symbolserver.SameDirSymbolStore;
import pdb.symbolserver.SymbolServer;
import pdb.symbolserver.SymbolServerInstanceCreatorContext;
import pdb.symbolserver.SymbolServerService;
import pdb.symbolserver.SymbolStore;
import pdb.symbolserver.ui.FilePromptDialog;
import pdb.symbolserver.ui.LoadPdbDialog;
import pdb.symbolserver.ui.SymbolServerTableModel;
import pdb.symbolserver.ui.WellKnownSymbolServerLocation;
import resources.Icons;
import utilities.util.FileUtilities;

class SymbolServerPanel
extends JPanel {
    private static final String MS_SYMBOLSERVER_ENVVAR = "_NT_SYMBOL_PATH";
    private static List<WellKnownSymbolServerLocation> knownSymbolServers = WellKnownSymbolServerLocation.loadAll();
    private SymbolStore localSymbolStore;
    private SymbolServerInstanceCreatorContext symbolServerInstanceCreatorContext;
    private SymbolServerTableModel tableModel;
    private GTable table;
    private JPanel additionalSearchLocationsPanel;
    private JPanel defaultConfigNotice;
    private GhidraFileChooser chooser;
    private Consumer<SymbolServerService> changeCallback;
    private JButton refreshSearchLocationsStatusButton;
    private JButton moveLocationUpButton;
    private JButton moveLocationDownButton;
    private JButton deleteLocationButton;
    private JButton addLocationButton;
    private JPanel symbolStorageLocationPanel;
    private HintTextField symbolStorageLocationTextField;
    private JButton chooseSymbolStorageLocationButton;
    private JButton saveSearchLocationsButton;
    private boolean configChanged;

    SymbolServerPanel(Consumer<SymbolServerService> changeCallback, SymbolServerInstanceCreatorContext symbolServerInstanceCreatorContext) {
        this.symbolServerInstanceCreatorContext = symbolServerInstanceCreatorContext;
        this.build();
        DockingWindowManager.getHelpService().registerHelp((Object)this, new HelpLocation("Pdb", "Symbol Server Config"));
        SymbolServerService temporarySymbolServerService = PdbPlugin.getSymbolServerService(symbolServerInstanceCreatorContext);
        if (temporarySymbolServerService.getSymbolStore() instanceof LocalSymbolStore) {
            this.setSymbolStorageLocation(((LocalSymbolStore)temporarySymbolServerService.getSymbolStore()).getRootDir(), false);
        }
        this.tableModel.addSymbolServers(temporarySymbolServerService.getSymbolServers());
        this.setConfigChanged(false);
        this.changeCallback = changeCallback;
    }

    private void build() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder("Symbol Server Search Config"));
        this.buildSymbolStorageLocationPanel();
        JPanel buttonPanel = this.buildButtonPanel();
        JScrollPane tableScrollPane = this.buildTable();
        this.defaultConfigNotice = new JPanel();
        this.defaultConfigNotice.add((Component)new GHtmlLabel("<html><center><font color=red><br>Missing / invalid configuration.<br><br>Using default search location:<br>Program's Import Location<br>", 0));
        this.defaultConfigNotice.setPreferredSize(tableScrollPane.getPreferredSize());
        this.additionalSearchLocationsPanel = new JPanel();
        this.additionalSearchLocationsPanel.setLayout(new BoxLayout(this.additionalSearchLocationsPanel, 1));
        this.additionalSearchLocationsPanel.add(buttonPanel);
        this.additionalSearchLocationsPanel.add(tableScrollPane);
        this.add((Component)this.symbolStorageLocationPanel, "North");
        this.add((Component)this.additionalSearchLocationsPanel, "Center");
    }

    private void updateLayout(boolean showTable) {
        if (showTable == (this.additionalSearchLocationsPanel.getParent() != null)) {
            return;
        }
        this.remove(this.additionalSearchLocationsPanel);
        this.remove(this.defaultConfigNotice);
        this.add((Component)(showTable ? this.additionalSearchLocationsPanel : this.defaultConfigNotice), "Center");
        this.invalidate();
    }

    SymbolServerService getSymbolServerService() {
        return this.localSymbolStore != null ? new SymbolServerService(this.localSymbolStore, this.tableModel.getSymbolServers()) : null;
    }

    void setSymbolServers(List<SymbolServer> symbolServers) {
        this.tableModel.setSymbolServers(symbolServers);
    }

    boolean isConfigChanged() {
        return this.configChanged || this.tableModel.isDataChanged();
    }

    void setConfigChanged(boolean configChanged) {
        this.configChanged = configChanged;
        this.tableModel.setDataChanged(configChanged);
    }

    private JScrollPane buildTable() {
        this.tableModel = new SymbolServerTableModel();
        this.table = new GTable((TableModel)((Object)this.tableModel));
        this.table.setVisibleRowCount(4);
        this.table.setUserSortingEnabled(false);
        this.table.getSelectionManager().addListSelectionListener(e -> this.updateButtonEnablement());
        this.tableModel.addTableModelListener(e -> {
            this.updateButtonEnablement();
            this.fireChanged();
        });
        TableColumn enabledColumn = this.table.getColumnModel().getColumn(0);
        enabledColumn.setResizable(false);
        enabledColumn.setPreferredWidth(32);
        enabledColumn.setMaxWidth(32);
        enabledColumn.setMinWidth(32);
        TableColumn statusColumn = this.table.getColumnModel().getColumn(1);
        statusColumn.setResizable(false);
        statusColumn.setPreferredWidth(32);
        statusColumn.setMaxWidth(32);
        statusColumn.setMinWidth(32);
        this.table.setPreferredScrollableViewportSize(new Dimension(100, 100));
        return new JScrollPane((Component)this.table);
    }

    private JPanel buildButtonPanel() {
        this.refreshSearchLocationsStatusButton = SymbolServerPanel.createImageButton(Icons.REFRESH_ICON, "Refresh Status", ButtonPanelFactory.ARROW_SIZE);
        this.refreshSearchLocationsStatusButton.addActionListener(e -> this.refreshSearchLocationStatus());
        DockingWindowManager.getHelpService().registerHelp((Object)this.refreshSearchLocationsStatusButton, new HelpLocation("Pdb", "SymbolServerConfig Refresh Status"));
        this.moveLocationUpButton = ButtonPanelFactory.createButton((int)0);
        this.moveLocationUpButton.addActionListener(e -> this.moveLocation(-1));
        this.moveLocationUpButton.setToolTipText("Move location up");
        DockingWindowManager.getHelpService().registerHelp((Object)this.moveLocationUpButton, new HelpLocation("Pdb", "SymbolServerConfig MoveUpDown"));
        this.moveLocationDownButton = ButtonPanelFactory.createButton((int)1);
        this.moveLocationDownButton.addActionListener(e -> this.moveLocation(1));
        this.moveLocationDownButton.setToolTipText("Move location down");
        DockingWindowManager.getHelpService().registerHelp((Object)this.moveLocationDownButton, new HelpLocation("Pdb", "SymbolServerConfig MoveUpDown"));
        this.deleteLocationButton = SymbolServerPanel.createImageButton(Icons.DELETE_ICON, "Delete", ButtonPanelFactory.ARROW_SIZE);
        this.deleteLocationButton.addActionListener(e -> this.deleteLocation());
        DockingWindowManager.getHelpService().registerHelp((Object)this.deleteLocationButton, new HelpLocation("Pdb", "SymbolServerConfig Delete"));
        this.addLocationButton = SymbolServerPanel.createImageButton(Icons.ADD_ICON, "Add", ButtonPanelFactory.ARROW_SIZE);
        this.addLocationButton.addActionListener(e -> this.addLocation());
        DockingWindowManager.getHelpService().registerHelp((Object)this.addLocationButton, new HelpLocation("Pdb", "SymbolServerConfig Add"));
        this.saveSearchLocationsButton = ButtonPanelFactory.createImageButton((ImageIcon)Icons.get((String)"images/disk.png"), (String)"Save Configuration", (Dimension)ButtonPanelFactory.ARROW_SIZE);
        this.saveSearchLocationsButton.addActionListener(e -> this.saveConfig());
        DockingWindowManager.getHelpService().registerHelp((Object)this.saveSearchLocationsButton, new HelpLocation("Pdb", "SymbolServerConfig Save"));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add((Component)new GLabel("Additional Search Paths:"));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.addLocationButton);
        buttonPanel.add(this.deleteLocationButton);
        buttonPanel.add(this.moveLocationUpButton);
        buttonPanel.add(this.moveLocationDownButton);
        buttonPanel.add(this.refreshSearchLocationsStatusButton);
        buttonPanel.add(this.saveSearchLocationsButton);
        return buttonPanel;
    }

    private JPanel buildSymbolStorageLocationPanel() {
        this.symbolStorageLocationTextField = new HintTextField(" Required ");
        this.symbolStorageLocationTextField.setEditable(false);
        this.symbolStorageLocationTextField.setToolTipText("User-specified directory where PDB files are stored.  Required.");
        this.chooseSymbolStorageLocationButton = ButtonPanelFactory.createButton((int)2);
        this.chooseSymbolStorageLocationButton.addActionListener(e -> this.chooseSymbolStorageLocation());
        this.symbolStorageLocationPanel = new JPanel((LayoutManager)new PairLayout(5, 5));
        GLabel symbolStorageLocLabel = new GLabel("Local Symbol Storage:", 4);
        symbolStorageLocLabel.setToolTipText(this.symbolStorageLocationTextField.getToolTipText());
        this.symbolStorageLocationPanel.add((Component)symbolStorageLocLabel);
        this.symbolStorageLocationPanel.add(LoadPdbDialog.join(null, (JComponent)this.symbolStorageLocationTextField, this.chooseSymbolStorageLocationButton));
        return this.symbolStorageLocationPanel;
    }

    private void updateButtonEnablement() {
        boolean hasLocalSymbolStore = this.localSymbolStore != null;
        boolean singleRow = this.table.getSelectedRowCount() == 1;
        boolean moreThanOneRow = this.table.getRowCount() > 1;
        this.refreshSearchLocationsStatusButton.setEnabled(hasLocalSymbolStore && !this.tableModel.isEmpty());
        this.moveLocationUpButton.setEnabled(hasLocalSymbolStore && singleRow && moreThanOneRow);
        this.moveLocationDownButton.setEnabled(hasLocalSymbolStore && singleRow && moreThanOneRow);
        this.addLocationButton.setEnabled(hasLocalSymbolStore);
        this.deleteLocationButton.setEnabled(hasLocalSymbolStore && this.table.getSelectedRowCount() > 0);
        this.saveSearchLocationsButton.setEnabled(hasLocalSymbolStore && this.isConfigChanged());
        this.updateLayout(hasLocalSymbolStore);
    }

    private void setSymbolStorageLocation(File symbolStorageDir, boolean allowGUIPrompt) {
        if (symbolStorageDir == null) {
            return;
        }
        if (!symbolStorageDir.exists()) {
            if (!allowGUIPrompt) {
                return;
            }
            int opt = OptionDialog.showOptionDialog((Component)this, (String)"Create Local Symbol Storage Directory?", (String)("<html>Symbol storage directory<br>" + HTMLUtilities.escapeHTML((String)symbolStorageDir.getPath()) + "<br>does not exist.  Create?"), (String)"Yes", (int)3);
            if (opt == 0) {
                return;
            }
            try {
                FileUtilities.checkedMkdirs((File)symbolStorageDir);
            }
            catch (IOException e) {
                Msg.showError((Object)this, (Component)this, (String)"Failure", (Object)("Failed to create symbol storage directory " + symbolStorageDir + ": " + e.getMessage()));
                return;
            }
        }
        if (allowGUIPrompt && SymbolServerPanel.isEmptyDirectory(symbolStorageDir) && OptionDialog.showYesNoDialog((Component)this, (String)"Initialize Symbol Storage Directory?", (String)"<html>Initialize new directory as Microsoft symbol storage directory?") == 1) {
            try {
                LocalSymbolStore.create(symbolStorageDir, 1);
            }
            catch (IOException e) {
                Msg.showError((Object)this, (Component)this, (String)"Initialize Failure", (Object)("Failed to initialize symbol storage directory " + symbolStorageDir), (Throwable)e);
            }
        }
        this.localSymbolStore = this.symbolServerInstanceCreatorContext.getSymbolServerInstanceCreatorRegistry().newSymbolServer(symbolStorageDir.getPath(), this.symbolServerInstanceCreatorContext, SymbolStore.class);
        this.symbolStorageLocationTextField.setText(symbolStorageDir.getPath());
        this.fireChanged();
    }

    private void fireChanged() {
        if (this.changeCallback != null) {
            this.changeCallback.accept(this.getSymbolServerService());
        }
    }

    private void chooseSymbolStorageLocation() {
        this.configChanged = true;
        this.setSymbolStorageLocation(this.getChooser().getSelectedFile(), true);
        this.updateButtonEnablement();
    }

    private void importLocations() {
        String envVar = (String)JOptionPane.showInputDialog(this, "<html>Enter value:<br><br>Example: SVR*c:\\symbols*https://msdl.microsoft.com/download/symbols/<br><br>", "Enter Symbol Server Search Path Value", 3, null, null, Objects.requireNonNullElse(System.getenv(MS_SYMBOLSERVER_ENVVAR), ""));
        if (envVar == null) {
            return;
        }
        List<String> symbolServerPaths = this.getSymbolPathsFromEnvStr(envVar);
        if (!symbolServerPaths.isEmpty()) {
            String firstSearchPath = symbolServerPaths.get(0);
            SymbolServer symbolServer = this.symbolServerInstanceCreatorContext.getSymbolServerInstanceCreatorRegistry().newSymbolServer(firstSearchPath, this.symbolServerInstanceCreatorContext);
            if (symbolServer instanceof LocalSymbolStore && ((LocalSymbolStore)symbolServer).isValid()) {
                int choice = OptionDialog.showYesNoCancelDialog((Component)this, (String)"Set Symbol Storage Location", (String)("Set symbol storage location to " + firstSearchPath + "?"));
                if (choice == 0) {
                    return;
                }
                if (choice == 1) {
                    symbolServerPaths.remove(0);
                    this.configChanged = true;
                    this.setSymbolStorageLocation(((LocalSymbolStore)symbolServer).getRootDir(), true);
                    this.symbolStorageLocationTextField.setText(symbolServer.getName());
                }
            }
        }
        this.tableModel.addSymbolServers(this.symbolServerInstanceCreatorContext.getSymbolServerInstanceCreatorRegistry().createSymbolServersFromPathList(symbolServerPaths, this.symbolServerInstanceCreatorContext));
        this.fireChanged();
    }

    private List<String> getSymbolPathsFromEnvStr(String envString) {
        String[] envParts = envString.split("[*;]");
        ArrayList<String> results = new ArrayList<String>();
        HashSet<String> locationStringDeduplicationSet = new HashSet<String>();
        for (int i = 0; i < envParts.length; ++i) {
            String locationString = envParts[i].trim();
            if (locationString.isBlank() || locationString.equalsIgnoreCase("srv") || locationStringDeduplicationSet.contains(locationString)) continue;
            results.add(locationString);
            locationStringDeduplicationSet.add(locationString);
        }
        return results;
    }

    private void addLocation() {
        JPopupMenu menu = this.createAddLocationPopupMenu();
        menu.show(this.addLocationButton, 0, 0);
    }

    private JPopupMenu createAddLocationPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem addDirMenuItem = new JMenuItem("Directory");
        addDirMenuItem.addActionListener(e -> this.addDirectoryLocation());
        menu.add(addDirMenuItem);
        JMenuItem addURLMenuItem = new JMenuItem("URL");
        addURLMenuItem.addActionListener(e -> this.addUrlLocation());
        menu.add(addURLMenuItem);
        JMenuItem addProgLocMenuItem = new JMenuItem(SameDirSymbolStore.PROGRAMS_IMPORT_LOCATION_DESCRIPTION_STR);
        addProgLocMenuItem.addActionListener(e -> this.addSameDirLocation());
        menu.add(addProgLocMenuItem);
        JMenuItem importEnvMenuItem = new JMenuItem("Import _NT_SYMBOL_PATH");
        importEnvMenuItem.addActionListener(e -> this.importLocations());
        menu.add(importEnvMenuItem);
        if (!knownSymbolServers.isEmpty()) {
            menu.add(new JSeparator());
            for (WellKnownSymbolServerLocation ssloc : knownSymbolServers) {
                JMenuItem mi = new JMenuItem(ssloc.getLocation());
                mi.addActionListener(e -> this.addKnownLocation(ssloc));
                mi.setToolTipText(" [from " + ssloc.getFileOrigin() + "]");
                menu.add(mi);
            }
        }
        DockingWindowManager.getHelpService().registerHelp((Object)menu, new HelpLocation("Pdb", "SymbolServerConfig_Add"));
        return menu;
    }

    private void addSameDirLocation() {
        SameDirSymbolStore sameDirSymbolStore = new SameDirSymbolStore(this.symbolServerInstanceCreatorContext.getRootDir());
        this.tableModel.addSymbolServer(sameDirSymbolStore);
    }

    private void addKnownLocation(WellKnownSymbolServerLocation ssloc) {
        SymbolServer symbolServer = this.symbolServerInstanceCreatorContext.getSymbolServerInstanceCreatorRegistry().newSymbolServer(ssloc.getLocation(), this.symbolServerInstanceCreatorContext);
        if (symbolServer != null) {
            this.tableModel.addSymbolServer(symbolServer);
        }
    }

    private void addUrlLocation() {
        String urlLocationString = OptionDialog.showInputSingleLineDialog((Component)this, (String)"Enter URL", (String)"Enter the URL of a Symbol Server: ", (String)"https://");
        if (urlLocationString == null || urlLocationString.isBlank()) {
            return;
        }
        if (!(urlLocationString = urlLocationString.toLowerCase()).startsWith("http://") && !urlLocationString.startsWith("https://")) {
            Msg.showWarn((Object)this, (Component)this, (String)"Bad URL", (Object)("Invalid URL: " + urlLocationString));
            return;
        }
        try {
            HttpSymbolServer httpSymbolServer = new HttpSymbolServer(URI.create(urlLocationString));
            this.tableModel.addSymbolServer(httpSymbolServer);
        }
        catch (IllegalArgumentException e) {
            Msg.showWarn((Object)this, (Component)this, (String)"Bad URL", (Object)("Invalid URL: " + urlLocationString));
        }
    }

    private void addDirectoryLocation() {
        File dir = FilePromptDialog.chooseDirectory("Enter Path", "Symbol Storage Location: ", null);
        if (dir == null) {
            return;
        }
        if (!dir.exists() || !dir.isDirectory()) {
            Msg.showError((Object)this, (Component)this, (String)"Bad path", (Object)("Invalid path: " + dir));
            return;
        }
        LocalSymbolStore localSymbolStore = new LocalSymbolStore(dir);
        this.tableModel.addSymbolServer(localSymbolStore);
    }

    private void deleteLocation() {
        int selectedRow = this.table.getSelectedRow();
        this.tableModel.deleteRows(this.table.getSelectedRows());
        if (selectedRow >= 0 && selectedRow < this.table.getRowCount()) {
            this.table.selectRow(selectedRow);
        }
    }

    private void moveLocation(int delta) {
        if (this.table.getSelectedRowCount() == 1) {
            this.tableModel.moveRow(this.table.getSelectedRow(), delta);
        }
    }

    private void refreshSearchLocationStatus() {
        this.tableModel.refreshSymbolServerLocationStatus();
        this.updateButtonEnablement();
    }

    void saveConfig() {
        SymbolServerService temporarySymbolServerService = this.getSymbolServerService();
        if (temporarySymbolServerService != null) {
            PdbPlugin.saveSymbolServerServiceConfig(temporarySymbolServerService);
            Preferences.store();
            this.setConfigChanged(false);
            this.fireChanged();
            this.updateButtonEnablement();
        }
    }

    private GhidraFileChooser getChooser() {
        if (this.chooser == null) {
            this.chooser = new GhidraFileChooser((Component)this);
            this.chooser.setMultiSelectionEnabled(false);
            this.chooser.setApproveButtonText("Choose");
            this.chooser.setFileSelectionMode(GhidraFileChooserMode.DIRECTORIES_ONLY);
            this.chooser.setTitle("Select Symbol Storage Dir");
        }
        return this.chooser;
    }

    void pushAddLocationButton() {
        this.addLocation();
    }

    void setSymbolStorageDirectoryTextOnly(String pathStr) {
        this.symbolStorageLocationTextField.setText(pathStr);
    }

    private static boolean isEmptyDirectory(File directory) {
        if (directory.isDirectory()) {
            File[] dirContents = directory.listFiles();
            return dirContents != null && dirContents.length == 0;
        }
        return false;
    }

    private static JButton createImageButton(ImageIcon buttonIcon, String alternateText, Dimension preferredSize) {
        JButton button = ButtonPanelFactory.createButton((String)"");
        button.setIcon(buttonIcon);
        button.setToolTipText(alternateText);
        button.setPreferredSize(preferredSize);
        return button;
    }

    static LoadPdbDialog.StatusText getSymbolServerWarnings(List<SymbolServer> symbolServers) {
        HashMap<String, String> warningsByLocation = new HashMap<String, String>();
        for (WellKnownSymbolServerLocation ssloc : knownSymbolServers) {
            if (ssloc.getWarning() == null || ssloc.getWarning().isBlank()) continue;
            warningsByLocation.put(ssloc.getLocation(), ssloc.getWarning());
        }
        String warning = symbolServers.stream().map(symbolServer -> (String)warningsByLocation.get(symbolServer.getName())).filter(Objects::nonNull).distinct().collect(Collectors.joining("<br>\n"));
        return !warning.isEmpty() ? new LoadPdbDialog.StatusText(warning, MessageType.WARNING, false) : null;
    }
}

