/*
 * Decompiled with CFR 0.152.
 */
package pdb.symbolserver;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbIdentifiers;
import ghidra.app.util.datatype.microsoft.GUID;
import ghidra.app.util.pdb.PdbProgramAttributes;
import ghidra.program.model.listing.Program;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.util.Objects;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import pdb.PdbUtils;

public class SymbolFileInfo {
    private static final int MIN_SIG_HEX_STR_LEN = 8;
    private static final int GUID_HEX_STR_LEN = 32;
    private final PdbIdentifiers pdbIdentifiers;
    private final String pdbPath;

    public static SymbolFileInfo fromProgramInfo(Program program) {
        try {
            PdbProgramAttributes pdbAttrs = new PdbProgramAttributes(program);
            int sig = pdbAttrs.getPdbSignatureAsInt();
            String guidString = pdbAttrs.getPdbGuid();
            GUID guid = null;
            if (!StringUtils.isBlank((CharSequence)guidString)) {
                try {
                    guid = new GUID(guidString);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            int age = pdbAttrs.getPdbAgeAsInt();
            String path = pdbAttrs.getPdbFile();
            String string = path = !StringUtils.isBlank((CharSequence)path) ? path : "";
            if (sig == 0 && guid == null && path.isEmpty()) {
                return null;
            }
            PdbIdentifiers pdbIdentifiers = new PdbIdentifiers(0, sig, age, guid, null);
            return new SymbolFileInfo(path, pdbIdentifiers);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static SymbolFileInfo fromSubdirectoryPath(String path, String uniqueSubdir) {
        try {
            if (8 < uniqueSubdir.length() && uniqueSubdir.length() < 32) {
                int sig = Integer.parseUnsignedInt(uniqueSubdir.substring(0, 8), 16);
                int age = Integer.parseUnsignedInt(uniqueSubdir.substring(8), 16);
                return new SymbolFileInfo(path, new PdbIdentifiers(0, sig, age, null, null));
            }
            if (uniqueSubdir.length() > 32) {
                String guidString = uniqueSubdir.substring(0, 32);
                GUID guid = new GUID(guidString);
                int age = Integer.parseUnsignedInt(uniqueSubdir.substring(32), 16);
                return new SymbolFileInfo(path, new PdbIdentifiers(0, 0, age, guid, null));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    public static SymbolFileInfo fromValues(String path, String uid, int age) {
        if (StringUtils.isBlank((CharSequence)path)) {
            return null;
        }
        try {
            GUID guid = new GUID(uid);
            return new SymbolFileInfo(path, new PdbIdentifiers(0, 0, age, guid, null));
        }
        catch (IllegalArgumentException guid) {
            try {
                int sig = Integer.parseUnsignedInt(uid, 16);
                return new SymbolFileInfo(path, new PdbIdentifiers(0, sig, age, null, null));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
    }

    public static SymbolFileInfo fromPdbIdentifiers(String path, PdbIdentifiers pdbIdent) {
        Objects.requireNonNull(path);
        return new SymbolFileInfo(path, pdbIdent);
    }

    public static SymbolFileInfo fromFile(File pdbFile, TaskMonitor monitor) {
        PdbIdentifiers pdbIdentifiers = PdbUtils.getPdbIdentifiers(pdbFile, monitor);
        return pdbIdentifiers != null ? new SymbolFileInfo(pdbFile.getName(), pdbIdentifiers) : null;
    }

    private SymbolFileInfo(String pdbPath, PdbIdentifiers pdbIdentifiers) {
        this.pdbPath = Objects.requireNonNull(pdbPath);
        this.pdbIdentifiers = pdbIdentifiers;
    }

    public PdbIdentifiers getIdentifiers() {
        return this.pdbIdentifiers;
    }

    public String getName() {
        return FilenameUtils.getName((String)this.pdbPath);
    }

    public String getPath() {
        return this.pdbPath;
    }

    public String getUniqueName() {
        return this.pdbIdentifiers.getGuid() != null ? this.pdbIdentifiers.getGuid().toString().replace("-", "").toUpperCase() : String.format("%08X", this.pdbIdentifiers.getSignature());
    }

    public String getUniqifierString() {
        if (this.pdbIdentifiers.getGuid() != null) {
            return this.pdbIdentifiers.getGuid().toString().replace("-", "").toUpperCase();
        }
        if (this.pdbIdentifiers.getSignature() != 0) {
            return String.format("%08X", this.pdbIdentifiers.getSignature());
        }
        return "";
    }

    public String getUniqueDirName() {
        return this.getUniqueName() + Integer.toUnsignedString(this.pdbIdentifiers.getAge(), 16);
    }

    public boolean isExactMatch(SymbolFileInfo other) {
        return this.getUniqueName().equalsIgnoreCase(other.getUniqueName()) && this.pdbIdentifiers.getAge() == other.getIdentifiers().getAge();
    }

    public String getDescription() {
        return this.getName() + ", " + this.getIdentifiers();
    }

    public String toString() {
        return String.format("SymbolFileInfo: [ pdb: %s, uid: %s]", this.getName(), this.getIdentifiers().toString());
    }

    public int hashCode() {
        return Objects.hash(this.pdbIdentifiers, this.pdbPath);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SymbolFileInfo other = (SymbolFileInfo)obj;
        return Objects.equals(this.pdbIdentifiers, other.pdbIdentifiers) && Objects.equals(this.pdbPath, other.pdbPath);
    }
}

