/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.NamespaceUtils;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractLabelMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.pdb.pdbapplicator.MsSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.PdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.SymbolGroup;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.symbol.Namespace;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;

public class LabelSymbolApplier
extends MsSymbolApplier {
    private AbstractLabelMsSymbol symbol;

    public LabelSymbolApplier(PdbApplicator applicator, SymbolGroup.AbstractMsSymbolIterator iter) {
        super(applicator, iter);
        AbstractMsSymbol abstractSymbol = iter.next();
        if (!(abstractSymbol instanceof AbstractLabelMsSymbol)) {
            throw new AssertException("Invalid symbol type: " + abstractSymbol.getClass().getSimpleName());
        }
        this.symbol = (AbstractLabelMsSymbol)abstractSymbol;
    }

    @Override
    void apply() throws PdbException, CancelledException {
        Function f;
        if (!this.applicator.getPdbApplicatorOptions().applyInstructionLabels()) {
            return;
        }
        String name = this.symbol.getName();
        Address symbolAddress = this.applicator.getAddress(this.symbol);
        if (this.applicator.isInvalidAddress(symbolAddress, name)) {
            return;
        }
        FunctionManager functionManager = this.applicator.getProgram().getFunctionManager();
        if (name.startsWith("$") && !name.contains("::") && (f = functionManager.getFunctionContaining(symbolAddress)) != null && !f.getName().equals(name)) {
            name = NamespaceUtils.getNamespaceQualifiedName((Namespace)f, (String)name, (boolean)true);
        }
        this.applicator.createSymbol(symbolAddress, this.symbol.getName(), false);
    }

    @Override
    void applyTo(MsSymbolApplier applyToApplier) {
    }
}

