/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.pty.linux;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import jnr.posix.POSIX;
import jnr.posix.POSIXFactory;

public class FdInputStream
extends InputStream {
    private static final POSIX LIB_POSIX = POSIXFactory.getNativePOSIX();
    private final int fd;
    private boolean closed = false;

    FdInputStream(int fd) {
        this.fd = fd;
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        byte[] buf = new byte[1];
        if (0 == this.read(buf)) {
            return -1;
        }
        return buf[0] & 0xFF;
    }

    @Override
    public synchronized int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        ByteBuffer buf = ByteBuffer.wrap(b, off, len);
        int ret = LIB_POSIX.read(this.fd, buf, len);
        if (ret < 0) {
            throw new IOException(LIB_POSIX.strerror(LIB_POSIX.errno()));
        }
        return ret;
    }

    @Override
    public synchronized void close() throws IOException {
        this.closed = true;
    }
}

