/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.manager;

import agent.gdb.manager.GdbConsoleOperations;
import agent.gdb.manager.GdbConsoleOutputListener;
import agent.gdb.manager.GdbEventsListener;
import agent.gdb.manager.GdbInferior;
import agent.gdb.manager.GdbProcessThreadGroup;
import agent.gdb.manager.GdbState;
import agent.gdb.manager.GdbStateListener;
import agent.gdb.manager.GdbTable;
import agent.gdb.manager.GdbTargetOutputListener;
import agent.gdb.manager.GdbThread;
import agent.gdb.manager.breakpoint.GdbBreakpointInfo;
import agent.gdb.manager.breakpoint.GdbBreakpointInsertions;
import agent.gdb.manager.impl.GdbManagerImpl;
import agent.gdb.pty.PtyFactory;
import agent.gdb.pty.linux.LinuxPtyFactory;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public interface GdbManager
extends AutoCloseable,
GdbConsoleOperations,
GdbBreakpointInsertions {
    public static final String DEFAULT_GDB_CMD = "/usr/bin/gdb";

    public static void main(String[] args) throws InterruptedException, ExecutionException, IOException {
        try (GdbManager mgr = GdbManager.newInstance(new LinuxPtyFactory());){
            mgr.start(DEFAULT_GDB_CMD, args);
            mgr.runRC().get();
            mgr.consoleLoop();
        }
    }

    public static GdbManager newInstance(PtyFactory ptyFactory) {
        return new GdbManagerImpl(ptyFactory);
    }

    public void setNewLine(String var1);

    default public void setUnixNewLine() {
        this.setNewLine("\n");
    }

    default public void setDosNewLine() {
        this.setNewLine("\r\n");
    }

    default public void start() throws IOException {
        this.start(DEFAULT_GDB_CMD, new String[0]);
    }

    public void start(String var1, String ... var2) throws IOException;

    public CompletableFuture<Void> runRC();

    @Override
    default public void close() {
        this.terminate();
    }

    public void consoleLoop() throws IOException;

    public void terminate();

    public boolean isAlive();

    public void addStateListener(GdbStateListener var1);

    public void removeStateListener(GdbStateListener var1);

    public void addEventsListener(GdbEventsListener var1);

    public void removeEventsListener(GdbEventsListener var1);

    public void addTargetOutputListener(GdbTargetOutputListener var1);

    public void removeTargetOutputListener(GdbTargetOutputListener var1);

    public void addConsoleOutputListener(GdbConsoleOutputListener var1);

    public void removeConsoleOutputListener(GdbConsoleOutputListener var1);

    public GdbThread getThread(int var1);

    public GdbInferior getInferior(int var1);

    public GdbInferior currentInferior();

    public Map<Integer, GdbInferior> getKnownInferiors();

    public Map<Integer, GdbThread> getKnownThreads();

    public Map<Long, GdbBreakpointInfo> getKnownBreakpoints();

    public void sendInterruptNow() throws IOException;

    public void cancelCurrentCommand();

    public GdbState getState();

    public CompletableFuture<Void> waitForState(GdbState var1);

    public CompletableFuture<Void> waitForPrompt();

    @Deprecated
    public CompletableFuture<Void> claimStopped();

    public CompletableFuture<GdbInferior> addInferior();

    public CompletableFuture<GdbInferior> availableInferior();

    public CompletableFuture<Void> removeInferior(GdbInferior var1);

    public CompletableFuture<Void> interrupt();

    public CompletableFuture<Map<Integer, GdbInferior>> listInferiors();

    public CompletableFuture<Map<Long, GdbBreakpointInfo>> listBreakpoints();

    public CompletableFuture<Void> disableBreakpoints(long ... var1);

    public CompletableFuture<Void> enableBreakpoints(long ... var1);

    public CompletableFuture<Void> deleteBreakpoints(long ... var1);

    public CompletableFuture<List<GdbProcessThreadGroup>> listAvailableProcesses();

    public CompletableFuture<GdbTable> infoOs(String var1);

    public String getMi2PtyName() throws IOException;

    public String getPtyDescription();

    public static enum Channel {
        STDOUT,
        STDERR;

    }

    public static enum StepCmd {
        FINISH("finish"),
        NEXT("next"),
        NEXTI("nexti", "next-instruction"),
        RETURN("return"),
        STEP("step"),
        STEPI("stepi", "step-instruction"),
        UNTIL("until"),
        EXTENDED("echo extended-step?", "???");

        public final String mi2;
        public final String cli;

        private StepCmd(String cli, String execSuffix) {
            this.cli = cli;
            this.mi2 = "-exec-" + execSuffix;
        }

        private StepCmd(String cli) {
            this(cli, cli);
        }

        public String toString() {
            return this.mi2;
        }
    }
}

