/*
 * Decompiled with CFR 0.152.
 */
package ghidra.generic.util.datastruct;

import ghidra.generic.util.datastruct.RestrictedValueSortedMap;
import ghidra.generic.util.datastruct.SortedList;
import ghidra.generic.util.datastruct.ValueSortedMap;
import ghidra.util.ReversedListIterator;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.commons.collections4.comparators.ComparableComparator;

public class TreeValueSortedMap<K, V>
extends AbstractMap<K, V>
implements ValueSortedMap<K, V> {
    protected final Comparator<V> comparator;
    protected final Map<K, Node> nodeMap = new HashMap<K, Node>();
    private final transient ValueSortedTreeMapEntrySet entrySet = this.createEntrySet();
    private final transient ValueSortedTreeMapKeySet keySet = this.createKeySet();
    private final transient ValueSortedTreeMapValues values = this.createValues();
    protected Node root;
    protected Node head;
    protected Node tail;

    public static <K, V extends Comparable<V>> TreeValueSortedMap<K, V> createWithNaturalOrder() {
        Comparator natural = Comparator.naturalOrder();
        return new TreeValueSortedMap(natural);
    }

    public static <K, V> TreeValueSortedMap<K, V> createWithComparator(Comparator<V> comparator) {
        return new TreeValueSortedMap<K, V>(comparator);
    }

    protected TreeValueSortedMap() {
        this((Comparator<V>)new ComparableComparator());
    }

    protected TreeValueSortedMap(Comparator<V> comparator) {
        this.comparator = comparator;
    }

    protected ValueSortedTreeMapEntrySet createEntrySet() {
        return new ValueSortedTreeMapEntrySet();
    }

    protected ValueSortedTreeMapKeySet createKeySet() {
        return new ValueSortedTreeMapKeySet();
    }

    protected ValueSortedTreeMapValues createValues() {
        return new ValueSortedTreeMapValues();
    }

    protected Node createNode(K key, V value) {
        return new Node(key, value);
    }

    protected Node searchValue(V value, SearchMode mode) {
        if (this.root == null) {
            return null;
        }
        return this.root.searchValue(value, mode);
    }

    @Override
    public void clear() {
        this.nodeMap.clear();
        this.head = null;
        this.tail = null;
        this.root = null;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.nodeMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        try {
            Object val = value;
            return this.searchValue(val, SearchMode.ANY) != null;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public ValueSortedTreeMapEntrySet entrySet() {
        return this.entrySet;
    }

    @Override
    public V get(Object key) {
        Node n = this.nodeMap.get(key);
        if (n == null) {
            return null;
        }
        return n.val;
    }

    @Override
    public Map.Entry<K, V> lowerEntryByValue(V value) {
        return this.searchValue(value, SearchMode.LOWER);
    }

    @Override
    public Map.Entry<K, V> floorEntryByValue(V value) {
        return this.searchValue(value, SearchMode.FLOOR);
    }

    @Override
    public Map.Entry<K, V> ceilingEntryByValue(V value) {
        return this.searchValue(value, SearchMode.CEILING);
    }

    @Override
    public Map.Entry<K, V> higherEntryByValue(V value) {
        return this.searchValue(value, SearchMode.HIGHER);
    }

    @Override
    public boolean isEmpty() {
        return this.root == null;
    }

    private boolean isOrdered(Node n) {
        if (n.prev != null && this.comparator.compare(n.prev.val, n.val) > 0) {
            return false;
        }
        return n.next == null || this.comparator.compare(n.next.val, n.val) >= 0;
    }

    @Override
    public ValueSortedTreeMapKeySet keySet() {
        return this.keySet;
    }

    @Override
    public V put(K key, V value) {
        Node n = this.nodeMap.get(key);
        if (n != null) {
            return n.setValue(value);
        }
        n = this.createNode(key, value);
        this.nodeMap.put(key, n);
        if (this.root == null) {
            this.root = n;
            this.head = n;
            this.tail = n;
        } else {
            this.root.insert(n);
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> ent : m.entrySet()) {
            this.put(ent.getKey(), ent.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        Node n = this.nodeMap.remove(key);
        if (n == null) {
            return null;
        }
        n.remove();
        return n.val;
    }

    @Override
    public int size() {
        return this.nodeMap.size();
    }

    @Override
    public boolean update(K key) {
        Node n = this.nodeMap.get(key);
        if (n == null) {
            throw new NoSuchElementException();
        }
        return this.updateNode(n);
    }

    private boolean updateNode(Node n) {
        if (this.isOrdered(n)) {
            return false;
        }
        n.remove();
        this.root.insert(n);
        return true;
    }

    @Override
    public ValueSortedTreeMapValues values() {
        return this.values;
    }

    @Override
    public ValueSortedMap<K, V> subMapByValue(V fromValue, boolean fromInclusive, V toValue, boolean toInclusive) {
        return new RestrictedValueSortedMap(this, this.comparator, true, fromValue, fromInclusive, true, toValue, toInclusive);
    }

    @Override
    public ValueSortedMap<K, V> headMapByValue(V toValue, boolean inclusive) {
        return new RestrictedValueSortedMap(this, (Comparator<Object>)this.comparator, false, null, false, true, toValue, inclusive);
    }

    @Override
    public ValueSortedMap<K, V> tailMapByValue(V fromValue, boolean inclusive) {
        return new RestrictedValueSortedMap(this, (Comparator<Object>)this.comparator, true, fromValue, inclusive, false, null, false);
    }

    protected class ValueSortedTreeMapValues
    extends AbstractCollection<V>
    implements SortedList<V>,
    Deque<V> {
        private ValueSortedTreeMapValues() {
        }

        @Override
        public void add(int index, V element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(V e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends V> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends V> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addFirst(V e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addLast(V e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            TreeValueSortedMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Object val = o;
                return TreeValueSortedMap.this.root.searchValue(val, SearchMode.ANY) != null;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public Iterator<V> descendingIterator() {
            return new ReversedListIterator(new ValueListIterator(TreeValueSortedMap.this.tail.next));
        }

        @Override
        public V element() {
            return this.getFirst();
        }

        @Override
        public V get(int index) {
            return TreeValueSortedMap.this.entrySet.get(index).getValue();
        }

        @Override
        public V getFirst() {
            return TreeValueSortedMap.this.entrySet.getFirst().getValue();
        }

        @Override
        public V getLast() {
            return TreeValueSortedMap.this.entrySet.getLast().getValue();
        }

        @Override
        public int indexOf(Object o) {
            try {
                Object val = o;
                Node n = TreeValueSortedMap.this.searchValue(val, SearchMode.FIRST);
                if (n == null) {
                    return -1;
                }
                return n.computeIndex();
            }
            catch (ClassCastException e) {
                return -1;
            }
        }

        @Override
        public int lowerIndex(V element) {
            if (TreeValueSortedMap.this.root == null) {
                return -1;
            }
            Node n = TreeValueSortedMap.this.searchValue(element, SearchMode.LOWER);
            if (n == null) {
                return -1;
            }
            return n.computeIndex();
        }

        @Override
        public int floorIndex(V element) {
            Node n = TreeValueSortedMap.this.searchValue(element, SearchMode.FLOOR);
            if (n == null) {
                return -1;
            }
            return n.computeIndex();
        }

        @Override
        public int ceilingIndex(V element) {
            Node n = TreeValueSortedMap.this.searchValue(element, SearchMode.CEILING);
            if (n == null) {
                return -1;
            }
            return n.computeIndex();
        }

        @Override
        public int higherIndex(V element) {
            Node n = TreeValueSortedMap.this.searchValue(element, SearchMode.HIGHER);
            if (n == null) {
                return -1;
            }
            return n.computeIndex();
        }

        @Override
        public boolean isEmpty() {
            return TreeValueSortedMap.this.root == null;
        }

        @Override
        public Iterator<V> iterator() {
            return this.listIterator();
        }

        @Override
        public int lastIndexOf(Object o) {
            try {
                Object val = o;
                Node n = TreeValueSortedMap.this.root.searchValue(val, SearchMode.LAST);
                if (n == null) {
                    return -1;
                }
                return n.computeIndex();
            }
            catch (ClassCastException e) {
                return -1;
            }
        }

        @Override
        public ListIterator<V> listIterator() {
            return new ValueListIterator(TreeValueSortedMap.this.head);
        }

        @Override
        public ListIterator<V> listIterator(int index) {
            return new ValueListIterator(TreeValueSortedMap.this.root.getByIndex(index));
        }

        @Override
        public boolean offer(V e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean offerFirst(V e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean offerLast(V e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V peek() {
            return this.peekFirst();
        }

        @Override
        public V peekFirst() {
            Object n = TreeValueSortedMap.this.entrySet.peekFirst();
            if (n == null) {
                return null;
            }
            return n.getValue();
        }

        @Override
        public V peekLast() {
            Object n = TreeValueSortedMap.this.entrySet.peekLast();
            if (n == null) {
                return null;
            }
            return n.getValue();
        }

        @Override
        public V poll() {
            return this.pollFirst();
        }

        @Override
        public V pollFirst() {
            Object n = TreeValueSortedMap.this.entrySet.pollFirst();
            if (n == null) {
                return null;
            }
            return n.getValue();
        }

        @Override
        public V pollLast() {
            Object n = TreeValueSortedMap.this.entrySet.pollLast();
            if (n == null) {
                return null;
            }
            return n.getValue();
        }

        @Override
        public V pop() {
            return this.removeFirst();
        }

        @Override
        public void push(V e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V remove() {
            return this.removeFirst();
        }

        @Override
        public V remove(int index) {
            return TreeValueSortedMap.this.entrySet.remove(index).getValue();
        }

        @Override
        public boolean remove(Object o) {
            return this.removeFirstOccurrence(o);
        }

        @Override
        public V removeFirst() {
            return TreeValueSortedMap.this.entrySet.removeFirst().getValue();
        }

        @Override
        public boolean removeFirstOccurrence(Object o) {
            try {
                Object val = o;
                Node n = TreeValueSortedMap.this.root.searchValue(val, SearchMode.FIRST);
                if (n == null) {
                    return false;
                }
                n.remove();
                TreeValueSortedMap.this.nodeMap.remove(n.key);
                return true;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public V removeLast() {
            return TreeValueSortedMap.this.entrySet.removeLast().getValue();
        }

        @Override
        public boolean removeLastOccurrence(Object o) {
            try {
                Object val = o;
                Node n = TreeValueSortedMap.this.root.searchValue(val, SearchMode.LAST);
                if (n == null) {
                    return false;
                }
                n.remove();
                TreeValueSortedMap.this.nodeMap.remove(n.key);
                return true;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public V set(int index, V element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return TreeValueSortedMap.this.nodeMap.size();
        }

        @Override
        public List<V> subList(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException();
        }
    }

    protected class ValueSortedTreeMapKeySet
    extends AbstractSet<K>
    implements ValueSortedMap.ValueSortedMapKeyList<K> {
        private ValueSortedTreeMapKeySet() {
        }

        @Override
        public void add(int index, K element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(K e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends K> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends K> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addFirst(K e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addLast(K e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            TreeValueSortedMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            return TreeValueSortedMap.this.nodeMap.containsKey(o);
        }

        @Override
        public Iterator<K> descendingIterator() {
            return new ReversedListIterator(new KeyListIterator(TreeValueSortedMap.this.tail.next));
        }

        @Override
        public K element() {
            return this.getFirst();
        }

        @Override
        public K get(int index) {
            return TreeValueSortedMap.this.entrySet.get(index).getKey();
        }

        @Override
        public K getFirst() {
            return TreeValueSortedMap.this.entrySet.getFirst().getKey();
        }

        @Override
        public K getLast() {
            return TreeValueSortedMap.this.entrySet.getLast().getKey();
        }

        @Override
        public int indexOf(Object o) {
            Node n = TreeValueSortedMap.this.nodeMap.get(o);
            if (n == null) {
                return -1;
            }
            return n.computeIndex();
        }

        @Override
        public boolean isEmpty() {
            return TreeValueSortedMap.this.root == null;
        }

        @Override
        public Iterator<K> iterator() {
            return this.listIterator();
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.indexOf(o);
        }

        @Override
        public ListIterator<K> listIterator() {
            return new KeyListIterator(TreeValueSortedMap.this.head);
        }

        @Override
        public ListIterator<K> listIterator(int index) {
            return new KeyListIterator(TreeValueSortedMap.this.root.getByIndex(index));
        }

        @Override
        public boolean offer(K e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean offerFirst(K e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean offerLast(K e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public K peek() {
            return this.peekFirst();
        }

        @Override
        public K peekFirst() {
            Object n = TreeValueSortedMap.this.entrySet.peekFirst();
            if (n == null) {
                return null;
            }
            return n.getKey();
        }

        @Override
        public K peekLast() {
            Object n = TreeValueSortedMap.this.entrySet.peekLast();
            if (n == null) {
                return null;
            }
            return n.getKey();
        }

        @Override
        public K poll() {
            return this.pollFirst();
        }

        @Override
        public K pollFirst() {
            Object n = TreeValueSortedMap.this.entrySet.pollFirst();
            if (n == null) {
                return null;
            }
            return n.getKey();
        }

        @Override
        public K pollLast() {
            Object n = TreeValueSortedMap.this.entrySet.pollLast();
            if (n == null) {
                return null;
            }
            return n.getKey();
        }

        @Override
        public K pop() {
            return this.removeFirst();
        }

        @Override
        public void push(K e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public K remove() {
            return this.removeFirst();
        }

        @Override
        public K remove(int index) {
            return TreeValueSortedMap.this.entrySet.remove(index).getKey();
        }

        @Override
        public boolean remove(Object o) {
            return TreeValueSortedMap.this.remove(o) != null;
        }

        @Override
        public K removeFirst() {
            return TreeValueSortedMap.this.entrySet.removeFirst().getKey();
        }

        @Override
        public boolean removeFirstOccurrence(Object o) {
            return TreeValueSortedMap.this.remove(o) != null;
        }

        @Override
        public K removeLast() {
            return TreeValueSortedMap.this.entrySet.removeLast().getKey();
        }

        @Override
        public boolean removeLastOccurrence(Object o) {
            return TreeValueSortedMap.this.remove(o) != null;
        }

        @Override
        public K set(int index, K element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return TreeValueSortedMap.this.nodeMap.size();
        }

        @Override
        public List<K> subList(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException();
        }
    }

    protected class ValueSortedTreeMapEntrySet
    extends AbstractSet<Map.Entry<K, V>>
    implements ValueSortedMap.ValueSortedMapEntryList<K, V> {
        private ValueSortedTreeMapEntrySet() {
        }

        @Override
        public boolean add(Map.Entry<K, V> e) {
            return TreeValueSortedMap.this.put(e.getKey(), e.getValue()) == null;
        }

        @Override
        public void add(int index, Map.Entry<K, V> element) {
            this.add(element);
        }

        @Override
        public boolean addAll(int index, Collection<? extends Map.Entry<K, V>> c) {
            return this.addAll(c);
        }

        @Override
        public void addFirst(Map.Entry<K, V> e) {
            TreeValueSortedMap.this.put(e.getKey(), e.getValue());
        }

        @Override
        public void addLast(Map.Entry<K, V> e) {
            TreeValueSortedMap.this.put(e.getKey(), e.getValue());
        }

        @Override
        public void clear() {
            TreeValueSortedMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            if (o == null) {
                return false;
            }
            try {
                Node n = (Node)o;
                Node m = TreeValueSortedMap.this.nodeMap.get(n.key);
                return Objects.equals(n.val, m.val);
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public Iterator<Map.Entry<K, V>> descendingIterator() {
            return new ReversedListIterator(new EntryListIterator(TreeValueSortedMap.this.tail.next));
        }

        @Override
        public Map.Entry<K, V> element() {
            return this.getFirst();
        }

        @Override
        public Map.Entry<K, V> get(int index) {
            return TreeValueSortedMap.this.root.getByIndex(index);
        }

        @Override
        public Map.Entry<K, V> getFirst() {
            Object ret = this.peekFirst();
            if (ret == null) {
                throw new NoSuchElementException();
            }
            return ret;
        }

        @Override
        public Map.Entry<K, V> getLast() {
            Object ret = this.peekLast();
            if (ret == null) {
                throw new NoSuchElementException();
            }
            return ret;
        }

        @Override
        public int indexOf(Object o) {
            if (o == null) {
                return -1;
            }
            try {
                Node n = (Node)o;
                return n.computeIndex();
            }
            catch (ClassCastException e) {
                return -1;
            }
        }

        @Override
        public boolean isEmpty() {
            return TreeValueSortedMap.this.root == null;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return this.listIterator();
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.indexOf(o);
        }

        @Override
        public ListIterator<Map.Entry<K, V>> listIterator() {
            return new EntryListIterator(TreeValueSortedMap.this.head);
        }

        @Override
        public ListIterator<Map.Entry<K, V>> listIterator(int index) {
            if (TreeValueSortedMap.this.root == null) {
                return Collections.emptyListIterator();
            }
            return new EntryListIterator(TreeValueSortedMap.this.root.getByIndex(index));
        }

        @Override
        public boolean offer(Map.Entry<K, V> e) {
            return TreeValueSortedMap.this.put(e.getKey(), e.getValue()) == null;
        }

        @Override
        public boolean offerFirst(Map.Entry<K, V> e) {
            return TreeValueSortedMap.this.put(e.getKey(), e.getValue()) == null;
        }

        @Override
        public boolean offerLast(Map.Entry<K, V> e) {
            return TreeValueSortedMap.this.put(e.getKey(), e.getValue()) == null;
        }

        @Override
        public Map.Entry<K, V> peek() {
            return this.peekFirst();
        }

        @Override
        public Map.Entry<K, V> peekFirst() {
            return TreeValueSortedMap.this.head;
        }

        @Override
        public Map.Entry<K, V> peekLast() {
            return TreeValueSortedMap.this.tail;
        }

        @Override
        public Map.Entry<K, V> poll() {
            return this.pollFirst();
        }

        @Override
        public Map.Entry<K, V> pollFirst() {
            if (TreeValueSortedMap.this.head == null) {
                return null;
            }
            Node result = TreeValueSortedMap.this.head;
            TreeValueSortedMap.this.head.remove();
            TreeValueSortedMap.this.nodeMap.remove(result.key);
            return result;
        }

        @Override
        public Map.Entry<K, V> pollLast() {
            if (TreeValueSortedMap.this.tail == null) {
                return TreeValueSortedMap.this.tail;
            }
            Node result = TreeValueSortedMap.this.tail;
            TreeValueSortedMap.this.tail.remove();
            TreeValueSortedMap.this.nodeMap.remove(result.key);
            return result;
        }

        @Override
        public Map.Entry<K, V> pop() {
            return this.removeFirst();
        }

        @Override
        public void push(Map.Entry<K, V> e) {
            TreeValueSortedMap.this.put(e.getKey(), e.getValue());
        }

        @Override
        public Map.Entry<K, V> remove() {
            return this.removeFirst();
        }

        @Override
        public Map.Entry<K, V> remove(int index) {
            Node n = TreeValueSortedMap.this.root.getByIndex(index);
            n.remove();
            TreeValueSortedMap.this.nodeMap.remove(n.key);
            return n;
        }

        @Override
        public boolean remove(Object o) {
            try {
                Node n = (Node)o;
                Node rm = TreeValueSortedMap.this.nodeMap.get(n.key);
                if (rm == n) {
                    n.remove();
                    TreeValueSortedMap.this.nodeMap.remove(n.key);
                    return true;
                }
                if (Objects.equals(n.val, rm.val)) {
                    TreeValueSortedMap.this.nodeMap.remove(rm.key);
                    rm.remove();
                    return true;
                }
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public Map.Entry<K, V> removeFirst() {
            Object ret = this.pollFirst();
            if (ret == null) {
                throw new NoSuchElementException();
            }
            return ret;
        }

        @Override
        public boolean removeFirstOccurrence(Object o) {
            return this.remove(o);
        }

        @Override
        public Map.Entry<K, V> removeLast() {
            Object ret = this.pollLast();
            if (ret == null) {
                throw new NoSuchElementException();
            }
            return ret;
        }

        @Override
        public boolean removeLastOccurrence(Object o) {
            return this.remove(o);
        }

        @Override
        public Map.Entry<K, V> set(int index, Map.Entry<K, V> element) {
            Object result = this.remove(index);
            this.add(element);
            return result;
        }

        @Override
        public int size() {
            return TreeValueSortedMap.this.nodeMap.size();
        }

        @Override
        public List<Map.Entry<K, V>> subList(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException();
        }
    }

    protected class ValueListIterator
    implements ListIterator<V> {
        private EntryListIterator it;

        private ValueListIterator(Node start) {
            this.it = new EntryListIterator(start);
        }

        @Override
        public void add(V e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.it.hasPrevious();
        }

        @Override
        public V next() {
            return this.it.next().val;
        }

        @Override
        public int nextIndex() {
            return this.it.nextIndex();
        }

        @Override
        public V previous() {
            return this.it.previous().val;
        }

        @Override
        public int previousIndex() {
            return this.it.previousIndex();
        }

        @Override
        public void remove() {
            this.it.remove();
        }

        @Override
        public void set(V e) {
            throw new UnsupportedOperationException();
        }
    }

    private static enum SearchMode {
        ANY(BoundType.CLOSED, Comp.NONE, Comp.NONE),
        FIRST(BoundType.CLOSED, Comp.LT, Comp.NONE),
        LAST(BoundType.CLOSED, Comp.GT, Comp.NONE),
        LOWER(BoundType.OPEN, Comp.NONE, Comp.LT),
        FLOOR(BoundType.CLOSED, Comp.LT, Comp.LT),
        CEILING(BoundType.CLOSED, Comp.GT, Comp.GT),
        HIGHER(BoundType.OPEN, Comp.NONE, Comp.GT);

        final BoundType allowEq;
        final Comp inEq;
        final Comp comp;

        private SearchMode(BoundType allowEq, Comp inEq, Comp comp) {
            this.allowEq = allowEq;
            this.inEq = inEq;
            this.comp = comp;
        }
    }

    private static enum Comp {
        NONE,
        LT,
        GT;

    }

    private static enum BoundType {
        CLOSED,
        OPEN;

    }

    protected class Node
    implements Map.Entry<K, V> {
        protected final K key;
        protected V val;
        protected Node parent;
        protected Node lChild;
        protected Node rChild;
        protected int sizeLeft;
        protected Node next;
        protected Node prev;

        public String toString() {
            return this.key + "=" + this.val;
        }

        protected Node(K key, V val) {
            this.key = key;
            this.val = val;
        }

        @Override
        public boolean equals(Object obj) {
            try {
                Map.Entry that = (Map.Entry)obj;
                return Objects.equals(this.key, that.getKey()) && Objects.equals(this.val, that.getValue());
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.key, this.val);
        }

        public int computeIndex() {
            Node cur = this;
            int index = this.sizeLeft;
            while (cur.parent != null) {
                if (cur.parent.rChild == cur) {
                    ++index;
                    index += cur.parent.sizeLeft;
                }
                cur = cur.parent;
            }
            return index;
        }

        private Node getByIndex(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException(Integer.toString(index));
            }
            Node cur = this;
            int i = index;
            while (true) {
                if (i < 0) {
                    throw new AssertionError((Object)"INTERNAL: sizeLeft values inconsistent");
                }
                if (cur == null) {
                    throw new IndexOutOfBoundsException(Integer.toString(index));
                }
                if (i == cur.sizeLeft) {
                    return cur;
                }
                if (i > cur.sizeLeft) {
                    i -= cur.sizeLeft;
                    --i;
                    cur = cur.rChild;
                    continue;
                }
                cur = cur.lChild;
            }
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.val;
        }

        void insert(Node item) {
            Node cur = this;
            while (true) {
                int c;
                if ((c = TreeValueSortedMap.this.comparator.compare(item.val, cur.val)) < 0) {
                    ++cur.sizeLeft;
                    if (cur.lChild == null) {
                        cur.lChild = item;
                        item.parent = cur;
                        cur.insertBefore(item);
                        break;
                    }
                    cur = cur.lChild;
                    continue;
                }
                if (cur.rChild == null) {
                    cur.rChild = item;
                    item.parent = cur;
                    cur.insertAfter(item);
                    break;
                }
                cur = cur.rChild;
            }
        }

        private void insertAfter(Node item) {
            item.prev = this;
            item.next = this.next;
            if (this.next == null) {
                TreeValueSortedMap.this.tail = item;
            } else {
                this.next.prev = item;
            }
            this.next = item;
        }

        private void insertBefore(Node item) {
            item.prev = this.prev;
            item.next = this;
            if (this.prev == null) {
                TreeValueSortedMap.this.head = item;
            } else {
                this.prev.next = item;
            }
            this.prev = item;
        }

        private void remove() {
            Node cur = this;
            while (cur.parent != null) {
                if (cur.parent.lChild == cur) {
                    --cur.parent.sizeLeft;
                }
                cur = cur.parent;
            }
            if (this.parent == null) {
                if (this.lChild != null) {
                    TreeValueSortedMap.this.root = this.lChild;
                    this.lChild.parent = null;
                } else if (this.rChild != null) {
                    TreeValueSortedMap.this.root = this.rChild;
                    this.rChild.parent = null;
                } else {
                    TreeValueSortedMap.this.root = null;
                }
            } else if (this.parent.lChild == this) {
                if (this.lChild != null) {
                    this.parent.lChild = this.lChild;
                    this.lChild.parent = this.parent;
                } else if (this.rChild != null) {
                    this.parent.lChild = this.rChild;
                    this.rChild.parent = this.parent;
                } else {
                    this.parent.lChild = null;
                }
            } else if (this.lChild != null) {
                this.parent.rChild = this.lChild;
                this.lChild.parent = this.parent;
            } else if (this.rChild != null) {
                this.parent.rChild = this.rChild;
                this.rChild.parent = this.parent;
            } else {
                this.parent.rChild = null;
            }
            if (this.lChild != null && this.rChild != null) {
                this.prev.rChild = this.rChild;
                this.rChild.parent = this.prev;
            }
            this.lChild = null;
            this.rChild = null;
            this.sizeLeft = 0;
            if (this.prev == null) {
                TreeValueSortedMap.this.head = this.next;
            } else {
                this.prev.next = this.next;
            }
            if (this.next == null) {
                TreeValueSortedMap.this.tail = this.prev;
            } else {
                this.next.prev = this.prev;
            }
        }

        private Node searchValue(V value, SearchMode mode) {
            int c;
            Node cur = this;
            Node eq = null;
            while (true) {
                if ((c = TreeValueSortedMap.this.comparator.compare(value, cur.val)) == 0) {
                    eq = cur;
                }
                if (c < 0 || c == 0 && mode.inEq == Comp.LT) {
                    if (cur.lChild == null) break;
                    cur = cur.lChild;
                    continue;
                }
                if (c <= 0 && (c != 0 || mode.inEq != Comp.GT) || cur.rChild == null) break;
                cur = cur.rChild;
            }
            if (eq != null) {
                if (mode.allowEq == BoundType.CLOSED) {
                    return eq;
                }
                if (mode.comp == Comp.LT) {
                    return eq.prev;
                }
                return eq.next;
            }
            if (mode.comp == Comp.LT) {
                if (c < 0) {
                    return cur.prev;
                }
                return cur;
            }
            if (mode.comp == Comp.GT) {
                if (c < 0) {
                    return cur;
                }
                return cur.next;
            }
            return null;
        }

        @Override
        public V setValue(V value) {
            Object oldVal = this.val;
            this.val = value;
            TreeValueSortedMap.this.updateNode(this);
            return oldVal;
        }
    }

    protected class KeyListIterator
    implements ListIterator<K> {
        private EntryListIterator it;

        private KeyListIterator(Node start) {
            this.it = new EntryListIterator(start);
        }

        @Override
        public void add(K e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.it.hasPrevious();
        }

        @Override
        public K next() {
            return this.it.next().key;
        }

        @Override
        public int nextIndex() {
            return this.it.nextIndex();
        }

        @Override
        public K previous() {
            return this.it.previous().key;
        }

        @Override
        public int previousIndex() {
            return this.it.previousIndex();
        }

        @Override
        public void remove() {
            this.it.remove();
        }

        @Override
        public void set(K e) {
            throw new UnsupportedOperationException();
        }
    }

    protected class EntryListIterator
    implements ListIterator<Map.Entry<K, V>> {
        private boolean atEnd = false;
        private Node next;
        private Node cur;

        private EntryListIterator(Node start) {
            this.next = start;
            this.atEnd = start == null;
        }

        @Override
        public void add(Map.Entry<K, V> e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return !this.atEnd;
        }

        @Override
        public boolean hasPrevious() {
            if (this.atEnd) {
                return true;
            }
            return this.next.prev != null;
        }

        @Override
        public Node next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.cur = this.next;
            this.next = this.next.next;
            this.atEnd = this.next == null;
            return this.cur;
        }

        @Override
        public int nextIndex() {
            return this.next.computeIndex();
        }

        @Override
        public Node previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            if (this.atEnd) {
                this.next = TreeValueSortedMap.this.tail;
                this.atEnd = TreeValueSortedMap.this.tail == null;
            } else {
                this.cur = this.next = this.next.prev;
            }
            return this.cur;
        }

        @Override
        public int previousIndex() {
            if (this.atEnd) {
                return TreeValueSortedMap.this.size() - 1;
            }
            return this.next.computeIndex() - 1;
        }

        @Override
        public void remove() {
            if (this.cur == null) {
                throw new IllegalStateException();
            }
            TreeValueSortedMap.this.nodeMap.remove(this.cur.key);
            this.cur.remove();
            this.cur = null;
        }

        @Override
        public void set(Map.Entry<K, V> e) {
            throw new UnsupportedOperationException();
        }
    }
}

