/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database.spatial;

import com.google.common.collect.Collections2;
import ghidra.util.database.DBCachedObjectStoreFactory;
import ghidra.util.database.spatial.AbstractConstraintsTree;
import ghidra.util.database.spatial.BoundedShape;
import ghidra.util.database.spatial.BoundingShape;
import ghidra.util.database.spatial.DBTreeDataRecord;
import ghidra.util.database.spatial.DBTreeNodeRecord;
import ghidra.util.database.spatial.DBTreeRecord;
import ghidra.util.database.spatial.Query;
import ghidra.util.exception.VersionException;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;

public abstract class AbstractRStarConstraintsTree<DS extends BoundedShape<NS>, DR extends DBTreeDataRecord<DS, NS, T>, NS extends BoundingShape<NS>, NR extends DBTreeNodeRecord<NS>, T, Q extends Query<DS, NS>>
extends AbstractConstraintsTree<DS, DR, NS, NR, T, Q> {
    protected static final int MAX_LEVELS = 64;
    protected static final double FILL_RATE = 0.4;
    protected static final double REINSERT_RATE = 0.3;
    protected static final int CHEAT_OVERLAP_COUNT = 32;
    protected final int maxChildren;
    protected final int minChildren;
    protected final int reinsertCount;

    public AbstractRStarConstraintsTree(DBCachedObjectStoreFactory storeFactory, String tableName, Class<DR> dataType, Class<NR> nodeType, boolean upgradable, int maxChildren) throws VersionException, IOException {
        super(storeFactory, tableName, dataType, nodeType, upgradable);
        this.maxChildren = maxChildren;
        this.minChildren = (int)(0.4 * (double)maxChildren);
        this.reinsertCount = (int)((double)(maxChildren + 1) * 0.3);
    }

    protected abstract List<Comparator<NS>> getSplitAxes();

    protected NR doChooseSubtree(int dstLevel, NS bounds) {
        DBTreeNodeRecord node = this.root;
        for (int i = 0; i < dstLevel; ++i) {
            assert (!node.getType().isLeaf());
            if (node.getType().isLeafParent()) {
                node = this.findChildByNearlyMinimumOverlapCost(node, bounds);
                continue;
            }
            assert (node.getType().isDirectory());
            node = this.findChildByMinimumEnlargementCost(node, bounds);
        }
        return (NR)((Object)node);
    }

    protected NR findChildByMinimumEnlargementCost(NR n, NS bounds) {
        assert (!((DBTreeNodeRecord)((Object)n)).getType().isLeafParent() && ((DBTreeNodeRecord)((Object)n)).getType().isDirectory());
        DBTreeNodeRecord bestChild = null;
        double bestAreaEnlargement = 0.0;
        for (DBTreeNodeRecord child : this.getNodeChildrenOf(n)) {
            double candidateAreaEnlargement = ((BoundingShape)child.getShape()).computeAreaUnionBounds(bounds) - ((BoundingShape)child.getShape()).getArea();
            if (bestChild != null && !(candidateAreaEnlargement < bestAreaEnlargement) && (candidateAreaEnlargement != bestAreaEnlargement || !(((BoundingShape)child.getShape()).getArea() < ((BoundingShape)bestChild.getShape()).getArea()))) continue;
            bestChild = child;
            bestAreaEnlargement = candidateAreaEnlargement;
        }
        assert (bestChild != null);
        return (NR)((Object)bestChild);
    }

    protected NR findChildByNearlyMinimumOverlapCost(NR n, NS bounds) {
        LeastAreaEnlargementThenLeastArea measure;
        assert (((DBTreeNodeRecord)((Object)n)).getType().isLeafParent());
        PriorityQueue<LeastAreaEnlargementThenLeastArea> sorted = new PriorityQueue<LeastAreaEnlargementThenLeastArea>(((DBTreeNodeRecord)((Object)n)).getChildCount());
        ArrayList<NR> children = new ArrayList<NR>(this.getNodeChildrenOf(n));
        for (DBTreeNodeRecord leaf : children) {
            assert (leaf.getType().isLeaf());
            sorted.offer(new LeastAreaEnlargementThenLeastArea(this, leaf, bounds));
        }
        NR bestLeaf = null;
        double bestOverlapEnlargement = 0.0;
        double bestAreaEnlargement = 0.0;
        for (int i = 0; i < 32 && (measure = (LeastAreaEnlargementThenLeastArea)sorted.poll()) != null; ++i) {
            double candidateOverlap = this.computeOverlap((BoundingShape)((DBTreeRecord)((Object)measure.node)).getShape(), children, measure.node);
            double candidateOverlapEnlargement = this.computeOverlap(((BoundingShape)((DBTreeRecord)((Object)measure.node)).getShape()).unionBounds(bounds), children, measure.node) - candidateOverlap;
            if (bestLeaf != null && !(candidateOverlapEnlargement < bestOverlapEnlargement) && (candidateOverlapEnlargement != bestOverlapEnlargement || !(measure.areaEnlargement < bestAreaEnlargement))) continue;
            bestLeaf = measure.node;
            bestOverlapEnlargement = candidateOverlapEnlargement;
            bestAreaEnlargement = measure.areaEnlargement;
        }
        assert (bestLeaf != null);
        return bestLeaf;
    }

    protected double computeOverlap(NS n, Iterable<NR> all, NR ignore) {
        double sum = 0.0;
        for (DBTreeNodeRecord r : all) {
            if (r == ignore) {
                ignore = null;
                continue;
            }
            sum += n.computeAreaIntersection((BoundingShape)((BoundingShape)r.getShape()));
        }
        assert (ignore == null);
        return sum;
    }

    protected static int sum(Iterable<Integer> terms) {
        int sum = 0;
        Iterator<Integer> iterator = terms.iterator();
        while (iterator.hasNext()) {
            long t = iterator.next().intValue();
            sum = (int)((long)sum + t);
        }
        return sum;
    }

    protected NR doSplit(NR n) {
        ArrayList children = new ArrayList(this.getChildrenOf(n));
        assert (children.size() == this.maxChildren + 1);
        Comparator<? extends NS> axis = this.doChooseSplitAxis(children);
        int index = this.doChooseSplitIndex(children, axis);
        List firstGroup = children.subList(0, index);
        List secondGroup = children.subList(index, children.size());
        NR n1 = n;
        DBTreeNodeRecord n2 = (DBTreeNodeRecord)((Object)this.nodeStore.create());
        n2.setParentKey(((DBTreeRecord)((Object)n)).getParentKey());
        this.doAddToCachedChildren(((DBTreeRecord)((Object)n)).getParentKey(), n2, this.cachedNodeChildren);
        n2.setType(((DBTreeNodeRecord)((Object)n)).getType());
        Collection firstBounds = Collections2.transform(firstGroup, DBTreeRecord::getBounds);
        ((DBTreeRecord)((Object)n1)).setShape(BoundingShape.boundsUnion(firstBounds));
        ((DBTreeNodeRecord)((Object)n1)).setChildCount(index);
        ((DBTreeNodeRecord)((Object)n1)).setDataCount(AbstractRStarConstraintsTree.sum(Collections2.transform(firstGroup, p -> p.getDataCount())));
        Collection secondBounds = Collections2.transform(secondGroup, DBTreeRecord::getBounds);
        n2.setShape(BoundingShape.boundsUnion(secondBounds));
        n2.setChildCount(this.maxChildren + 1 - index);
        n2.setDataCount(AbstractRStarConstraintsTree.sum(Collections2.transform(secondGroup, p -> p.getDataCount())));
        if (n2.getType() == DBTreeNodeRecord.NodeType.LEAF) {
            for (DBTreeRecord move : secondGroup) {
                DBTreeDataRecord dMove = (DBTreeDataRecord)move;
                this.doSetParentKey(dMove, n2.getKey(), this.cachedDataChildren);
            }
        } else {
            for (DBTreeRecord move : secondGroup) {
                DBTreeNodeRecord nMove = (DBTreeNodeRecord)move;
                this.doSetParentKey(nMove, n2.getKey(), this.cachedNodeChildren);
            }
        }
        return (NR)((Object)n2);
    }

    protected Comparator<NS> doChooseSplitAxis(List<DBTreeRecord<?, ? extends NS>> children) {
        Comparator<NS> bestAxis = null;
        double bestMarginValue = Double.MAX_VALUE;
        for (Comparator<NS> axis : this.getSplitAxes()) {
            children.sort(Comparator.comparing(DBTreeRecord::getBounds, axis));
            Collection firstKBounds = Collections2.transform(children.subList(0, this.minChildren), DBTreeRecord::getBounds);
            Object boundsFirstKChildren = BoundingShape.boundsUnion(firstKBounds);
            Collection lastKBounds = Collections2.transform(children.subList(this.maxChildren + 1 - this.minChildren, this.maxChildren + 1), DBTreeRecord::getBounds);
            Object bounsaLastKChildren = BoundingShape.boundsUnion(lastKBounds);
            int maxK = this.maxChildren + 1 - this.minChildren * 2;
            double marginValue = 0.0;
            marginValue += boundsFirstKChildren.getMargin();
            marginValue += bounsaLastKChildren.getMargin();
            for (int k = 0; k <= maxK; ++k) {
                NS forFirst = children.get(this.minChildren + k).getBounds();
                NS forSecond = children.get(this.maxChildren - this.minChildren - k).getBounds();
                boundsFirstKChildren = boundsFirstKChildren.unionBounds(forFirst);
                bounsaLastKChildren = bounsaLastKChildren.unionBounds(forSecond);
                marginValue += boundsFirstKChildren.getMargin();
                marginValue += bounsaLastKChildren.getMargin();
            }
            if (bestAxis != null && !(marginValue < bestMarginValue)) continue;
            bestAxis = axis;
            bestMarginValue = marginValue;
        }
        assert (bestAxis != null);
        return bestAxis;
    }

    protected int doChooseSplitIndex(List<DBTreeRecord<?, ? extends NS>> children, Comparator<NS> axis) {
        children.sort(Comparator.comparing(DBTreeRecord::getBounds, axis));
        Collection firstBounds = Collections2.transform(children.subList(0, this.minChildren), DBTreeRecord::getBounds);
        Object boundsFirstKChildren = BoundingShape.boundsUnion(firstBounds);
        Collection secondBounds = Collections2.transform(children.subList(this.maxChildren + 1 - this.minChildren, this.maxChildren + 1), DBTreeRecord::getBounds);
        Object boundsLastKChildren = BoundingShape.boundsUnion(secondBounds);
        int maxK = this.maxChildren + 1 - this.minChildren * 2;
        ArrayDeque<NS> boundsFirsts = new ArrayDeque<NS>();
        ArrayDeque<NS> boundsSeconds = new ArrayDeque<NS>();
        boundsFirsts.addLast(boundsFirstKChildren);
        boundsSeconds.addFirst(boundsLastKChildren);
        for (int k = 0; k <= maxK; ++k) {
            NS forFirst = children.get(this.minChildren + k).getBounds();
            NS forSecond = children.get(this.maxChildren - this.minChildren - k).getBounds();
            boundsFirstKChildren = boundsFirstKChildren.unionBounds(forFirst);
            boundsLastKChildren = boundsLastKChildren.unionBounds(forSecond);
            boundsFirsts.addLast(boundsFirstKChildren);
            boundsSeconds.addFirst(boundsLastKChildren);
        }
        double bestOverlapValue = Double.MAX_VALUE;
        double bestAreaValue = Double.MAX_VALUE;
        int bestIndex = -1;
        for (int k = 0; k <= maxK; ++k) {
            BoundingShape boundsFirstGroup = (BoundingShape)boundsFirsts.removeFirst();
            BoundingShape boundsSecondGroup = (BoundingShape)boundsSeconds.removeFirst();
            double overlapValue = boundsFirstGroup.computeAreaIntersection(boundsSecondGroup);
            double areaValue = boundsFirstGroup.getArea() + boundsSecondGroup.getArea();
            if (bestIndex != -1 && !(overlapValue < bestOverlapValue) && (overlapValue != bestOverlapValue || !(areaValue < bestAreaValue))) continue;
            bestIndex = k;
            bestOverlapValue = overlapValue;
        }
        assert (bestIndex != -1);
        return bestIndex + this.minChildren;
    }

    @Override
    protected DR doInsertData(DS shape, T value) {
        DBTreeDataRecord entry = (DBTreeDataRecord)((Object)this.dataStore.create());
        entry.setParentKey(-1L);
        entry.setShape(shape);
        entry.setRecordValue(value);
        this.doInsert(entry, new LevelInfo(this.leafLevel));
        return (DR)((Object)entry);
    }

    protected void doInsert(DBTreeRecord<?, ? extends NS> entry, LevelInfo levelInfo) {
        NR node = this.doChooseSubtree(levelInfo.dstLevel, entry.getBounds());
        if (((DBTreeNodeRecord)((Object)node)).getType() == DBTreeNodeRecord.NodeType.LEAF) {
            DBTreeDataRecord d = (DBTreeDataRecord)entry;
            this.doSetParentKey(d, node.getKey(), this.cachedDataChildren);
        } else {
            DBTreeNodeRecord n = (DBTreeNodeRecord)entry;
            this.doSetParentKey(n, node.getKey(), this.cachedNodeChildren);
        }
        NR parent = node;
        while (parent != null) {
            int newDataCount = ((DBTreeRecord)((Object)parent)).getDataCount() + entry.getDataCount();
            ((DBTreeNodeRecord)((Object)parent)).setDataCount(newDataCount);
            parent = this.getParentOf((DBTreeRecord<?, ?>)((Object)parent));
        }
        int newChildCount = ((DBTreeNodeRecord)((Object)node)).getChildCount() + 1;
        ((DBTreeNodeRecord)((Object)node)).setChildCount(newChildCount);
        if (newChildCount == 1) {
            assert (node == this.root);
            ((DBTreeRecord)((Object)node)).setShape(entry.getBounds());
        } else {
            NR parent2 = node;
            while (parent2 != null) {
                ((DBTreeRecord)((Object)parent2)).setShape(((BoundingShape)((DBTreeRecord)((Object)parent2)).getShape()).unionBounds(entry.getBounds()));
                parent2 = this.getParentOf((DBTreeRecord<?, ?>)((Object)parent2));
            }
        }
        DBTreeRecord split = null;
        if (newChildCount > this.maxChildren) {
            split = (DBTreeRecord)((Object)this.doOverflowTreatment(node, levelInfo));
        }
        int savedLevel = levelInfo.dstLevel;
        NR propa = node;
        Object parent3 = this.getParentOf((DBTreeRecord<?, ?>)((Object)propa));
        while (split != null) {
            if (parent3 == null) {
                assert (propa == this.root);
                assert (levelInfo.dstLevel == 0);
                this.root = (DBTreeNodeRecord)((Object)this.nodeStore.create());
                this.root.setParentKey(-1L);
                this.cachedNodeChildren.put(this.root.getKey(), new ArrayList(this.maxChildren));
                this.root.setShape(((BoundingShape)((DBTreeRecord)((Object)propa)).getShape()).unionBounds((BoundingShape)split.getShape()));
                this.root.setType(((DBTreeNodeRecord)((Object)propa)).getType().getParentType());
                this.root.setChildCount(2);
                this.root.setDataCount(((DBTreeRecord)((Object)propa)).getDataCount() + split.getDataCount());
                this.doSetParentKey(propa, this.root.getKey(), this.cachedNodeChildren);
                this.doSetParentKey(split, this.root.getKey(), this.cachedNodeChildren);
                ++this.leafLevel;
                levelInfo.dstLevel = savedLevel;
                levelInfo.incDepth();
                return;
            }
            newChildCount = ((DBTreeNodeRecord)((Object)parent3)).getChildCount() + 1;
            ((DBTreeNodeRecord)((Object)parent3)).setChildCount(newChildCount);
            if (newChildCount <= this.maxChildren) break;
            propa = parent3;
            parent3 = this.getParentOf((DBTreeRecord<?, ?>)((Object)propa));
            split = (DBTreeRecord)((Object)this.doOverflowTreatment(propa, levelInfo.decLevel()));
        }
        levelInfo.dstLevel = savedLevel;
    }

    protected NR doOverflowTreatment(NR n, LevelInfo levelInfo) {
        if (n != this.root && !levelInfo.checkAndSetReinserted()) {
            this.doReInsert(n, levelInfo);
            return null;
        }
        return this.doSplit(n);
    }

    protected void doReInsert(NR n, LevelInfo levelInfo) {
        PriorityQueue<LeastDistanceFromCenterToPoint> farthest = new PriorityQueue<LeastDistanceFromCenterToPoint>();
        Iterator it = this.getChildrenOf(n).iterator();
        for (int i = 0; i < this.reinsertCount; ++i) {
            assert (it.hasNext());
            DBTreeRecord next = it.next();
            farthest.add(new LeastDistanceFromCenterToPoint(this, next, (BoundingShape)((DBTreeRecord)((Object)n)).getShape()));
        }
        BoundingShape boundsNearest = null;
        int dataCountNearest = 0;
        while (it.hasNext()) {
            DBTreeRecord next = it.next();
            farthest.add(new LeastDistanceFromCenterToPoint(this, next, (BoundingShape)((DBTreeRecord)((Object)n)).getShape()));
            LeastDistanceFromCenterToPoint near = (LeastDistanceFromCenterToPoint)farthest.poll();
            boundsNearest = (BoundingShape)(boundsNearest == null ? near.record.getBounds() : boundsNearest.unionBounds(near.record.getBounds()));
            dataCountNearest += near.record.getDataCount();
        }
        assert (farthest.size() == this.reinsertCount);
        ((DBTreeNodeRecord)((Object)n)).setChildCount(this.maxChildren + 1 - this.reinsertCount);
        ((DBTreeRecord)((Object)n)).setShape(boundsNearest);
        int dataCountReduction = ((DBTreeRecord)((Object)n)).getDataCount() - dataCountNearest;
        ((DBTreeNodeRecord)((Object)n)).setDataCount(dataCountNearest);
        Object p = this.getParentOf((DBTreeRecord<?, ?>)((Object)n));
        while (p != null) {
            int newDataCount = ((DBTreeRecord)((Object)p)).getDataCount() - dataCountReduction;
            ((DBTreeNodeRecord)((Object)p)).setDataCount(newDataCount);
            Collection childBounds = Collections2.transform(this.getChildrenOf(p), DBTreeRecord::getBounds);
            Object newBounds = BoundingShape.boundsUnion(childBounds);
            ((DBTreeRecord)((Object)p)).setShape(newBounds);
            p = this.getParentOf((DBTreeRecord<?, ?>)((Object)p));
        }
        while (!farthest.isEmpty()) {
            LeastDistanceFromCenterToPoint far = (LeastDistanceFromCenterToPoint)farthest.poll();
            this.doInsert(far.record, levelInfo);
        }
    }

    @Override
    protected void checkNodeIntegrity(NR n) {
        super.checkNodeIntegrity(n);
        if (((DBTreeNodeRecord)((Object)n)).getChildCount() > this.maxChildren) {
            throw new AssertionError((Object)"Node exceeds the maximum children");
        }
    }

    protected static class LevelInfo {
        int dstLevel;
        long reinsertedLevels = 0L;

        public LevelInfo(int dstLevel) {
            this.dstLevel = dstLevel;
        }

        public boolean checkAndSetReinserted() {
            if ((this.reinsertedLevels >> this.dstLevel & 1L) != 0L) {
                return true;
            }
            this.reinsertedLevels |= (long)(1 << this.dstLevel);
            return false;
        }

        public LevelInfo decLevel() {
            --this.dstLevel;
            return this;
        }

        public void incDepth() {
            ++this.dstLevel;
            this.reinsertedLevels <<= 1;
        }
    }

    protected static class LeastDistanceFromCenterToPoint
    implements Comparable<LeastDistanceFromCenterToPoint> {
        private final DBTreeRecord<?, ? extends NS> record;
        private final double distance;
        final /* synthetic */ AbstractRStarConstraintsTree this$0;

        public LeastDistanceFromCenterToPoint(DBTreeRecord<?, ? extends NS> record, NS parentBounds) {
            this.this$0 = this$0;
            this.record = record;
            this.distance = parentBounds.computeCentroidDistance(record.getBounds());
        }

        public String toString() {
            return String.format("<least-distance: %s,record=%s>", new Object[]{this.distance, this.record});
        }

        @Override
        public int compareTo(LeastDistanceFromCenterToPoint that) {
            return Double.compare(this.distance, that.distance);
        }
    }

    protected static class LeastAreaEnlargementThenLeastArea
    implements Comparable<LeastAreaEnlargementThenLeastArea> {
        private final NR node;
        private final double areaEnlargement;
        private final double area;
        final /* synthetic */ AbstractRStarConstraintsTree this$0;

        public LeastAreaEnlargementThenLeastArea(NR node, NS bounds) {
            this.this$0 = this$0;
            this.node = node;
            this.area = ((BoundingShape)((DBTreeRecord)((Object)node)).getShape()).getArea();
            this.areaEnlargement = ((BoundingShape)((DBTreeRecord)((Object)node)).getShape()).computeAreaUnionBounds(bounds) - this.area;
        }

        public String toString() {
            return String.format("<least-enlargement: %s, node=%s>", this.areaEnlargement, this.node);
        }

        @Override
        public int compareTo(LeastAreaEnlargementThenLeastArea that) {
            int result = Double.compare(this.areaEnlargement, that.areaEnlargement);
            if (result != 0) {
                return result;
            }
            result = Double.compare(this.area, that.area);
            if (result != 0) {
                return result;
            }
            return 0;
        }
    }
}

