/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database;

import ghidra.framework.data.DomainObjectAdapterDB;
import java.util.Objects;

public class ObjectKey
implements Comparable<ObjectKey> {
    private final DomainObjectAdapterDB adapter;
    private final String tableName;
    private final long key;
    private final int hash;

    public ObjectKey(DomainObjectAdapterDB adapter, String tableName, long key) {
        this.adapter = adapter;
        this.tableName = tableName;
        this.key = key;
        this.hash = Objects.hash(System.identityHashCode(adapter), tableName, key);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ObjectKey)) {
            return false;
        }
        ObjectKey that = (ObjectKey)obj;
        if (this.adapter != that.adapter) {
            return false;
        }
        if (!Objects.equals(this.tableName, that.tableName)) {
            return false;
        }
        return this.key == that.key;
    }

    public int hashCode() {
        return this.hash;
    }

    @Override
    public int compareTo(ObjectKey that) {
        if (this.adapter != that.adapter) {
            int result = this.adapter.getName().compareTo(that.adapter.getName());
            if (result != 0) {
                return result;
            }
            return System.identityHashCode(this.adapter) - System.identityHashCode(that.adapter);
        }
        int result = this.tableName.compareTo(that.tableName);
        if (result != 0) {
            return result;
        }
        result = Long.compareUnsigned(this.key, that.key);
        if (result != 0) {
            return result;
        }
        return 0;
    }
}

