/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database;

import db.DBHandle;
import java.io.IOException;

public class DBTransaction
implements AutoCloseable {
    private final DBHandle handle;
    private final long tid;
    private boolean commit;
    private boolean open = true;

    public static DBTransaction start(DBHandle handle, boolean commitByDefault) {
        long tid = handle.startTransaction();
        return new DBTransaction(handle, tid, commitByDefault);
    }

    private DBTransaction(DBHandle handle, long tid, boolean commitByDefault) {
        this.handle = handle;
        this.tid = tid;
        this.commit = commitByDefault;
    }

    public void abort() throws IOException {
        this.open = false;
        this.handle.endTransaction(this.tid, false);
    }

    public void commit() throws IOException {
        this.open = false;
        this.handle.endTransaction(this.tid, true);
    }

    @Override
    public void close() throws IOException {
        if (this.open) {
            this.handle.endTransaction(this.tid, this.commit);
        }
    }
}

