/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.plugintool;

import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.annotation.AutoServiceProvided;
import ghidra.framework.plugintool.util.AutoServiceListener;
import ghidra.util.Msg;
import java.lang.reflect.Field;

public interface AutoService {
    public static Wiring wireServicesProvidedAndConsumed(Plugin plugin) {
        AutoService.registerServicesProvided(plugin, plugin.getClass(), plugin);
        return AutoService.wireServicesConsumed(plugin, (Object)plugin);
    }

    public static void registerServicesProvided(Plugin plugin, Class<?> cls, Object provider) {
        Class<?> superclass = cls.getSuperclass();
        if (superclass != null) {
            AutoService.registerServicesProvided(plugin, superclass, provider);
        }
        for (Field f : cls.getDeclaredFields()) {
            Class<?> type;
            AutoServiceProvided annotation = f.getAnnotation(AutoServiceProvided.class);
            if (annotation == null) continue;
            Class<?> iface = annotation.iface();
            if (!iface.isAssignableFrom(type = f.getType())) {
                Msg.error(AutoService.class, (Object)(type + " does not implement service interface " + iface));
                continue;
            }
            boolean wasAccessible = f.isAccessible();
            f.setAccessible(true);
            try {
                plugin.registerServiceProvided(iface, f.get(provider));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new AssertionError((Object)e);
            }
            f.setAccessible(wasAccessible);
        }
    }

    public static Wiring wireServicesConsumed(PluginTool tool, Object receiver) {
        AutoServiceListener<Object> listener = new AutoServiceListener<Object>(receiver);
        tool.addServiceListener(listener);
        listener.notifyCurrentServices(tool);
        return new WiringImpl(listener);
    }

    public static Wiring wireServicesConsumed(Plugin plugin, Object receiver) {
        return AutoService.wireServicesConsumed(plugin.getTool(), receiver);
    }

    public static class WiringImpl
    implements Wiring {
        private AutoServiceListener<?> listener;

        public WiringImpl(AutoServiceListener<?> listener) {
            this.listener = listener;
        }

        @Override
        public void dispose() {
            this.listener = null;
        }
    }

    public static interface Wiring {
        public void dispose();
    }
}

