/*
 * Decompiled with CFR 0.152.
 */
package ghidra.async;

import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class AsyncLazyValue<T> {
    private CompletableFuture<T> future;
    private Throwable lastExc = null;
    private Supplier<CompletableFuture<T>> supplier;

    public AsyncLazyValue(Supplier<CompletableFuture<T>> supplier) {
        this.supplier = supplier;
    }

    public synchronized CompletableFuture<T> request() {
        if (this.future == null) {
            this.future = this.supplier.get();
            this.future.exceptionally(exc -> {
                AsyncLazyValue asyncLazyValue = this;
                synchronized (asyncLazyValue) {
                    this.lastExc = exc;
                    this.future = null;
                }
                return null;
            });
        }
        if (this.future == null) {
            return CompletableFuture.failedFuture(this.lastExc);
        }
        return this.future;
    }

    public synchronized CompletableFuture<T> provide() {
        if (this.future == null) {
            this.future = new CompletableFuture();
            this.future.exceptionally(exc -> {
                AsyncLazyValue asyncLazyValue = this;
                synchronized (asyncLazyValue) {
                    this.future = null;
                }
                return ExceptionUtils.rethrow((Throwable)exc);
            });
        }
        return this.future;
    }

    public synchronized void forget() {
        this.future = null;
    }

    public synchronized String toString() {
        if (this.future == null) {
            return "(lazy)";
        }
        if (!this.future.isDone()) {
            return "(lazy-req)";
        }
        if (this.future.isCompletedExceptionally()) {
            return "(lazy-err)";
        }
        return this.future.getNow(null).toString();
    }

    public synchronized boolean isBusy() {
        return this.future != null && !this.future.isDone();
    }

    public synchronized boolean isDone() {
        return this.future != null && this.future.isDone();
    }
}

