/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.manager.cmd;

import agent.dbgeng.dbgeng.DebugProcessId;
import agent.dbgeng.dbgeng.DebugSystemObjects;
import agent.dbgeng.manager.DbgCause;
import agent.dbgeng.manager.DbgProcess;
import agent.dbgeng.manager.cmd.AbstractDbgCommand;
import agent.dbgeng.manager.cmd.DbgPendingCommand;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DbgListProcessesCommand
extends AbstractDbgCommand<Map<DebugProcessId, DbgProcess>> {
    private List<DebugProcessId> updatedProcessIds;

    public DbgListProcessesCommand(DbgManagerImpl manager) {
        super(manager);
    }

    @Override
    public Map<DebugProcessId, DbgProcess> complete(DbgPendingCommand<?> pending) {
        Map<DebugProcessId, DbgProcess> allProcesses = this.manager.getKnownProcesses();
        Set<DebugProcessId> cur = allProcesses.keySet();
        for (DebugProcessId id : this.updatedProcessIds) {
            if (cur.contains(id)) continue;
            Msg.warn((Object)this, (Object)("Resync: Was missing group: i" + id));
            DebugSystemObjects so = this.manager.getSystemObjects();
            so.setCurrentProcessId(id);
            int pid = so.getCurrentProcessSystemId();
            this.manager.getProcessComputeIfAbsent(id, pid);
        }
        for (DebugProcessId id : new ArrayList<DebugProcessId>(cur)) {
            if (this.updatedProcessIds.contains(id)) continue;
            Msg.warn((Object)this, (Object)("Resync: Had extra group: i" + id));
            this.manager.removeProcess(id, DbgCause.Causes.UNCLAIMED);
        }
        return allProcesses;
    }

    @Override
    public void invoke() {
        DebugSystemObjects so = this.manager.getSystemObjects();
        this.updatedProcessIds = so.getProcesses();
    }
}

