/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Format;

import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Format.Instruction5rc;
import org.jf.dexlib.Code.Format.InstructionWithJumboVariant;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.InstructionWithReference;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.Code.RegisterRangeInstruction;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Item;
import org.jf.dexlib.MethodIdItem;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.NumberUtils;

public class Instruction3rc
extends InstructionWithReference
implements RegisterRangeInstruction,
InstructionWithJumboVariant {
    public static final Instruction.InstructionFactory Factory = new Factory();
    private byte regCount;
    private short startReg;

    public Instruction3rc(Opcode opcode, short regCount, int startReg, Item referencedItem) {
        super(opcode, referencedItem);
        if (regCount >= 256) {
            throw new RuntimeException("regCount must be less than 256");
        }
        if (regCount < 0) {
            throw new RuntimeException("regCount cannot be negative");
        }
        if (startReg >= 65536) {
            throw new RuntimeException("The beginning register of the range must be less than 65536");
        }
        if (startReg < 0) {
            throw new RuntimeException("The beginning register of the range cannot be negative");
        }
        this.regCount = (byte)regCount;
        this.startReg = (short)startReg;
        Instruction3rc.checkItem(opcode, referencedItem, regCount);
    }

    private Instruction3rc(DexFile dexFile, Opcode opcode, byte[] buffer, int bufferIndex) {
        super(dexFile, opcode, buffer, bufferIndex);
        this.regCount = (byte)NumberUtils.decodeUnsignedByte(buffer[bufferIndex + 1]);
        this.startReg = (short)NumberUtils.decodeUnsignedShort(buffer, bufferIndex + 4);
        Instruction3rc.checkItem(opcode, this.getReferencedItem(), this.getRegCount());
    }

    @Override
    protected void writeInstruction(AnnotatedOutput out, int currentCodeAddress) {
        if (this.getReferencedItem().getIndex() > 65535) {
            if (this.opcode.hasJumboOpcode()) {
                throw new RuntimeException(String.format("%s index is too large. Use the %s instruction instead.", this.opcode.referenceType.name(), this.opcode.getJumboOpcode().name));
            }
            throw new RuntimeException(String.format("%s index is too large.", this.opcode.referenceType.name()));
        }
        out.writeByte(this.opcode.value);
        out.writeByte(this.regCount);
        out.writeShort(this.getReferencedItem().getIndex());
        out.writeShort(this.startReg);
    }

    @Override
    public Format getFormat() {
        return Format.Format3rc;
    }

    @Override
    public int getRegCount() {
        return (short)(this.regCount & 0xFF);
    }

    @Override
    public int getStartRegister() {
        return this.startReg & 0xFFFF;
    }

    private static void checkItem(Opcode opcode, Item item, int regCount) {
        if (opcode == Opcode.FILLED_NEW_ARRAY_RANGE) {
            String type = ((TypeIdItem)item).getTypeDescriptor();
            if (type.charAt(0) != '[') {
                throw new RuntimeException("The type must be an array type");
            }
            if (type.charAt(1) == 'J' || type.charAt(1) == 'D') {
                throw new RuntimeException("The type cannot be an array of longs or doubles");
            }
        } else if (opcode.value >= Opcode.INVOKE_VIRTUAL_RANGE.value && opcode.value <= Opcode.INVOKE_INTERFACE_RANGE.value || opcode == Opcode.INVOKE_OBJECT_INIT_RANGE) {
            MethodIdItem methodIdItem = (MethodIdItem)item;
            int parameterRegisterCount = methodIdItem.getPrototype().getParameterRegisterCount();
            if (opcode != Opcode.INVOKE_STATIC_RANGE) {
                ++parameterRegisterCount;
            }
            if (parameterRegisterCount != regCount) {
                throw new RuntimeException("regCount does not match the number of arguments of the method");
            }
        }
    }

    @Override
    public Instruction makeJumbo() {
        Opcode jumboOpcode = this.opcode.getJumboOpcode();
        if (jumboOpcode == null) {
            return null;
        }
        return new Instruction5rc(jumboOpcode, this.getRegCount(), this.getStartRegister(), this.getReferencedItem());
    }

    private static class Factory
    implements Instruction.InstructionFactory {
        private Factory() {
        }

        @Override
        public Instruction makeInstruction(DexFile dexFile, Opcode opcode, byte[] buffer, int bufferIndex) {
            return new Instruction3rc(dexFile, opcode, buffer, bufferIndex);
        }
    }
}

