/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.job;

import ghidra.graph.job.GraphJob;
import ghidra.graph.job.GraphJobListener;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.datastruct.QueueStub;
import ghidra.util.exception.AssertException;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Queue;
import utility.function.Callback;

public class GraphJobRunner
implements GraphJobListener {
    private Queue<GraphJob> queue = new LinkedList<GraphJob>();
    private GraphJob finalJob;
    private GraphJob currentJob;
    private boolean isShortcutting = false;

    public void schedule(GraphJob job) {
        this.trace("schedule() - " + job);
        Objects.requireNonNull(job, "Graph job cannot be null");
        if (job.isFinished()) {
            throw new IllegalArgumentException("cannot schedule a finished job!");
        }
        this.queue.add(job);
        this.swing(this::shortCutAndRunNextJob);
    }

    private void swing(Runnable r) {
        SystemUtilities.runIfSwingOrPostSwingLater((Runnable)r);
    }

    public synchronized void setFinalJob(GraphJob job) {
        this.trace("setFinalJob() - " + job);
        if (job.isFinished()) {
            throw new IllegalArgumentException("cannot schedule a finished job!");
        }
        this.finalJob = Objects.requireNonNull(job, "Graph job cannot be null");
        this.swing(this::maybeRunNextJob);
    }

    public synchronized boolean isBusy() {
        if (!this.queue.isEmpty()) {
            return true;
        }
        if (this.finalJob != null) {
            return true;
        }
        return this.currentJob != null;
    }

    synchronized GraphJob getCurrentJob() {
        return this.currentJob;
    }

    public void finishAllJobs() {
        this.swing(this::shortCutAll);
    }

    public synchronized void dispose() {
        this.trace("dispose()");
        this.clearAllJobs();
        this.queue = new QueueStub();
    }

    private synchronized void clearAllJobs() {
        this.trace("clearAllJobs()");
        this.finalJob = null;
        Queue<GraphJob> oldQueue = this.queue;
        this.queue = new QueueStub();
        oldQueue.clear();
        this.trace("\tcurrent job: " + this.currentJob);
        if (this.currentJob != null) {
            this.currentJob.dispose();
        }
        this.currentJob = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void jobFinished(GraphJob job) {
        String methodName = "jobFinished()";
        this.trace(methodName + " " + job);
        SystemUtilities.assertThisIsTheSwingThread((String)"jobFinished() must be called in the Swing thread.");
        GraphJobRunner graphJobRunner = this;
        synchronized (graphJobRunner) {
            if (this.currentJob != null && job != this.currentJob) {
                throw new AssertException("Received a callback from a job that is not my current job! Current job: " + this.currentJob + " and finished job: " + job);
            }
            this.trace("\t" + methodName + " setting currentJob to null");
            this.currentJob = null;
            this.maybeRunNextJob();
        }
    }

    private synchronized void shortCutAndRunNextJob() {
        String methodName = "shortcut()";
        this.trace(methodName + " - currentJob?: " + this.currentJob);
        if (this.queue.isEmpty()) {
            this.trace("\t" + methodName + " no pending jobs; leaving");
            return;
        }
        this.performShortcutFunction(() -> this.shortcutAsMuchAsPossible(false));
        this.trace("\t" + methodName + " at end; calling runNextJob()");
        this.maybeRunNextJob();
    }

    private synchronized void shortCutAll() {
        String methodName = "shortcutAll()";
        this.trace(methodName + " - currentJob?: " + this.currentJob);
        this.performShortcutFunction(() -> {
            boolean allWereShortcut = this.shortcutAsMuchAsPossible(true);
            this.trace("\t\twere all jobs shortcut? " + allWereShortcut);
            if (allWereShortcut) {
                this.shortcutFinalJob();
            }
        });
    }

    private void performShortcutFunction(Callback callback) {
        this.isShortcutting = true;
        this.trace("\tset isShortcutting = true");
        try {
            callback.call();
        }
        finally {
            this.isShortcutting = false;
            this.trace("\t\tset isShortcutting = false");
        }
    }

    private boolean shortcutAsMuchAsPossible(boolean shortcutAll) {
        if (!this.shortcutCurrentJob()) {
            return false;
        }
        return this.shortcutPendingJobs(shortcutAll);
    }

    private boolean shortcutCurrentJob() {
        String methodName = "shortcutCurrentJob()";
        if (this.currentJob == null) {
            return true;
        }
        if (!this.currentJob.canShortcut()) {
            this.trace("\t" + methodName + " current job cannot be shortcut; leaving");
            return false;
        }
        this.trace("\t" + methodName + " calling shortcut on current job: " + this.currentJob);
        GraphJob job = this.currentJob;
        this.currentJob = null;
        job.shortcut();
        this.trace("\t\t" + methodName + " after calling shortcut on current job: " + job);
        return true;
    }

    private boolean shortcutPendingJobs(boolean shortcutAll) {
        int limit;
        String methodName = "shortcutPendingJobs()";
        this.trace("\t" + methodName + " queued job count: " + this.queue.size());
        int n = limit = shortcutAll ? 0 : 1;
        while (this.queue.size() > limit) {
            GraphJob nextJob = this.queue.peek();
            if (!nextJob.canShortcut()) {
                this.trace("\t" + methodName + " found pending job; cannot shortcut: " + nextJob);
                return false;
            }
            nextJob = this.queue.poll();
            this.trace("\t" + methodName + " calling shortcut on pending job: " + nextJob);
            nextJob.shortcut();
            this.trace("\t\t" + methodName + " after calling shortcut on pending job: " + nextJob);
        }
        return true;
    }

    private void shortcutFinalJob() {
        this.trace("shortcutFinalJob() - " + this.finalJob);
        if (this.finalJob != null && this.finalJob.canShortcut()) {
            this.finalJob.shortcut();
            this.finalJob = null;
        }
    }

    private synchronized void maybeRunNextJob() {
        String methodName = "maybeRunNextJob()";
        this.trace(methodName);
        if (this.isShortcutting) {
            this.trace("\t" + methodName + " shortcutting the queue - not running the next job " + this.currentJob);
            return;
        }
        this.trace("\t" + methodName + " currentJob: " + this.currentJob);
        if (this.currentJob != null) {
            this.trace("\t" + methodName + " is it finished?: " + this.currentJob.isFinished());
            if (this.currentJob.isFinished()) {
                throw new IllegalStateException("The following job did not call jobFinished() after performing its work: " + this.currentJob);
            }
            this.trace("\t" + methodName + " not running another job; current job is not finished");
            return;
        }
        GraphJob nextJob = this.queue.poll();
        if (nextJob != null) {
            this.trace("\t" + methodName + " setting currentJob to: " + nextJob + " and last job: " + this.currentJob);
            this.currentJob = nextJob;
            this.currentJob.execute(this);
            return;
        }
        if (this.finalJob != null) {
            this.trace("\t" + methodName + " setting currentJob to final job: " + this.finalJob + " and last job: " + this.currentJob);
            this.currentJob = this.finalJob;
            this.finalJob = null;
            this.currentJob.execute(this);
        }
    }

    private void trace(String message) {
        Msg.trace((Object)this, (Object)message);
    }
}

