/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.module;

import com.google.common.collect.Range;
import db.DBRecord;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.database.address.DBTraceOverlaySpaceAdapter;
import ghidra.trace.database.module.DBTraceStaticMappingManager;
import ghidra.trace.model.Trace;
import ghidra.trace.model.modules.TraceStaticMapping;
import ghidra.util.LockHold;
import ghidra.util.database.DBAnnotatedObject;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.annot.DBAnnotatedColumn;
import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.database.annot.DBAnnotatedObjectInfo;
import java.io.IOException;
import java.net.URL;
import java.util.Objects;
import java.util.concurrent.locks.Lock;

@DBAnnotatedObjectInfo(version=0)
public class DBTraceStaticMapping
extends DBAnnotatedObject
implements TraceStaticMapping,
DBTraceOverlaySpaceAdapter.DecodesAddresses {
    public static final String TABLE_NAME = "StaticMappings";
    static final String TRACE_ADDRESS_COLUMN_NAME = "TraceAddress";
    static final String LENGTH_COLUMN_NAME = "Length";
    static final String START_SNAP_COLUMN_NAME = "StartSnap";
    static final String END_SNAP_COLUMN_NAME = "EndSnap";
    static final String STATIC_PROGRAM_COLUMN_NAME = "StaticProgram";
    static final String STATIC_ADDRESS_COLUMN_NAME = "StaticAddress";
    @DBAnnotatedColumn(value="TraceAddress")
    static DBObjectColumn TRACE_ADDRESS_COLUMN;
    @DBAnnotatedColumn(value="Length")
    static DBObjectColumn LENGTH_COLUMN;
    @DBAnnotatedColumn(value="StartSnap")
    static DBObjectColumn START_SNAP_COLUMN;
    @DBAnnotatedColumn(value="EndSnap")
    static DBObjectColumn END_SNAP_COLUMN;
    @DBAnnotatedColumn(value="StaticProgram")
    static DBObjectColumn STATIC_PROGRAM_COLUMN;
    @DBAnnotatedColumn(value="StaticAddress")
    static DBObjectColumn STATIC_ADDRESS_COLUMN;
    @DBAnnotatedField(column="TraceAddress", indexed=true, codec=DBTraceOverlaySpaceAdapter.AddressDBFieldCodec.class)
    private Address traceAddress;
    @DBAnnotatedField(column="Length")
    private long length;
    @DBAnnotatedField(column="StartSnap")
    private long startSnap;
    @DBAnnotatedField(column="EndSnap")
    private long endSnap;
    @DBAnnotatedField(column="StaticProgram", codec=DBTraceUtils.URLDBFieldCodec.class)
    private URL staticProgramURL;
    @DBAnnotatedField(column="StaticAddress")
    private String staticAddress;
    private final DBTraceStaticMappingManager manager;
    private AddressRange traceRange;
    private long shift;
    private Range<Long> lifespan;

    protected static String parseSpace(String addrStr) {
        String[] parts = addrStr.split(":");
        if (parts.length == 1) {
            return null;
        }
        if (parts.length == 2) {
            return parts[0];
        }
        throw new IllegalArgumentException("Address string should have at most one colon (:)");
    }

    protected static long parseOffset(String addrStr) {
        String[] parts = addrStr.split(":");
        assert (parts.length <= 2);
        return Long.parseUnsignedLong(parts[parts.length - 1], 16);
    }

    public DBTraceStaticMapping(DBTraceStaticMappingManager manager, DBCachedObjectStore<?> store, DBRecord record) {
        super(store, record);
        this.manager = manager;
    }

    protected void fresh(boolean created) throws IOException {
        if (created) {
            return;
        }
        try {
            this.traceRange = new AddressRangeImpl(this.traceAddress, this.traceAddress.addNoWrap(this.length - 1L));
        }
        catch (AddressOverflowException e) {
            throw new AssertionError((Object)e);
        }
        this.shift = this.traceAddress.getOffset() - DBTraceStaticMapping.parseOffset(this.staticAddress);
        this.lifespan = DBTraceUtils.toRange(this.startSnap, this.endSnap);
    }

    void set(AddressRange traceRange, Range<Long> lifespan, URL staticProgramURL, String staticAddress) {
        if (this.startSnap == -1L) {
            throw new IllegalArgumentException("endpoint cannot be -1");
        }
        this.traceRange = traceRange;
        this.traceAddress = traceRange.getMinAddress();
        this.length = traceRange.getLength();
        this.lifespan = lifespan;
        this.startSnap = DBTraceUtils.lowerEndpoint(lifespan);
        this.endSnap = DBTraceUtils.upperEndpoint(lifespan);
        this.staticProgramURL = staticProgramURL;
        this.staticAddress = staticAddress;
        this.update(new DBObjectColumn[]{TRACE_ADDRESS_COLUMN, LENGTH_COLUMN, START_SNAP_COLUMN, END_SNAP_COLUMN, STATIC_PROGRAM_COLUMN, STATIC_ADDRESS_COLUMN});
        this.shift = this.traceAddress.getOffset() - DBTraceStaticMapping.parseOffset(staticAddress);
    }

    @Override
    public DBTraceOverlaySpaceAdapter getOverlaySpaceAdapter() {
        return this.manager.overlayAdapter;
    }

    @Override
    public Trace getTrace() {
        return this.manager.trace;
    }

    @Override
    public AddressRange getTraceAddressRange() {
        return this.traceRange;
    }

    @Override
    public Address getMinTraceAddress() {
        return this.traceAddress;
    }

    @Override
    public Address getMaxTraceAddress() {
        return this.traceRange.getMaxAddress();
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public long getShift() {
        return this.shift;
    }

    @Override
    public Range<Long> getLifespan() {
        return this.lifespan;
    }

    @Override
    public long getStartSnap() {
        return this.startSnap;
    }

    @Override
    public long getEndSnap() {
        return this.endSnap;
    }

    @Override
    public URL getStaticProgramURL() {
        return this.staticProgramURL;
    }

    @Override
    public String getStaticAddress() {
        return this.staticAddress;
    }

    @Override
    public void delete() {
        this.manager.delete(this);
    }

    @Override
    public boolean conflictsWith(AddressRange range, Range<Long> lifespan, URL toProgramURL, String toAddress) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            long thatFromOffset;
            long thisFromOffset;
            long fromOffsetDiff;
            long thatToOffset;
            String thatToSpace;
            if (!this.traceRange.intersects(range)) {
                boolean bl = false;
                return bl;
            }
            if (!DBTraceUtils.intersect(this.lifespan, lifespan)) {
                boolean bl = false;
                return bl;
            }
            if (!Objects.equals(this.staticProgramURL, toProgramURL)) {
                boolean bl = true;
                return bl;
            }
            String thisToSpace = DBTraceStaticMapping.parseSpace(this.staticAddress);
            if (!Objects.equals(thisToSpace, thatToSpace = DBTraceStaticMapping.parseSpace(toAddress))) {
                boolean bl = true;
                return bl;
            }
            long thisToOffset = DBTraceStaticMapping.parseOffset(this.staticAddress);
            long toOffsetDiff = thisToOffset - (thatToOffset = DBTraceStaticMapping.parseOffset(toAddress));
            if (toOffsetDiff != (fromOffsetDiff = (thisFromOffset = this.traceRange.getMinAddress().getOffset()) - (thatFromOffset = range.getMinAddress().getOffset()))) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }
}

