/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile;

import docking.ComponentProvider;
import ghidra.app.context.NavigatableActionContext;
import ghidra.app.context.RestrictedAddressSetContext;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.ClangTokenGroup;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.app.nav.Navigatable;
import ghidra.app.plugin.core.decompile.DecompilerProvider;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.pcode.HighFunction;
import ghidra.util.Msg;
import ghidra.util.UndefinedFunction;
import java.awt.Component;
import java.util.function.Supplier;
import utility.function.Callback;

public class DecompilerActionContext
extends NavigatableActionContext
implements RestrictedAddressSetContext {
    private final Address functionEntryPoint;
    private final boolean isDecompiling;
    private ClangToken tokenAtCursor = null;
    private boolean tokenIsInitialized = false;

    public DecompilerActionContext(DecompilerProvider provider, Address functionEntryPoint, boolean isDecompiling) {
        super((ComponentProvider)provider, (Navigatable)provider);
        this.functionEntryPoint = functionEntryPoint;
        this.isDecompiling = isDecompiling;
    }

    public Address getFunctionEntryPoint() {
        return this.functionEntryPoint;
    }

    public boolean isDecompiling() {
        return this.isDecompiling;
    }

    public DecompilerProvider getComponentProvider() {
        return (DecompilerProvider)super.getComponentProvider();
    }

    public PluginTool getTool() {
        return this.getComponentProvider().getTool();
    }

    public ClangToken getTokenAtCursor() {
        if (!this.tokenIsInitialized) {
            this.tokenAtCursor = this.getDecompilerPanel().getTokenAtCursor();
            this.tokenIsInitialized = true;
        }
        return this.tokenAtCursor;
    }

    public DecompilerPanel getDecompilerPanel() {
        return this.getComponentProvider().getDecompilerPanel();
    }

    public Function getFunction() {
        return this.getComponentProvider().getController().getFunction();
    }

    public HighFunction getHighFunction() {
        return this.getComponentProvider().getController().getHighFunction();
    }

    public ClangTokenGroup getCCodeModel() {
        return this.getComponentProvider().getController().getCCodeModel();
    }

    public boolean hasRealFunction() {
        Function f = this.getFunction();
        return f != null && !(f instanceof UndefinedFunction);
    }

    public void setStatusMessage(String msg) {
        this.getComponentProvider().getController().setStatusMessage(msg);
    }

    public void performAction(Callback actionCallback) {
        if (this.isDecompiling) {
            Msg.showInfo(((Object)((Object)this)).getClass(), (Component)this.getComponentProvider().getComponent(), (String)"Decompiler Action Blocked", (Object)"You cannot perform Decompiler actions while the Decompiler is busy");
            return;
        }
        actionCallback.call();
    }

    public boolean checkActionEnablement(Supplier<Boolean> actionBooleanSupplier) {
        if (this.isDecompiling()) {
            return true;
        }
        return actionBooleanSupplier.get();
    }
}

