/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.help.HelpDescriptor;
import docking.help.HelpService;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.net.URL;
import javax.swing.JButton;

public class DefaultHelpService
implements HelpService {
    @Override
    public void showHelp(Object helpObj, boolean infoOnly, Component parent) {
        if (infoOnly) {
            this.displayHelpInfo(helpObj);
            return;
        }
    }

    @Override
    public void showHelp(URL url) {
    }

    @Override
    public void showHelp(HelpLocation location) {
    }

    @Override
    public void excludeFromHelp(Object helpObject) {
    }

    @Override
    public boolean isExcludedFromHelp(Object helpObject) {
        return false;
    }

    @Override
    public void clearHelp(Object helpObject) {
    }

    @Override
    public void registerHelp(Object helpObj, HelpLocation helpLocation) {
    }

    @Override
    public HelpLocation getHelpLocation(Object object) {
        return null;
    }

    @Override
    public boolean helpExists() {
        return false;
    }

    private void displayHelpInfo(Object helpObj) {
        String msg = this.getHelpInfo(helpObj);
        Msg.showInfo((Object)this, null, (String)"Help Info", (Object)msg);
    }

    private String getHelpInfo(Object helpObj) {
        if (helpObj == null) {
            return "Help Object is null";
        }
        StringBuilder buffy = new StringBuilder();
        buffy.append("HELP OBJECT: " + helpObj.getClass().getName());
        buffy.append("\n");
        if (helpObj instanceof HelpDescriptor) {
            HelpDescriptor helpDescriptor = (HelpDescriptor)helpObj;
            buffy.append(helpDescriptor.getHelpInfo());
        } else if (helpObj instanceof JButton) {
            Container c;
            JButton button = (JButton)helpObj;
            buffy.append("   BUTTON: " + button.getText());
            buffy.append("\n");
            for (c = button; c != null && !(c instanceof Window); c = c.getParent()) {
            }
            if (c instanceof Dialog) {
                buffy.append("   DIALOG: " + ((Dialog)c).getTitle());
                buffy.append("\n");
            }
            if (c instanceof Frame) {
                buffy.append("   FRAME: " + ((Frame)c).getTitle());
                buffy.append("\n");
            }
        }
        return buffy.toString();
    }
}

