/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.objects.components;

import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.GTreeSlowLoadingNode;
import docking.widgets.tree.TreeTaskMonitor;
import ghidra.app.plugin.core.debug.gui.objects.DebuggerObjectsProvider;
import ghidra.app.plugin.core.debug.gui.objects.ObjectContainer;
import ghidra.app.plugin.core.debug.gui.objects.components.DummyTargetObject;
import ghidra.app.plugin.core.debug.gui.objects.components.ObjectTree;
import ghidra.dbg.target.TargetExecutionStateful;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetThread;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.ResourceManager;

public class ObjectNode
extends GTreeSlowLoadingNode {
    static final ImageIcon ICON_POPULATED = ResourceManager.loadImage((String)"images/object-populated.png");
    static final ImageIcon ICON_EMPTY = ResourceManager.loadImage((String)"images/object-unpopulated.png");
    static final ImageIcon ICON_RUNNING = ResourceManager.loadImage((String)"images/object-running.png");
    static final ImageIcon ICON_TERMINATED = ResourceManager.loadImage((String)"images/object-terminated.png");
    static final ImageIcon ICON_EVENT = ResourceManager.loadImage((String)"images/register-marker.png");
    private ObjectContainer container;
    private String name;
    private ObjectTree tree;
    private Set<GTreeNode> oldChildren;
    private boolean restructured = false;

    public ObjectNode(ObjectTree tree, ObjectContainer parent, ObjectContainer container) {
        this.tree = tree;
        this.setContainer(tree, parent, container);
    }

    public ObjectContainer getContainer() {
        return this.container;
    }

    public void setContainer(ObjectTree tree, ObjectContainer parent, ObjectContainer container) {
        this.container = container;
        this.name = container.getName();
        if (parent != null) {
            tree.addToMap(parent, container, this);
        }
    }

    public TargetObject getTargetObject() {
        return this.container.getTargetObject();
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.container.getDecoratedName();
    }

    public List<GTreeNode> generateChildren(TaskMonitor monitor) throws CancelledException {
        if (!this.container.isImmutable() || this.isInProgress()) {
            try {
                CompletableFuture<ObjectContainer> cf = this.container.getOffspring();
                if (cf != null) {
                    ObjectContainer oc = cf.get(60L, TimeUnit.SECONDS);
                    return this.tree.update(oc);
                }
            }
            catch (InterruptedException | ExecutionException e) {
                Msg.warn((Object)((Object)this), (Object)e);
            }
            catch (TimeoutException e) {
                Msg.showWarn((Object)((Object)this), (Component)this.container.getProvider().getComponent(), (String)"Timeout Exception", (Object)"Request for children timed - out - try refreshing the node");
            }
        }
        ArrayList<GTreeNode> list = new ArrayList<GTreeNode>();
        if (this.oldChildren != null) {
            list.addAll(this.oldChildren);
        }
        return list;
    }

    public DebuggerObjectsProvider getProvider() {
        return this.container.getProvider();
    }

    public String getDisplayText() {
        return this.getContainer().getDecoratedName();
    }

    public int loadAll(TaskMonitor monitor) throws CancelledException {
        int count = 1;
        if (!this.isLoaded()) {
            return count;
        }
        List children = this.children();
        monitor = new TreeTaskMonitor(monitor, (long)children.size());
        for (GTreeNode child : children) {
            monitor.checkCanceled();
            count += child.loadAll(monitor);
            monitor.incrementProgress(1L);
        }
        return count;
    }

    public Icon getIcon(boolean expanded) {
        ObjectContainer rootContainer;
        Map<String, Object> rootMap;
        DebuggerObjectsProvider provider;
        TargetObject targetObject = this.container.getTargetObject();
        if (targetObject instanceof TargetExecutionStateful) {
            TargetExecutionStateful stateful = (TargetExecutionStateful)targetObject;
            if (stateful.getExecutionState().equals((Object)TargetExecutionStateful.TargetExecutionState.RUNNING)) {
                return ICON_RUNNING;
            }
            if (stateful.getExecutionState().equals((Object)TargetExecutionStateful.TargetExecutionState.TERMINATED)) {
                return ICON_TERMINATED;
            }
        }
        if ((provider = this.getProvider()) != null && (rootMap = (rootContainer = provider.getRoot()).getAttributeMap()).containsKey("_event_thread")) {
            TargetThread targetProcess = (TargetThread)rootMap.get("_event_thread");
            if (this.container.getTargetObject().equals((Object)targetProcess)) {
                return ICON_EVENT;
            }
        }
        return this.container.hasElements() ? ICON_POPULATED : ICON_EMPTY;
    }

    public String getToolTip() {
        return this.container.getDecoratedName();
    }

    public boolean isLeaf() {
        TargetObject to = this.container.getTargetObject();
        return to != null && to instanceof DummyTargetObject;
    }

    public boolean isVisible() {
        return this.container.isVisible();
    }

    public void markExpanded() {
    }

    public void markCollapsed() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUpOldChildren(List<GTreeNode> newChildren) {
        if (this.oldChildren != null) {
            Set<GTreeNode> set = this.oldChildren;
            synchronized (set) {
                this.oldChildren.removeAll(newChildren);
                for (GTreeNode node : this.oldChildren) {
                    this.setRestructured(true);
                    this.tree.cleanupOldNode((ObjectNode)node);
                }
            }
        }
        this.oldChildren = new HashSet<GTreeNode>(newChildren);
    }

    public void callUpdate() {
        CompletableFuture.runAsync(new Runnable(){

            @Override
            public void run() {
                List<GTreeNode> updateNodes = ObjectNode.this.tree.update(ObjectNode.this.container);
                if (ObjectNode.this.isRestructured()) {
                    ObjectNode.this.setChildren(updateNodes);
                }
            }
        });
    }

    public void callModified() {
        CompletableFuture.runAsync(new Runnable(){

            @Override
            public void run() {
                List<GTreeNode> updateNodes = ObjectNode.this.tree.update(ObjectNode.this.container);
                for (GTreeNode n : updateNodes) {
                    n.fireNodeChanged((GTreeNode)ObjectNode.this, n);
                }
            }
        });
    }

    public boolean isRestructured() {
        return this.restructured;
    }

    public void setRestructured(boolean restructured) {
        this.restructured = restructured;
    }
}

