/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.store.local;

import ghidra.util.BigEndianDataConverter;
import ghidra.util.MonitoredOutputStream;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.IOCancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ItemSerializer {
    private static final int MAGIC_NUMBER_POS = 6;
    private static final int MAGIC_NUMBER_SIZE = 8;
    static final long MAGIC_NUMBER = 3328196572606966816L;
    static final int FORMAT_VERSION = 1;
    static final String ZIP_ENTRY_NAME = "FOLDER_ITEM";
    static final int IO_BUFFER_SIZE = 32768;

    private ItemSerializer() {
    }

    public static void outputItem(String itemName, String contentType, int fileType, long length, InputStream content, File packedFile, TaskMonitor monitor) throws CancelledException, IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(packedFile));
        boolean success = false;
        try {
            ObjectOutputStream objOut = new ObjectOutputStream(out);
            objOut.writeLong(3328196572606966816L);
            objOut.writeInt(1);
            objOut.writeUTF(itemName);
            objOut.writeUTF(contentType != null ? contentType : "");
            objOut.writeInt(fileType);
            objOut.writeLong(length);
            objOut.flush();
            ZipOutputStream zipOut = new ZipOutputStream(out);
            ZipEntry entry = new ZipEntry(ZIP_ENTRY_NAME);
            entry.setSize(length);
            entry.setMethod(8);
            zipOut.putNextEntry(entry);
            ZipOutputStream itemOut = zipOut;
            if (monitor != null) {
                itemOut = new MonitoredOutputStream((OutputStream)zipOut, monitor);
                monitor.initialize((long)((int)length));
            }
            long lengthWritten = 0L;
            byte[] buffer = new byte[32768];
            int cnt = 0;
            while ((cnt = content.read(buffer)) > 0) {
                ((OutputStream)itemOut).write(buffer, 0, cnt);
                lengthWritten += (long)cnt;
            }
            if (lengthWritten != length) {
                throw new IOException("Did not write all content - written length is " + lengthWritten + ", expected " + length + ".\n\tItem: " + itemName + " in packed file: " + packedFile.getAbsolutePath());
            }
            ((OutputStream)itemOut).flush();
            zipOut.closeEntry();
            zipOut.flush();
            success = true;
        }
        catch (IOCancelledException e) {
            throw new CancelledException();
        }
        finally {
            try {
                ((OutputStream)out).close();
                if (!success) {
                    packedFile.delete();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPackedFile(File file) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(file));
            boolean bl = ItemSerializer.isPackedFile(inputStream);
            return bl;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static boolean isPackedFile(InputStream inputStream) throws IOException {
        inputStream.skip(6L);
        byte[] magicBytes = new byte[8];
        inputStream.read(magicBytes);
        BigEndianDataConverter dc = BigEndianDataConverter.INSTANCE;
        long magic = dc.getLong(magicBytes);
        return magic == 3328196572606966816L;
    }
}

